/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.SecurityUtilities;
import org.mozilla.javascript.tools.debugger.ContextWindow;
import org.mozilla.javascript.tools.debugger.Dim;
import org.mozilla.javascript.tools.debugger.FileTextArea;
import org.mozilla.javascript.tools.debugger.FileWindow;
import org.mozilla.javascript.tools.debugger.FindFunction;
import org.mozilla.javascript.tools.debugger.GuiCallback;
import org.mozilla.javascript.tools.debugger.JSInternalConsole;
import org.mozilla.javascript.tools.debugger.Menubar;
import org.mozilla.javascript.tools.debugger.MessageDialogWrapper;
import org.mozilla.javascript.tools.debugger.MoreWindows;
import org.mozilla.javascript.tools.debugger.RunProxy;

public class SwingGui
extends JFrame
implements GuiCallback {
    private static final long serialVersionUID = -8217029773456711621L;
    Dim dim;
    private Runnable exitAction;
    private JDesktopPane desk;
    private ContextWindow context;
    private Menubar menubar;
    private JToolBar toolBar;
    private JSInternalConsole console;
    private JSplitPane split1;
    private JLabel statusBar;
    private final Map<String, JFrame> toplevels = Collections.synchronizedMap(new HashMap());
    private final Map<String, FileWindow> fileWindows = Collections.synchronizedMap(new HashMap());
    private FileWindow currentWindow;
    JFileChooser dlg;
    private EventQueue awtEventQueue;

    public SwingGui(Dim dim, String title) {
        super(title);
        this.dim = dim;
        this.init();
        dim.setGuiCallback(this);
    }

    public Menubar getMenubar() {
        return this.menubar;
    }

    public void setExitAction(Runnable r) {
        this.exitAction = r;
    }

    public JSInternalConsole getConsole() {
        return this.console;
    }

    @Override
    public void setVisible(boolean b2) {
        super.setVisible(b2);
        if (b2) {
            this.console.consoleTextArea.requestFocus();
            this.context.split.setDividerLocation(0.5);
            try {
                this.console.setMaximum(true);
                this.console.setSelected(true);
                this.console.show();
                this.console.consoleTextArea.requestFocus();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void addTopLevel(String key2, JFrame frame) {
        if (frame != this) {
            this.toplevels.put(key2, frame);
        }
    }

    private void init() {
        JButton stepOutButton;
        JButton stepOverButton;
        JButton stepIntoButton;
        JButton goButton;
        JButton breakButton;
        this.menubar = new Menubar(this);
        this.setJMenuBar(this.menubar);
        this.toolBar = new JToolBar();
        String[] toolTips = new String[]{"Break (Pause)", "Go (F5)", "Step Into (F11)", "Step Over (F7)", "Step Out (F8)"};
        int count2 = 0;
        JButton button = breakButton = new JButton("Break");
        button.setToolTipText("Break");
        button.setActionCommand("Break");
        button.addActionListener(this.menubar);
        button.setEnabled(true);
        button.setToolTipText(toolTips[count2++]);
        button = goButton = new JButton("Go");
        button.setToolTipText("Go");
        button.setActionCommand("Go");
        button.addActionListener(this.menubar);
        button.setEnabled(false);
        button.setToolTipText(toolTips[count2++]);
        button = stepIntoButton = new JButton("Step Into");
        button.setToolTipText("Step Into");
        button.setActionCommand("Step Into");
        button.addActionListener(this.menubar);
        button.setEnabled(false);
        button.setToolTipText(toolTips[count2++]);
        button = stepOverButton = new JButton("Step Over");
        button.setToolTipText("Step Over");
        button.setActionCommand("Step Over");
        button.setEnabled(false);
        button.addActionListener(this.menubar);
        button.setToolTipText(toolTips[count2++]);
        button = stepOutButton = new JButton("Step Out");
        button.setToolTipText("Step Out");
        button.setActionCommand("Step Out");
        button.setEnabled(false);
        button.addActionListener(this.menubar);
        button.setToolTipText(toolTips[count2++]);
        Dimension dim = stepOverButton.getPreferredSize();
        breakButton.setPreferredSize(dim);
        breakButton.setMinimumSize(dim);
        breakButton.setMaximumSize(dim);
        breakButton.setSize(dim);
        goButton.setPreferredSize(dim);
        goButton.setMinimumSize(dim);
        goButton.setMaximumSize(dim);
        stepIntoButton.setPreferredSize(dim);
        stepIntoButton.setMinimumSize(dim);
        stepIntoButton.setMaximumSize(dim);
        stepOverButton.setPreferredSize(dim);
        stepOverButton.setMinimumSize(dim);
        stepOverButton.setMaximumSize(dim);
        stepOutButton.setPreferredSize(dim);
        stepOutButton.setMinimumSize(dim);
        stepOutButton.setMaximumSize(dim);
        this.toolBar.add(breakButton);
        this.toolBar.add(goButton);
        this.toolBar.add(stepIntoButton);
        this.toolBar.add(stepOverButton);
        this.toolBar.add(stepOutButton);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)contentPane, "Center");
        this.desk = new JDesktopPane();
        this.desk.setPreferredSize(new Dimension(600, 300));
        this.desk.setMinimumSize(new Dimension(150, 50));
        this.console = new JSInternalConsole("JavaScript Console");
        this.desk.add(this.console);
        this.context = new ContextWindow(this);
        this.context.setPreferredSize(new Dimension(600, 120));
        this.context.setMinimumSize(new Dimension(50, 50));
        this.split1 = new JSplitPane(0, this.desk, this.context);
        this.split1.setOneTouchExpandable(true);
        SwingGui.setResizeWeight(this.split1, 0.66);
        contentPane.add((Component)this.split1, "Center");
        this.statusBar = new JLabel();
        this.statusBar.setText("Thread: ");
        contentPane.add((Component)this.statusBar, "South");
        this.dlg = new JFileChooser();
        FileFilter filter2 = new FileFilter(){

            @Override
            public boolean accept(File f2) {
                String ext;
                if (f2.isDirectory()) {
                    return true;
                }
                String n = f2.getName();
                int i2 = n.lastIndexOf(46);
                return i2 > 0 && i2 < n.length() - 1 && (ext = n.substring(i2 + 1).toLowerCase()).equals("js");
            }

            @Override
            public String getDescription() {
                return "JavaScript Files (*.js)";
            }
        };
        this.dlg.addChoosableFileFilter(filter2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                SwingGui.this.exit();
            }
        });
    }

    private void exit() {
        if (this.exitAction != null) {
            SwingUtilities.invokeLater(this.exitAction);
        }
        this.dim.setReturnValue(5);
    }

    FileWindow getFileWindow(String url2) {
        if (url2 == null || url2.equals("<stdin>")) {
            return null;
        }
        return this.fileWindows.get(url2);
    }

    static String getShortName(String url2) {
        int lastSlash = url2.lastIndexOf(47);
        if (lastSlash < 0) {
            lastSlash = url2.lastIndexOf(92);
        }
        String shortName = url2;
        if (lastSlash >= 0 && lastSlash + 1 < url2.length()) {
            shortName = url2.substring(lastSlash + 1);
        }
        return shortName;
    }

    void removeWindow(FileWindow w) {
        this.fileWindows.remove(w.getUrl());
        JMenu windowMenu = this.getWindowMenu();
        int count2 = windowMenu.getItemCount();
        JMenuItem lastItem = windowMenu.getItem(count2 - 1);
        String name = SwingGui.getShortName(w.getUrl());
        for (int i2 = 5; i2 < count2; ++i2) {
            int pos;
            String text;
            JMenuItem item = windowMenu.getItem(i2);
            if (item == null || !(text = item.getText()).substring((pos = text.indexOf(32)) + 1).equals(name)) continue;
            windowMenu.remove(item);
            if (count2 == 6) {
                windowMenu.remove(4);
                break;
            }
            int j2 = i2 - 4;
            while (i2 < count2 - 1) {
                JMenuItem thisItem = windowMenu.getItem(i2);
                if (thisItem != null) {
                    text = thisItem.getText();
                    if (text.equals("More Windows...")) break;
                    pos = text.indexOf(32);
                    thisItem.setText((char)(48 + j2) + " " + text.substring(pos + 1));
                    thisItem.setMnemonic(48 + j2);
                    ++j2;
                }
                ++i2;
            }
            if (count2 - 6 != 0 || lastItem == item || !lastItem.getText().equals("More Windows...")) break;
            windowMenu.remove(lastItem);
            break;
        }
        windowMenu.revalidate();
    }

    void showStopLine(Dim.StackFrame frame) {
        String sourceName = frame.getUrl();
        if (sourceName == null || sourceName.equals("<stdin>")) {
            if (this.console.isVisible()) {
                this.console.show();
            }
        } else {
            this.showFileWindow(sourceName, -1);
            int lineNumber = frame.getLineNumber();
            FileWindow w = this.getFileWindow(sourceName);
            if (w != null) {
                this.setFilePosition(w, lineNumber);
            }
        }
    }

    protected void showFileWindow(String sourceUrl, int lineNumber) {
        FileWindow w = this.getFileWindow(sourceUrl);
        if (w == null) {
            Dim.SourceInfo si = this.dim.sourceInfo(sourceUrl);
            this.createFileWindow(si, -1);
            w = this.getFileWindow(sourceUrl);
        }
        if (lineNumber > -1) {
            int start2 = w.getPosition(lineNumber - 1);
            int end2 = w.getPosition(lineNumber) - 1;
            w.textArea.select(start2);
            w.textArea.setCaretPosition(start2);
            w.textArea.moveCaretPosition(end2);
        }
        try {
            if (w.isIcon()) {
                w.setIcon(false);
            }
            w.setVisible(true);
            w.moveToFront();
            w.setSelected(true);
            this.requestFocus();
            w.requestFocus();
            w.textArea.requestFocus();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void createFileWindow(Dim.SourceInfo sourceInfo, int line) {
        boolean activate = true;
        String url2 = sourceInfo.url();
        FileWindow w = new FileWindow(this, sourceInfo);
        this.fileWindows.put(url2, w);
        if (line != -1) {
            if (this.currentWindow != null) {
                this.currentWindow.setPosition(-1);
            }
            try {
                w.setPosition(w.textArea.getLineStartOffset(line - 1));
            }
            catch (BadLocationException exc) {
                try {
                    w.setPosition(w.textArea.getLineStartOffset(0));
                }
                catch (BadLocationException ee) {
                    w.setPosition(-1);
                }
            }
        }
        this.desk.add(w);
        if (line != -1) {
            this.currentWindow = w;
        }
        this.menubar.addFile(url2);
        w.setVisible(true);
        if (activate) {
            try {
                w.setMaximum(true);
                w.setSelected(true);
                w.moveToFront();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected boolean updateFileWindow(Dim.SourceInfo sourceInfo) {
        String fileName = sourceInfo.url();
        FileWindow w = this.getFileWindow(fileName);
        if (w != null) {
            w.updateText(sourceInfo);
            w.show();
            return true;
        }
        return false;
    }

    private void setFilePosition(FileWindow w, int line) {
        boolean activate = true;
        FileTextArea ta = w.textArea;
        try {
            if (line == -1) {
                w.setPosition(-1);
                if (this.currentWindow == w) {
                    this.currentWindow = null;
                }
            } else {
                int loc = ta.getLineStartOffset(line - 1);
                if (this.currentWindow != null && this.currentWindow != w) {
                    this.currentWindow.setPosition(-1);
                }
                w.setPosition(loc);
                this.currentWindow = w;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (activate) {
            if (w.isIcon()) {
                this.desk.getDesktopManager().deiconifyFrame(w);
            }
            this.desk.getDesktopManager().activateFrame(w);
            try {
                w.show();
                w.toFront();
                w.setSelected(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void enterInterruptImpl(Dim.StackFrame lastFrame, String threadTitle, String alertMessage) {
        this.statusBar.setText("Thread: " + threadTitle);
        this.showStopLine(lastFrame);
        if (alertMessage != null) {
            MessageDialogWrapper.showMessageDialog(this, alertMessage, "Exception in Script", 0);
        }
        this.updateEnabled(true);
        Dim.ContextData contextData = lastFrame.contextData();
        JComboBox ctx = this.context.context;
        List<String> toolTips = this.context.toolTips;
        this.context.disableUpdate();
        int frameCount = contextData.frameCount();
        ctx.removeAllItems();
        ctx.setSelectedItem(null);
        toolTips.clear();
        for (int i2 = 0; i2 < frameCount; ++i2) {
            Dim.StackFrame frame = contextData.getFrame(i2);
            String url2 = frame.getUrl();
            int lineNumber = frame.getLineNumber();
            String shortName = url2;
            if (url2.length() > 20) {
                shortName = "..." + url2.substring(url2.length() - 17);
            }
            String location = "\"" + shortName + "\", line " + lineNumber;
            ctx.insertItemAt(location, i2);
            location = "\"" + url2 + "\", line " + lineNumber;
            toolTips.add(location);
        }
        this.context.enableUpdate();
        ctx.setSelectedIndex(0);
        ctx.setMinimumSize(new Dimension(50, ctx.getMinimumSize().height));
    }

    private JMenu getWindowMenu() {
        return this.menubar.getMenu(3);
    }

    private String chooseFile(String title) {
        int returnVal;
        this.dlg.setDialogTitle(title);
        File CWD = null;
        String dir = SecurityUtilities.getSystemProperty("user.dir");
        if (dir != null) {
            CWD = new File(dir);
        }
        if (CWD != null) {
            this.dlg.setCurrentDirectory(CWD);
        }
        if ((returnVal = this.dlg.showOpenDialog(this)) == 0) {
            try {
                String result2 = this.dlg.getSelectedFile().getCanonicalPath();
                CWD = this.dlg.getSelectedFile().getParentFile();
                Properties props = System.getProperties();
                props.put("user.dir", CWD.getPath());
                System.setProperties(props);
                return result2;
            }
            catch (IOException iOException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    private JInternalFrame getSelectedFrame() {
        JInternalFrame[] frames = this.desk.getAllFrames();
        for (int i2 = 0; i2 < frames.length; ++i2) {
            if (!frames[i2].isShowing()) continue;
            return frames[i2];
        }
        return frames[frames.length - 1];
    }

    private void updateEnabled(boolean interrupted) {
        ((Menubar)this.getJMenuBar()).updateEnabled(interrupted);
        int cc = this.toolBar.getComponentCount();
        for (int ci = 0; ci < cc; ++ci) {
            boolean enableButton = ci == 0 ? !interrupted : interrupted;
            this.toolBar.getComponent(ci).setEnabled(enableButton);
        }
        if (interrupted) {
            this.toolBar.setEnabled(true);
            int state = this.getExtendedState();
            if (state == 1) {
                this.setExtendedState(0);
            }
            this.toFront();
            this.context.setEnabled(true);
        } else {
            if (this.currentWindow != null) {
                this.currentWindow.setPosition(-1);
            }
            this.context.setEnabled(false);
        }
    }

    static void setResizeWeight(JSplitPane pane, double weight) {
        try {
            Method m4 = JSplitPane.class.getMethod("setResizeWeight", Double.TYPE);
            m4.invoke((Object)pane, new Double(weight));
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String fileName) {
        String text;
        try {
            FileReader r = new FileReader(fileName);
            try {
                text = Kit.readReader(r);
            }
            finally {
                ((Reader)r).close();
            }
        }
        catch (IOException ex) {
            MessageDialogWrapper.showMessageDialog(this, ex.getMessage(), "Error reading " + fileName, 0);
            text = null;
        }
        return text;
    }

    @Override
    public void updateSourceText(Dim.SourceInfo sourceInfo) {
        RunProxy proxy = new RunProxy(this, 3);
        proxy.sourceInfo = sourceInfo;
        SwingUtilities.invokeLater(proxy);
    }

    @Override
    public void enterInterrupt(Dim.StackFrame lastFrame, String threadTitle, String alertMessage) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.enterInterruptImpl(lastFrame, threadTitle, alertMessage);
        } else {
            RunProxy proxy = new RunProxy(this, 4);
            proxy.lastFrame = lastFrame;
            proxy.threadTitle = threadTitle;
            proxy.alertMessage = alertMessage;
            SwingUtilities.invokeLater(proxy);
        }
    }

    @Override
    public boolean isGuiEventThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    @Override
    public void dispatchNextGuiEvent() throws InterruptedException {
        AWTEvent event;
        EventQueue queue = this.awtEventQueue;
        if (queue == null) {
            this.awtEventQueue = queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        }
        if ((event = queue.getNextEvent()) instanceof ActiveEvent) {
            ((ActiveEvent)((Object)event)).dispatch();
        } else {
            Object source2 = event.getSource();
            if (source2 instanceof Component) {
                Component comp = (Component)source2;
                comp.dispatchEvent(event);
            } else if (source2 instanceof MenuComponent) {
                ((MenuComponent)source2).dispatchEvent(event);
            }
        }
    }

    public void actionPerformed(ActionEvent e2) {
        String cmd = e2.getActionCommand();
        int returnValue2 = -1;
        if (cmd.equals("Cut") || cmd.equals("Copy") || cmd.equals("Paste")) {
            JInternalFrame f2 = this.getSelectedFrame();
            if (f2 != null && f2 instanceof ActionListener) {
                ((ActionListener)((Object)f2)).actionPerformed(e2);
            }
        } else if (cmd.equals("Step Over")) {
            returnValue2 = 0;
        } else if (cmd.equals("Step Into")) {
            returnValue2 = 1;
        } else if (cmd.equals("Step Out")) {
            returnValue2 = 2;
        } else if (cmd.equals("Go")) {
            returnValue2 = 3;
        } else if (cmd.equals("Break")) {
            this.dim.setBreak();
        } else if (cmd.equals("Exit")) {
            this.exit();
        } else if (cmd.equals("Open")) {
            String text;
            String fileName = this.chooseFile("Select a file to compile");
            if (fileName != null && (text = this.readFile(fileName)) != null) {
                RunProxy proxy = new RunProxy(this, 1);
                proxy.fileName = fileName;
                proxy.text = text;
                new Thread(proxy).start();
            }
        } else if (cmd.equals("Load")) {
            String text;
            String fileName = this.chooseFile("Select a file to execute");
            if (fileName != null && (text = this.readFile(fileName)) != null) {
                RunProxy proxy = new RunProxy(this, 2);
                proxy.fileName = fileName;
                proxy.text = text;
                new Thread(proxy).start();
            }
        } else if (cmd.equals("More Windows...")) {
            MoreWindows dlg = new MoreWindows(this, this.fileWindows, "Window", "Files");
            dlg.showDialog(this);
        } else if (cmd.equals("Console")) {
            if (this.console.isIcon()) {
                this.desk.getDesktopManager().deiconifyFrame(this.console);
            }
            this.console.show();
            this.desk.getDesktopManager().activateFrame(this.console);
            this.console.consoleTextArea.requestFocus();
        } else if (!(cmd.equals("Cut") || cmd.equals("Copy") || cmd.equals("Paste"))) {
            if (cmd.equals("Go to function...")) {
                FindFunction dlg = new FindFunction(this, "Go to function", "Function");
                dlg.showDialog(this);
            } else if (cmd.equals("Tile")) {
                JInternalFrame[] frames = this.desk.getAllFrames();
                int count2 = frames.length;
                int cols = (int)Math.sqrt(count2);
                int rows2 = cols;
                if (rows2 * cols < count2 && rows2 * ++cols < count2) {
                    ++rows2;
                }
                Dimension size2 = this.desk.getSize();
                int w = size2.width / cols;
                int h2 = size2.height / rows2;
                int x = 0;
                int y = 0;
                for (int i2 = 0; i2 < rows2; ++i2) {
                    int index;
                    for (int j2 = 0; j2 < cols && (index = i2 * cols + j2) < frames.length; ++j2) {
                        JInternalFrame f3 = frames[index];
                        try {
                            f3.setIcon(false);
                            f3.setMaximum(false);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.desk.getDesktopManager().setBoundsForFrame(f3, x, y, w, h2);
                        x += w;
                    }
                    y += h2;
                    x = 0;
                }
            } else if (cmd.equals("Cascade")) {
                JInternalFrame[] frames = this.desk.getAllFrames();
                int count3 = frames.length;
                int y = 0;
                int x = 0;
                int h3 = this.desk.getHeight();
                int d2 = h3 / count3;
                if (d2 > 30) {
                    d2 = 30;
                }
                int i3 = count3 - 1;
                while (i3 >= 0) {
                    JInternalFrame f4 = frames[i3];
                    try {
                        f4.setIcon(false);
                        f4.setMaximum(false);
                    }
                    catch (Exception i2) {
                        // empty catch block
                    }
                    Dimension dimen = f4.getPreferredSize();
                    int w = dimen.width;
                    h3 = dimen.height;
                    this.desk.getDesktopManager().setBoundsForFrame(f4, x, y, w, h3);
                    --i3;
                    x += d2;
                    y += d2;
                }
            } else {
                FileWindow obj = this.getFileWindow(cmd);
                if (obj != null) {
                    FileWindow w = obj;
                    try {
                        if (w.isIcon()) {
                            w.setIcon(false);
                        }
                        w.setVisible(true);
                        w.moveToFront();
                        w.setSelected(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (returnValue2 != -1) {
            this.updateEnabled(false);
            this.dim.setReturnValue(returnValue2);
        }
    }
}

