/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.idswitch;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class FileBody {
    private char[] buffer = new char[16384];
    private int bufferEnd;
    private int lineBegin;
    private int lineEnd;
    private int nextLineStart;
    private int lineNumber;
    ReplaceItem firstReplace;
    ReplaceItem lastReplace;

    public char[] getBuffer() {
        return this.buffer;
    }

    public void readData(Reader r) throws IOException {
        int n_read;
        int capacity = this.buffer.length;
        int offset = 0;
        while ((n_read = r.read(this.buffer, offset, capacity - offset)) >= 0) {
            if (capacity != (offset += n_read)) continue;
            char[] tmp = new char[capacity *= 2];
            System.arraycopy(this.buffer, 0, tmp, 0, offset);
            this.buffer = tmp;
        }
        this.bufferEnd = offset;
    }

    public void writeInitialData(Writer w) throws IOException {
        w.write(this.buffer, 0, this.bufferEnd);
    }

    public void writeData(Writer w) throws IOException {
        int offset = 0;
        ReplaceItem x = this.firstReplace;
        while (x != null) {
            int before_replace = x.begin - offset;
            if (before_replace > 0) {
                w.write(this.buffer, offset, before_replace);
            }
            w.write(x.replacement);
            offset = x.end;
            x = x.next;
        }
        int tail = this.bufferEnd - offset;
        if (tail != 0) {
            w.write(this.buffer, offset, tail);
        }
    }

    public boolean wasModified() {
        return this.firstReplace != null;
    }

    public boolean setReplacement(int begin, int end2, String text) {
        if (FileBody.equals(text, this.buffer, begin, end2)) {
            return false;
        }
        ReplaceItem item = new ReplaceItem(begin, end2, text);
        if (this.firstReplace == null) {
            this.firstReplace = this.lastReplace = item;
        } else if (begin < this.firstReplace.begin) {
            item.next = this.firstReplace;
            this.firstReplace = item;
        } else {
            ReplaceItem cursor = this.firstReplace;
            ReplaceItem next2 = cursor.next;
            while (next2 != null) {
                if (begin < next2.begin) {
                    item.next = next2;
                    cursor.next = item;
                    break;
                }
                cursor = next2;
                next2 = next2.next;
            }
            if (next2 == null) {
                this.lastReplace.next = item;
            }
        }
        return true;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getLineBegin() {
        return this.lineBegin;
    }

    public int getLineEnd() {
        return this.lineEnd;
    }

    public void startLineLoop() {
        this.lineNumber = 0;
        this.nextLineStart = 0;
        this.lineEnd = 0;
        this.lineBegin = 0;
    }

    public boolean nextLine() {
        int i2;
        if (this.nextLineStart == this.bufferEnd) {
            this.lineNumber = 0;
            return false;
        }
        char c2 = '\u0000';
        for (i2 = this.nextLineStart; i2 != this.bufferEnd && (c2 = this.buffer[i2]) != '\n' && c2 != '\r'; ++i2) {
        }
        this.lineBegin = this.nextLineStart;
        this.lineEnd = i2;
        this.nextLineStart = i2 == this.bufferEnd ? i2 : (c2 == '\r' && i2 + 1 != this.bufferEnd && this.buffer[i2 + 1] == '\n' ? i2 + 2 : i2 + 1);
        ++this.lineNumber;
        return true;
    }

    private static boolean equals(String str, char[] array, int begin, int end2) {
        if (str.length() == end2 - begin) {
            int i2 = begin;
            int j2 = 0;
            while (i2 != end2) {
                if (array[i2] != str.charAt(j2)) {
                    return false;
                }
                ++i2;
                ++j2;
            }
            return true;
        }
        return false;
    }

    private static class ReplaceItem {
        ReplaceItem next;
        int begin;
        int end;
        String replacement;

        ReplaceItem(int begin, int end2, String text) {
            this.begin = begin;
            this.end = end2;
            this.replacement = text;
        }
    }
}

