/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.idswitch;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.idswitch.CodePrinter;
import org.mozilla.javascript.tools.idswitch.FileBody;
import org.mozilla.javascript.tools.idswitch.IdValuePair;
import org.mozilla.javascript.tools.idswitch.SwitchGenerator;

public class Main {
    private static final String SWITCH_TAG_STR = "string_id_map";
    private static final String GENERATED_TAG_STR = "generated";
    private static final String STRING_TAG_STR = "string";
    private static final int NORMAL_LINE = 0;
    private static final int SWITCH_TAG = 1;
    private static final int GENERATED_TAG = 2;
    private static final int STRING_TAG = 3;
    private final List<IdValuePair> all_pairs = new ArrayList<IdValuePair>();
    private ToolErrorReporter R;
    private CodePrinter P;
    private FileBody body;
    private String source_file;
    private int tag_definition_end;
    private int tag_value_start;
    private int tag_value_end;

    private static boolean is_value_type(int id) {
        return id == 3;
    }

    private static String tag_name(int id) {
        switch (id) {
            case 1: {
                return SWITCH_TAG_STR;
            }
            case -1: {
                return "/string_id_map";
            }
            case 2: {
                return GENERATED_TAG_STR;
            }
            case -2: {
                return "/generated";
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void process_file(String file_path) throws IOException {
        this.source_file = file_path;
        this.body = new FileBody();
        InputStream is = file_path.equals("-") ? System.in : new FileInputStream(file_path);
        try {
            InputStreamReader r = new InputStreamReader(is, "ASCII");
            this.body.readData(r);
        }
        finally {
            is.close();
        }
        this.process_file();
        if (this.body.wasModified()) {
            OutputStream os = file_path.equals("-") ? System.out : new FileOutputStream(file_path);
            try {
                OutputStreamWriter w = new OutputStreamWriter(os);
                this.body.writeData(w);
                ((Writer)w).flush();
            }
            finally {
                os.close();
            }
        }
    }

    private void process_file() {
        int cur_state = 0;
        char[] buffer = this.body.getBuffer();
        int generated_begin = -1;
        int generated_end = -1;
        int time_stamp_begin = -1;
        int time_stamp_end = -1;
        this.body.startLineLoop();
        while (this.body.nextLine()) {
            int begin = this.body.getLineBegin();
            int end2 = this.body.getLineEnd();
            int tag_id = this.extract_line_tag_id(buffer, begin, end2);
            boolean bad_tag = false;
            switch (cur_state) {
                case 0: {
                    if (tag_id == 1) {
                        cur_state = 1;
                        this.all_pairs.clear();
                        generated_begin = -1;
                        break;
                    }
                    if (tag_id != -1) break;
                    bad_tag = true;
                    break;
                }
                case 1: {
                    if (tag_id == 0) {
                        this.look_for_id_definitions(buffer, begin, end2, false);
                        break;
                    }
                    if (tag_id == 3) {
                        this.look_for_id_definitions(buffer, begin, end2, true);
                        break;
                    }
                    if (tag_id == 2) {
                        if (generated_begin >= 0) {
                            bad_tag = true;
                            break;
                        }
                        cur_state = 2;
                        time_stamp_begin = this.tag_definition_end;
                        time_stamp_end = end2;
                        break;
                    }
                    if (tag_id == -1) {
                        cur_state = 0;
                        if (generated_begin < 0 || this.all_pairs.isEmpty()) break;
                        this.generate_java_code();
                        String code = this.P.toString();
                        boolean different = this.body.setReplacement(generated_begin, generated_end, code);
                        if (!different) break;
                        String stamp = this.get_time_stamp();
                        this.body.setReplacement(time_stamp_begin, time_stamp_end, stamp);
                        break;
                    }
                    bad_tag = true;
                    break;
                }
                case 2: {
                    if (tag_id == 0) {
                        if (generated_begin >= 0) break;
                        generated_begin = begin;
                        break;
                    }
                    if (tag_id == -2) {
                        if (generated_begin < 0) {
                            generated_begin = begin;
                        }
                        cur_state = 1;
                        generated_end = begin;
                        break;
                    }
                    bad_tag = true;
                }
            }
            if (!bad_tag) continue;
            String text = ToolErrorReporter.getMessage("msg.idswitch.bad_tag_order", Main.tag_name(tag_id));
            throw this.R.runtimeError(text, this.source_file, this.body.getLineNumber(), null, 0);
        }
        if (cur_state != 0) {
            String text = ToolErrorReporter.getMessage("msg.idswitch.file_end_in_switch", Main.tag_name(cur_state));
            throw this.R.runtimeError(text, this.source_file, this.body.getLineNumber(), null, 0);
        }
    }

    private String get_time_stamp() {
        SimpleDateFormat f2 = new SimpleDateFormat(" 'Last update:' yyyy-MM-dd HH:mm:ss z");
        return f2.format(new Date());
    }

    private void generate_java_code() {
        this.P.clear();
        IdValuePair[] pairs2 = new IdValuePair[this.all_pairs.size()];
        this.all_pairs.toArray(pairs2);
        SwitchGenerator g2 = new SwitchGenerator();
        g2.char_tail_test_threshold = 2;
        g2.setReporter(this.R);
        g2.setCodePrinter(this.P);
        g2.generateSwitch(pairs2, "0");
    }

    private int extract_line_tag_id(char[] array, int cursor, int end2) {
        int id = 0;
        int after_leading_white_space = cursor = Main.skip_white_space(array, cursor, end2);
        if ((cursor = this.look_for_slash_slash(array, cursor, end2)) != end2) {
            boolean at_line_start = after_leading_white_space + 2 == cursor;
            if ((cursor = Main.skip_white_space(array, cursor, end2)) != end2 && array[cursor] == '#') {
                char c2;
                boolean end_tag = false;
                if (++cursor != end2 && array[cursor] == '/') {
                    ++cursor;
                    end_tag = true;
                }
                int tag_start = cursor;
                while (cursor != end2 && (c2 = array[cursor]) != '#' && c2 != '=' && !Main.is_white_space(c2)) {
                    ++cursor;
                }
                if (cursor != end2) {
                    char c3;
                    int tag_end = cursor;
                    if ((cursor = Main.skip_white_space(array, cursor, end2)) != end2 && ((c3 = array[cursor]) == '=' || c3 == '#') && (id = this.get_tag_id(array, tag_start, tag_end, at_line_start)) != 0) {
                        String bad = null;
                        if (c3 == '#') {
                            if (end_tag && Main.is_value_type(id = -id)) {
                                bad = "msg.idswitch.no_end_usage";
                            }
                            this.tag_definition_end = cursor + 1;
                        } else {
                            if (end_tag) {
                                bad = "msg.idswitch.no_end_with_value";
                            } else if (!Main.is_value_type(id)) {
                                bad = "msg.idswitch.no_value_allowed";
                            }
                            id = this.extract_tag_value(array, cursor + 1, end2, id);
                        }
                        if (bad != null) {
                            String s2 = ToolErrorReporter.getMessage(bad, Main.tag_name(id));
                            throw this.R.runtimeError(s2, this.source_file, this.body.getLineNumber(), null, 0);
                        }
                    }
                }
            }
        }
        return id;
    }

    private int look_for_slash_slash(char[] array, int cursor, int end2) {
        while (cursor + 2 <= end2) {
            char c2;
            if ((c2 = array[cursor++]) != '/' || (c2 = array[cursor++]) != '/') continue;
            return cursor;
        }
        return end2;
    }

    private int extract_tag_value(char[] array, int cursor, int end2, int id) {
        boolean found = false;
        if ((cursor = Main.skip_white_space(array, cursor, end2)) != end2) {
            int value_start = cursor;
            int value_end = cursor;
            while (cursor != end2) {
                char c2 = array[cursor];
                if (Main.is_white_space(c2)) {
                    int after_space = Main.skip_white_space(array, cursor + 1, end2);
                    if (after_space != end2 && array[after_space] == '#') {
                        value_end = cursor;
                        cursor = after_space;
                        break;
                    }
                    cursor = after_space + 1;
                    continue;
                }
                if (c2 == '#') {
                    value_end = cursor;
                    break;
                }
                ++cursor;
            }
            if (cursor != end2) {
                found = true;
                this.tag_value_start = value_start;
                this.tag_value_end = value_end;
                this.tag_definition_end = cursor + 1;
            }
        }
        return found ? id : 0;
    }

    private int get_tag_id(char[] array, int begin, int end2, boolean at_line_start) {
        if (at_line_start) {
            if (Main.equals(SWITCH_TAG_STR, array, begin, end2)) {
                return 1;
            }
            if (Main.equals(GENERATED_TAG_STR, array, begin, end2)) {
                return 2;
            }
        }
        if (Main.equals(STRING_TAG_STR, array, begin, end2)) {
            return 3;
        }
        return 0;
    }

    private void look_for_id_definitions(char[] array, int begin, int end2, boolean use_tag_value_as_string) {
        int cursor = begin;
        int id_start = cursor = Main.skip_white_space(array, cursor, end2);
        int name_start = Main.skip_matched_prefix("Id_", array, cursor, end2);
        if (name_start >= 0) {
            cursor = name_start;
            int name_end = cursor = Main.skip_name_char(array, cursor, end2);
            if (name_start != name_end && (cursor = Main.skip_white_space(array, cursor, end2)) != end2 && array[cursor] == '=') {
                int id_end = name_end;
                if (use_tag_value_as_string) {
                    name_start = this.tag_value_start;
                    name_end = this.tag_value_end;
                }
                this.add_id(array, id_start, id_end, name_start, name_end);
            }
        }
    }

    private void add_id(char[] array, int id_start, int id_end, int name_start, int name_end) {
        String name = new String(array, name_start, name_end - name_start);
        String value2 = new String(array, id_start, id_end - id_start);
        IdValuePair pair = new IdValuePair(name, value2);
        pair.setLineNumber(this.body.getLineNumber());
        this.all_pairs.add(pair);
    }

    private static boolean is_white_space(int c2) {
        return c2 == 32 || c2 == 9;
    }

    private static int skip_white_space(char[] array, int begin, int end2) {
        char c2;
        int cursor;
        for (cursor = begin; cursor != end2 && Main.is_white_space(c2 = array[cursor]); ++cursor) {
        }
        return cursor;
    }

    private static int skip_matched_prefix(String prefix2, char[] array, int begin, int end2) {
        int cursor = -1;
        int prefix_length = prefix2.length();
        if (prefix_length <= end2 - begin) {
            cursor = begin;
            int i2 = 0;
            while (i2 != prefix_length) {
                if (prefix2.charAt(i2) != array[cursor]) {
                    cursor = -1;
                    break;
                }
                ++i2;
                ++cursor;
            }
        }
        return cursor;
    }

    private static boolean equals(String str, char[] array, int begin, int end2) {
        if (str.length() == end2 - begin) {
            int i2 = begin;
            int j2 = 0;
            while (i2 != end2) {
                if (array[i2] != str.charAt(j2)) {
                    return false;
                }
                ++i2;
                ++j2;
            }
            return true;
        }
        return false;
    }

    private static int skip_name_char(char[] array, int begin, int end2) {
        char c2;
        int cursor;
        for (cursor = begin; cursor != end2 && ('a' <= (c2 = array[cursor]) && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z' || '0' <= c2 && c2 <= '9' || c2 == '_'); ++cursor) {
        }
        return cursor;
    }

    public static void main(String[] args2) {
        Main self = new Main();
        int status2 = self.exec(args2);
        System.exit(status2);
    }

    private int exec(String[] args2) {
        this.R = new ToolErrorReporter(true, System.err);
        int arg_count = this.process_options(args2);
        if (arg_count == 0) {
            this.option_error(ToolErrorReporter.getMessage("msg.idswitch.no_file_argument"));
            return -1;
        }
        if (arg_count > 1) {
            this.option_error(ToolErrorReporter.getMessage("msg.idswitch.too_many_arguments"));
            return -1;
        }
        this.P = new CodePrinter();
        this.P.setIndentStep(4);
        this.P.setIndentTabSize(0);
        try {
            this.process_file(args2[0]);
        }
        catch (IOException ex) {
            this.print_error(ToolErrorReporter.getMessage("msg.idswitch.io_error", ex.toString()));
            return -1;
        }
        catch (EvaluatorException ex) {
            return -1;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int process_options(String[] args2) {
        int status2 = 1;
        boolean show_usage = false;
        boolean show_version = false;
        int N2 = args2.length;
        block3: for (int i2 = 0; i2 != N2; ++i2) {
            block14: {
                int arg_length;
                String arg;
                block15: {
                    arg = args2[i2];
                    arg_length = arg.length();
                    if (arg_length < 2 || arg.charAt(0) != '-') continue;
                    if (arg.charAt(1) != '-') break block15;
                    if (arg_length == 2) {
                        args2[i2] = null;
                        break;
                    }
                    if (arg.equals("--help")) {
                        show_usage = true;
                        break block14;
                    } else if (arg.equals("--version")) {
                        show_version = true;
                        break block14;
                    } else {
                        this.option_error(ToolErrorReporter.getMessage("msg.idswitch.bad_option", arg));
                        status2 = -1;
                        break;
                    }
                }
                block4: for (int j2 = 1; j2 != arg_length; ++j2) {
                    char c2 = arg.charAt(j2);
                    switch (c2) {
                        case 'h': {
                            show_usage = true;
                            continue block4;
                        }
                        default: {
                            this.option_error(ToolErrorReporter.getMessage("msg.idswitch.bad_option_char", String.valueOf(c2)));
                            status2 = -1;
                            break block3;
                        }
                    }
                }
            }
            args2[i2] = null;
        }
        if (status2 == 1) {
            if (show_usage) {
                this.show_usage();
                status2 = 0;
            }
            if (show_version) {
                this.show_version();
                status2 = 0;
            }
        }
        if (status2 != 1) {
            System.exit(status2);
        }
        return this.remove_nulls(args2);
    }

    private void show_usage() {
        System.out.println(ToolErrorReporter.getMessage("msg.idswitch.usage"));
        System.out.println();
    }

    private void show_version() {
        System.out.println(ToolErrorReporter.getMessage("msg.idswitch.version"));
    }

    private void option_error(String str) {
        this.print_error(ToolErrorReporter.getMessage("msg.idswitch.bad_invocation", str));
    }

    private void print_error(String text) {
        System.err.println(text);
    }

    private int remove_nulls(String[] array) {
        int cursor;
        int N2 = array.length;
        for (cursor = 0; cursor != N2 && array[cursor] != null; ++cursor) {
        }
        int destination = cursor;
        if (cursor != N2) {
            ++cursor;
            while (cursor != N2) {
                String elem = array[cursor];
                if (elem != null) {
                    array[destination] = elem;
                    ++destination;
                }
                ++cursor;
            }
        }
        return destination;
    }
}

