/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.jsc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.optimizer.ClassCompiler;
import org.mozilla.javascript.tools.SourceReader;
import org.mozilla.javascript.tools.ToolErrorReporter;

public class Main {
    private boolean printHelp;
    private ToolErrorReporter reporter = new ToolErrorReporter(true);
    private CompilerEnvirons compilerEnv = new CompilerEnvirons();
    private ClassCompiler compiler;
    private String targetName;
    private String targetPackage;
    private String destinationDir;
    private String characterEncoding;

    public static void main(String[] args2) {
        Main main2 = new Main();
        if ((args2 = main2.processOptions(args2)) == null) {
            if (main2.printHelp) {
                System.out.println(ToolErrorReporter.getMessage("msg.jsc.usage", Main.class.getName()));
                System.exit(0);
            }
            System.exit(1);
        }
        if (!main2.reporter.hasReportedError()) {
            main2.processSource(args2);
        }
    }

    public Main() {
        this.compilerEnv.setErrorReporter(this.reporter);
        this.compiler = new ClassCompiler(this.compilerEnv);
    }

    public String[] processOptions(String[] args2) {
        this.targetPackage = "";
        this.compilerEnv.setGenerateDebugInfo(false);
        for (int i2 = 0; i2 < args2.length; ++i2) {
            String arg = args2[i2];
            if (!arg.startsWith("-")) {
                int tail = args2.length - i2;
                if (this.targetName != null && tail > 1) {
                    this.addError("msg.multiple.js.to.file", this.targetName);
                    return null;
                }
                String[] result2 = new String[tail];
                for (int j2 = 0; j2 != tail; ++j2) {
                    result2[j2] = args2[i2 + j2];
                }
                return result2;
            }
            if (arg.equals("-help") || arg.equals("-h") || arg.equals("--help")) {
                this.printHelp = true;
                return null;
            }
            try {
                if (arg.equals("-version") && ++i2 < args2.length) {
                    int version2 = Integer.parseInt(args2[i2]);
                    this.compilerEnv.setLanguageVersion(version2);
                    continue;
                }
                if ((arg.equals("-opt") || arg.equals("-O")) && ++i2 < args2.length) {
                    int optLevel = Integer.parseInt(args2[i2]);
                    this.compilerEnv.setOptimizationLevel(optLevel);
                    continue;
                }
            }
            catch (NumberFormatException e2) {
                Main.badUsage(args2[i2]);
                return null;
            }
            if (arg.equals("-nosource")) {
                this.compilerEnv.setGeneratingSource(false);
                continue;
            }
            if (arg.equals("-debug") || arg.equals("-g")) {
                this.compilerEnv.setGenerateDebugInfo(true);
                continue;
            }
            if (arg.equals("-main-method-class") && ++i2 < args2.length) {
                this.compiler.setMainMethodClass(args2[i2]);
                continue;
            }
            if (arg.equals("-encoding") && ++i2 < args2.length) {
                this.characterEncoding = args2[i2];
                continue;
            }
            if (arg.equals("-o") && ++i2 < args2.length) {
                String name = args2[i2];
                int end2 = name.length();
                if (end2 == 0 || !Character.isJavaIdentifierStart(name.charAt(0))) {
                    this.addError("msg.invalid.classfile.name", name);
                    continue;
                }
                for (int j3 = 1; j3 < end2; ++j3) {
                    char c2 = name.charAt(j3);
                    if (Character.isJavaIdentifierPart(c2)) continue;
                    if (c2 == '.' && j3 == end2 - 6 && name.endsWith(".class")) {
                        name = name.substring(0, j3);
                        break;
                    }
                    this.addError("msg.invalid.classfile.name", name);
                    break;
                }
                this.targetName = name;
                continue;
            }
            if (arg.equals("-observe-instruction-count")) {
                this.compilerEnv.setGenerateObserverCount(true);
            }
            if (arg.equals("-package") && ++i2 < args2.length) {
                String pkg = args2[i2];
                int end3 = pkg.length();
                for (int j4 = 0; j4 != end3; ++j4) {
                    char c3 = pkg.charAt(j4);
                    if (Character.isJavaIdentifierStart(c3)) {
                        ++j4;
                        while (j4 != end3 && Character.isJavaIdentifierPart(c3 = pkg.charAt(j4))) {
                            ++j4;
                        }
                        if (j4 == end3) break;
                        if (c3 == '.' && j4 != end3 - 1) continue;
                    }
                    this.addError("msg.package.name", this.targetPackage);
                    return null;
                }
                this.targetPackage = pkg;
                continue;
            }
            if (arg.equals("-extends") && ++i2 < args2.length) {
                Class<?> superClass;
                String targetExtends = args2[i2];
                try {
                    superClass = Class.forName(targetExtends);
                }
                catch (ClassNotFoundException e3) {
                    throw new Error(e3.toString());
                }
                this.compiler.setTargetExtends(superClass);
                continue;
            }
            if (arg.equals("-implements") && ++i2 < args2.length) {
                String targetImplements = args2[i2];
                StringTokenizer st = new StringTokenizer(targetImplements, ",");
                ArrayList list = new ArrayList();
                while (st.hasMoreTokens()) {
                    String className = st.nextToken();
                    try {
                        list.add(Class.forName(className));
                    }
                    catch (ClassNotFoundException e4) {
                        throw new Error(e4.toString());
                    }
                }
                Class[] implementsClasses = list.toArray(new Class[list.size()]);
                this.compiler.setTargetImplements(implementsClasses);
                continue;
            }
            if (arg.equals("-d") && ++i2 < args2.length) {
                this.destinationDir = args2[i2];
                continue;
            }
            Main.badUsage(arg);
            return null;
        }
        Main.p(ToolErrorReporter.getMessage("msg.no.file"));
        return null;
    }

    private static void badUsage(String s2) {
        System.err.println(ToolErrorReporter.getMessage("msg.jsc.bad.usage", Main.class.getName(), s2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSource(String[] filenames) {
        for (int i2 = 0; i2 != filenames.length; ++i2) {
            Object[] compiled;
            String filename = filenames[i2];
            if (!filename.endsWith(".js")) {
                this.addError("msg.extension.not.js", filename);
                return;
            }
            File f2 = new File(filename);
            String source2 = this.readSource(f2);
            if (source2 == null) {
                return;
            }
            String mainClassName = this.targetName;
            if (mainClassName == null) {
                String name = f2.getName();
                String nojs = name.substring(0, name.length() - 3);
                mainClassName = this.getClassName(nojs);
            }
            if (this.targetPackage.length() != 0) {
                mainClassName = this.targetPackage + "." + mainClassName;
            }
            if ((compiled = this.compiler.compileToClassFiles(source2, filename, 1, mainClassName)) == null || compiled.length == 0) {
                return;
            }
            File targetTopDir = null;
            if (this.destinationDir != null) {
                targetTopDir = new File(this.destinationDir);
            } else {
                String parent = f2.getParent();
                if (parent != null) {
                    targetTopDir = new File(parent);
                }
            }
            for (int j2 = 0; j2 != compiled.length; j2 += 2) {
                String className = (String)compiled[j2];
                byte[] bytes = (byte[])compiled[j2 + 1];
                File outfile = this.getOutputFile(targetTopDir, className);
                try {
                    FileOutputStream os = new FileOutputStream(outfile);
                    try {
                        os.write(bytes);
                        continue;
                    }
                    finally {
                        os.close();
                    }
                }
                catch (IOException ioe) {
                    this.addFormatedError(ioe.toString());
                }
            }
        }
    }

    private String readSource(File f2) {
        String absPath = f2.getAbsolutePath();
        if (!f2.isFile()) {
            this.addError("msg.jsfile.not.found", absPath);
            return null;
        }
        try {
            return (String)SourceReader.readFileOrUrl(absPath, true, this.characterEncoding);
        }
        catch (FileNotFoundException ex) {
            this.addError("msg.couldnt.open", absPath);
        }
        catch (IOException ioe) {
            this.addFormatedError(ioe.toString());
        }
        return null;
    }

    private File getOutputFile(File parentDir, String className) {
        File dir;
        String path2 = className.replace('.', File.separatorChar);
        File f2 = new File(parentDir, path2 = path2.concat(".class"));
        String dirPath = f2.getParent();
        if (dirPath != null && !(dir = new File(dirPath)).exists()) {
            dir.mkdirs();
        }
        return f2;
    }

    String getClassName(String name) {
        char[] s2 = new char[name.length() + 1];
        int j2 = 0;
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            s2[j2++] = 95;
        }
        int i2 = 0;
        while (i2 < name.length()) {
            int c2 = name.charAt(i2);
            s2[j2] = Character.isJavaIdentifierPart((char)c2) ? c2 : 95;
            ++i2;
            ++j2;
        }
        return new String(s2).trim();
    }

    private static void p(String s2) {
        System.out.println(s2);
    }

    private void addError(String messageId, String arg) {
        String msg = arg == null ? ToolErrorReporter.getMessage(messageId) : ToolErrorReporter.getMessage(messageId, arg);
        this.addFormatedError(msg);
    }

    private void addFormatedError(String message) {
        this.reporter.error(message, null, -1, null, -1);
    }
}

