/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.util.Properties;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Environment
extends ScriptableObject {
    static final long serialVersionUID = -430727378460177065L;
    private Environment thePrototypeInstance = null;

    public static void defineClass(ScriptableObject scope) {
        try {
            ScriptableObject.defineClass(scope, Environment.class);
        }
        catch (Exception e2) {
            throw new Error(e2.getMessage());
        }
    }

    @Override
    public String getClassName() {
        return "Environment";
    }

    public Environment() {
        if (this.thePrototypeInstance == null) {
            this.thePrototypeInstance = this;
        }
    }

    public Environment(ScriptableObject scope) {
        this.setParentScope(scope);
        Object ctor = ScriptRuntime.getTopLevelProp(scope, "Environment");
        if (ctor != null && ctor instanceof Scriptable) {
            Scriptable s2 = (Scriptable)ctor;
            this.setPrototype((Scriptable)s2.get("prototype", s2));
        }
    }

    @Override
    public boolean has(String name, Scriptable start2) {
        if (this == this.thePrototypeInstance) {
            return super.has(name, start2);
        }
        return System.getProperty(name) != null;
    }

    @Override
    public Object get(String name, Scriptable start2) {
        if (this == this.thePrototypeInstance) {
            return super.get(name, start2);
        }
        String result2 = System.getProperty(name);
        if (result2 != null) {
            return ScriptRuntime.toObject(this.getParentScope(), result2);
        }
        return Scriptable.NOT_FOUND;
    }

    @Override
    public void put(String name, Scriptable start2, Object value2) {
        if (this == this.thePrototypeInstance) {
            super.put(name, start2, value2);
        } else {
            System.getProperties().put(name, ScriptRuntime.toString(value2));
        }
    }

    private Object[] collectIds() {
        Properties props = System.getProperties();
        return props.keySet().toArray();
    }

    @Override
    public Object[] getIds() {
        if (this == this.thePrototypeInstance) {
            return super.getIds();
        }
        return this.collectIds();
    }

    @Override
    public Object[] getAllIds() {
        if (this == this.thePrototypeInstance) {
            return super.getAllIds();
        }
        return this.collectIds();
    }
}

