/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

class FlexibleCompletor
implements InvocationHandler {
    private Method completeMethod;
    private Scriptable global;

    FlexibleCompletor(Class<?> completorClass, Scriptable global) throws NoSuchMethodException {
        this.global = global;
        this.completeMethod = completorClass.getMethod("complete", String.class, Integer.TYPE, List.class);
    }

    @Override
    public Object invoke(Object proxy, Method method2, Object[] args2) {
        if (method2.equals(this.completeMethod)) {
            int result2 = this.complete((String)args2[0], (Integer)args2[1], (List)args2[2]);
            return result2;
        }
        throw new NoSuchMethodError(method2.toString());
    }

    public int complete(String buffer, int cursor, List<String> candidates) {
        char c2;
        int m4;
        for (m4 = cursor - 1; m4 >= 0 && (Character.isJavaIdentifierPart(c2 = buffer.charAt(m4)) || c2 == '.'); --m4) {
        }
        String namesAndDots = buffer.substring(m4 + 1, cursor);
        String[] names2 = namesAndDots.split("\\.", -1);
        Scriptable obj = this.global;
        for (int i2 = 0; i2 < names2.length - 1; ++i2) {
            Object val = obj.get(names2[i2], this.global);
            if (!(val instanceof Scriptable)) {
                return buffer.length();
            }
            obj = (Scriptable)val;
        }
        Object[] ids = obj instanceof ScriptableObject ? ((ScriptableObject)obj).getAllIds() : obj.getIds();
        String lastPart = names2[names2.length - 1];
        for (int i3 = 0; i3 < ids.length; ++i3) {
            String id;
            if (!(ids[i3] instanceof String) || !(id = (String)ids[i3]).startsWith(lastPart)) continue;
            if (obj.get(id, obj) instanceof Function) {
                id = id + "(";
            }
            candidates.add(id);
        }
        return buffer.length() - lastPart.length();
    }
}

