/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.NativeArrayBufferView;

public class NativeArrayBuffer
extends IdScriptableObject {
    private static final long serialVersionUID = 3110411773054879549L;
    public static final String CLASS_NAME = "ArrayBuffer";
    private static final byte[] EMPTY_BUF = new byte[0];
    public static final NativeArrayBuffer EMPTY_BUFFER = new NativeArrayBuffer();
    final byte[] buffer;
    private static final int Id_constructor = 1;
    private static final int Id_slice = 2;
    private static final int Id_isView = 3;
    private static final int MAX_PROTOTYPE_ID = 3;
    private static final int ConstructorId_isView = -3;
    private static final int Id_byteLength = 1;
    private static final int MAX_INSTANCE_ID = 1;

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeArrayBuffer na = new NativeArrayBuffer();
        na.exportAsJSClass(3, scope, sealed);
    }

    public NativeArrayBuffer() {
        this.buffer = EMPTY_BUF;
    }

    public NativeArrayBuffer(int len2) {
        if (len2 < 0) {
            throw ScriptRuntime.constructError("RangeError", "Negative array length " + len2);
        }
        this.buffer = len2 == 0 ? EMPTY_BUF : new byte[len2];
    }

    public int getLength() {
        return this.buffer.length;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public NativeArrayBuffer slice(int s2, int e2) {
        int end2 = Math.max(0, Math.min(this.buffer.length, e2 < 0 ? this.buffer.length + e2 : e2));
        int start2 = Math.min(end2, Math.max(0, s2 < 0 ? this.buffer.length + s2 : s2));
        int len2 = end2 - start2;
        NativeArrayBuffer newBuf = new NativeArrayBuffer(len2);
        System.arraycopy(this.buffer, start2, newBuf.buffer, 0, len2);
        return newBuf;
    }

    @Override
    public Object execIdCall(IdFunctionObject f2, Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        if (!f2.hasTag(CLASS_NAME)) {
            return super.execIdCall(f2, cx, scope, thisObj, args2);
        }
        int id = f2.methodId();
        switch (id) {
            case -3: {
                return NativeArrayBuffer.isArg(args2, 0) && args2[0] instanceof NativeArrayBufferView;
            }
            case 1: {
                int length = NativeArrayBuffer.isArg(args2, 0) ? ScriptRuntime.toInt32(args2[0]) : 0;
                return new NativeArrayBuffer(length);
            }
            case 2: {
                NativeArrayBuffer self = NativeArrayBuffer.realThis(thisObj, f2);
                int start2 = NativeArrayBuffer.isArg(args2, 0) ? ScriptRuntime.toInt32(args2[0]) : 0;
                int end2 = NativeArrayBuffer.isArg(args2, 1) ? ScriptRuntime.toInt32(args2[1]) : self.buffer.length;
                return self.slice(start2, end2);
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    private static NativeArrayBuffer realThis(Scriptable thisObj, IdFunctionObject f2) {
        if (!(thisObj instanceof NativeArrayBuffer)) {
            throw NativeArrayBuffer.incompatibleCallError(f2);
        }
        return (NativeArrayBuffer)thisObj;
    }

    private static boolean isArg(Object[] args2, int i2) {
        return args2.length > i2 && !Undefined.instance.equals(args2[i2]);
    }

    @Override
    protected void initPrototypeId(int id) {
        String s2;
        int arity;
        switch (id) {
            case 1: {
                arity = 1;
                s2 = "constructor";
                break;
            }
            case 2: {
                arity = 1;
                s2 = "slice";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(CLASS_NAME, id, s2, arity);
    }

    @Override
    protected int findPrototypeId(String s2) {
        int id;
        block5: {
            id = 0;
            String X = null;
            int s_length = s2.length();
            if (s_length == 5) {
                X = "slice";
                id = 2;
            } else if (s_length == 6) {
                X = "isView";
                id = 3;
            } else if (s_length == 11) {
                X = "constructor";
                id = 1;
            }
            if (X == null || X == s2 || X.equals(s2)) break block5;
            id = 0;
        }
        return id;
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject ctor) {
        this.addIdFunctionProperty(ctor, CLASS_NAME, -3, "isView", 1);
    }

    @Override
    protected int getMaxInstanceId() {
        return 1;
    }

    @Override
    protected String getInstanceIdName(int id) {
        if (id == 1) {
            return "byteLength";
        }
        return super.getInstanceIdName(id);
    }

    @Override
    protected Object getInstanceIdValue(int id) {
        if (id == 1) {
            return ScriptRuntime.wrapInt(this.buffer.length);
        }
        return super.getInstanceIdValue(id);
    }

    @Override
    protected int findInstanceIdInfo(String s2) {
        if ("byteLength".equals(s2)) {
            return NativeArrayBuffer.instanceIdInfo(5, 1);
        }
        return super.findInstanceIdInfo(s2);
    }
}

