/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.ByteIo;
import org.mozilla.javascript.typedarrays.Conversions;
import org.mozilla.javascript.typedarrays.NativeArrayBuffer;
import org.mozilla.javascript.typedarrays.NativeArrayBufferView;

public class NativeDataView
extends NativeArrayBufferView {
    private static final long serialVersionUID = 1427967607557438968L;
    public static final String CLASS_NAME = "DataView";
    private static final int Id_constructor = 1;
    private static final int Id_getInt8 = 2;
    private static final int Id_getUint8 = 3;
    private static final int Id_getInt16 = 4;
    private static final int Id_getUint16 = 5;
    private static final int Id_getInt32 = 6;
    private static final int Id_getUint32 = 7;
    private static final int Id_getFloat32 = 8;
    private static final int Id_getFloat64 = 9;
    private static final int Id_setInt8 = 10;
    private static final int Id_setUint8 = 11;
    private static final int Id_setInt16 = 12;
    private static final int Id_setUint16 = 13;
    private static final int Id_setInt32 = 14;
    private static final int Id_setUint32 = 15;
    private static final int Id_setFloat32 = 16;
    private static final int Id_setFloat64 = 17;
    private static final int MAX_PROTOTYPE_ID = 17;

    public NativeDataView() {
    }

    public NativeDataView(NativeArrayBuffer ab, int offset, int length) {
        super(ab, offset, length);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeDataView dv = new NativeDataView();
        dv.exportAsJSClass(17, scope, sealed);
    }

    private void rangeCheck(int offset, int len2) {
        if (offset < 0 || offset + len2 > this.byteLength) {
            throw ScriptRuntime.constructError("RangeError", "offset out of range");
        }
    }

    private void checkOffset(Object[] args2, int pos) {
        if (args2.length <= pos) {
            throw ScriptRuntime.constructError("TypeError", "missing required offset parameter");
        }
        if (Undefined.instance.equals(args2[pos])) {
            throw ScriptRuntime.constructError("RangeError", "invalid offset");
        }
    }

    private void checkValue(Object[] args2, int pos) {
        if (args2.length <= pos) {
            throw ScriptRuntime.constructError("TypeError", "missing required value parameter");
        }
        if (Undefined.instance.equals(args2[pos])) {
            throw ScriptRuntime.constructError("RangeError", "invalid value parameter");
        }
    }

    private static NativeDataView realThis(Scriptable thisObj, IdFunctionObject f2) {
        if (!(thisObj instanceof NativeDataView)) {
            throw NativeDataView.incompatibleCallError(f2);
        }
        return (NativeDataView)thisObj;
    }

    private NativeDataView js_constructor(NativeArrayBuffer ab, int offset, int length) {
        if (length < 0) {
            throw ScriptRuntime.constructError("RangeError", "length out of range");
        }
        if (offset < 0 || offset + length > ab.getLength()) {
            throw ScriptRuntime.constructError("RangeError", "offset out of range");
        }
        return new NativeDataView(ab, offset, length);
    }

    private Object js_getInt(int bytes, boolean signed, Object[] args2) {
        this.checkOffset(args2, 0);
        int pos = ScriptRuntime.toInt32(args2[0]);
        this.rangeCheck(pos, bytes);
        boolean littleEndian = NativeDataView.isArg(args2, 1) && bytes > 1 && ScriptRuntime.toBoolean(args2[1]);
        switch (bytes) {
            case 1: {
                return signed ? ByteIo.readInt8(this.arrayBuffer.buffer, this.offset + pos) : ByteIo.readUint8(this.arrayBuffer.buffer, this.offset + pos);
            }
            case 2: {
                return signed ? ByteIo.readInt16(this.arrayBuffer.buffer, this.offset + pos, littleEndian) : ByteIo.readUint16(this.arrayBuffer.buffer, this.offset + pos, littleEndian);
            }
            case 4: {
                return signed ? ByteIo.readInt32(this.arrayBuffer.buffer, this.offset + pos, littleEndian) : ByteIo.readUint32(this.arrayBuffer.buffer, this.offset + pos, littleEndian);
            }
        }
        throw new AssertionError();
    }

    private Object js_getFloat(int bytes, Object[] args2) {
        this.checkOffset(args2, 0);
        int pos = ScriptRuntime.toInt32(args2[0]);
        this.rangeCheck(pos, bytes);
        boolean littleEndian = NativeDataView.isArg(args2, 1) && bytes > 1 && ScriptRuntime.toBoolean(args2[1]);
        switch (bytes) {
            case 4: {
                return ByteIo.readFloat32(this.arrayBuffer.buffer, this.offset + pos, littleEndian);
            }
            case 8: {
                return ByteIo.readFloat64(this.arrayBuffer.buffer, this.offset + pos, littleEndian);
            }
        }
        throw new AssertionError();
    }

    private void js_setInt(int bytes, boolean signed, Object[] args2) {
        this.checkOffset(args2, 0);
        this.checkValue(args2, 1);
        int pos = ScriptRuntime.toInt32(args2[0]);
        this.rangeCheck(pos, bytes);
        boolean littleEndian = NativeDataView.isArg(args2, 2) && bytes > 1 && ScriptRuntime.toBoolean(args2[2]);
        switch (bytes) {
            case 1: {
                if (signed) {
                    ByteIo.writeInt8(this.arrayBuffer.buffer, this.offset + pos, Conversions.toInt8(args2[1]));
                    break;
                }
                ByteIo.writeUint8(this.arrayBuffer.buffer, this.offset + pos, Conversions.toUint8(args2[1]));
                break;
            }
            case 2: {
                if (signed) {
                    ByteIo.writeInt16(this.arrayBuffer.buffer, this.offset + pos, Conversions.toInt16(args2[1]), littleEndian);
                    break;
                }
                ByteIo.writeUint16(this.arrayBuffer.buffer, this.offset + pos, Conversions.toUint16(args2[1]), littleEndian);
                break;
            }
            case 4: {
                if (signed) {
                    ByteIo.writeInt32(this.arrayBuffer.buffer, this.offset + pos, Conversions.toInt32(args2[1]), littleEndian);
                    break;
                }
                ByteIo.writeUint32(this.arrayBuffer.buffer, this.offset + pos, Conversions.toUint32(args2[1]), littleEndian);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void js_setFloat(int bytes, Object[] args2) {
        this.checkOffset(args2, 0);
        this.checkValue(args2, 1);
        int pos = ScriptRuntime.toInt32(args2[0]);
        this.rangeCheck(pos, bytes);
        boolean littleEndian = NativeDataView.isArg(args2, 2) && bytes > 1 && ScriptRuntime.toBoolean(args2[2]);
        double val = ScriptRuntime.toNumber(args2[1]);
        switch (bytes) {
            case 4: {
                ByteIo.writeFloat32(this.arrayBuffer.buffer, this.offset + pos, val, littleEndian);
                break;
            }
            case 8: {
                ByteIo.writeFloat64(this.arrayBuffer.buffer, this.offset + pos, val, littleEndian);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    public Object execIdCall(IdFunctionObject f2, Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        if (!f2.hasTag(this.getClassName())) {
            return super.execIdCall(f2, cx, scope, thisObj, args2);
        }
        int id = f2.methodId();
        switch (id) {
            case 1: {
                if (NativeDataView.isArg(args2, 0) && args2[0] instanceof NativeArrayBuffer) {
                    NativeArrayBuffer ab = (NativeArrayBuffer)args2[0];
                    int off = NativeDataView.isArg(args2, 1) ? ScriptRuntime.toInt32(args2[1]) : 0;
                    int len2 = NativeDataView.isArg(args2, 2) ? ScriptRuntime.toInt32(args2[2]) : ab.getLength() - off;
                    return this.js_constructor(ab, off, len2);
                }
                throw ScriptRuntime.constructError("TypeError", "Missing parameters");
            }
            case 2: {
                return NativeDataView.realThis(thisObj, f2).js_getInt(1, true, args2);
            }
            case 3: {
                return NativeDataView.realThis(thisObj, f2).js_getInt(1, false, args2);
            }
            case 4: {
                return NativeDataView.realThis(thisObj, f2).js_getInt(2, true, args2);
            }
            case 5: {
                return NativeDataView.realThis(thisObj, f2).js_getInt(2, false, args2);
            }
            case 6: {
                return NativeDataView.realThis(thisObj, f2).js_getInt(4, true, args2);
            }
            case 7: {
                return NativeDataView.realThis(thisObj, f2).js_getInt(4, false, args2);
            }
            case 8: {
                return NativeDataView.realThis(thisObj, f2).js_getFloat(4, args2);
            }
            case 9: {
                return NativeDataView.realThis(thisObj, f2).js_getFloat(8, args2);
            }
            case 10: {
                NativeDataView.realThis(thisObj, f2).js_setInt(1, true, args2);
                return Undefined.instance;
            }
            case 11: {
                NativeDataView.realThis(thisObj, f2).js_setInt(1, false, args2);
                return Undefined.instance;
            }
            case 12: {
                NativeDataView.realThis(thisObj, f2).js_setInt(2, true, args2);
                return Undefined.instance;
            }
            case 13: {
                NativeDataView.realThis(thisObj, f2).js_setInt(2, false, args2);
                return Undefined.instance;
            }
            case 14: {
                NativeDataView.realThis(thisObj, f2).js_setInt(4, true, args2);
                return Undefined.instance;
            }
            case 15: {
                NativeDataView.realThis(thisObj, f2).js_setInt(4, false, args2);
                return Undefined.instance;
            }
            case 16: {
                NativeDataView.realThis(thisObj, f2).js_setFloat(4, args2);
                return Undefined.instance;
            }
            case 17: {
                NativeDataView.realThis(thisObj, f2).js_setFloat(8, args2);
                return Undefined.instance;
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    @Override
    protected void initPrototypeId(int id) {
        String s2;
        int arity;
        switch (id) {
            case 1: {
                arity = 1;
                s2 = "constructor";
                break;
            }
            case 2: {
                arity = 1;
                s2 = "getInt8";
                break;
            }
            case 3: {
                arity = 1;
                s2 = "getUint8";
                break;
            }
            case 4: {
                arity = 1;
                s2 = "getInt16";
                break;
            }
            case 5: {
                arity = 1;
                s2 = "getUint16";
                break;
            }
            case 6: {
                arity = 1;
                s2 = "getInt32";
                break;
            }
            case 7: {
                arity = 1;
                s2 = "getUint32";
                break;
            }
            case 8: {
                arity = 1;
                s2 = "getFloat32";
                break;
            }
            case 9: {
                arity = 1;
                s2 = "getFloat64";
                break;
            }
            case 10: {
                arity = 2;
                s2 = "setInt8";
                break;
            }
            case 11: {
                arity = 2;
                s2 = "setUint8";
                break;
            }
            case 12: {
                arity = 2;
                s2 = "setInt16";
                break;
            }
            case 13: {
                arity = 2;
                s2 = "setUint16";
                break;
            }
            case 14: {
                arity = 2;
                s2 = "setInt32";
                break;
            }
            case 15: {
                arity = 2;
                s2 = "setUint32";
                break;
            }
            case 16: {
                arity = 2;
                s2 = "setFloat32";
                break;
            }
            case 17: {
                arity = 2;
                s2 = "setFloat64";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(this.getClassName(), id, s2, arity);
    }

    @Override
    protected int findPrototypeId(String s2) {
        int id;
        block19: {
            id = 0;
            String X = null;
            switch (s2.length()) {
                case 7: {
                    char c2 = s2.charAt(0);
                    if (c2 == 'g') {
                        X = "getInt8";
                        id = 2;
                        break;
                    }
                    if (c2 != 's') break;
                    X = "setInt8";
                    id = 10;
                    break;
                }
                case 8: {
                    char c3 = s2.charAt(6);
                    if (c3 == '1') {
                        c3 = s2.charAt(0);
                        if (c3 == 'g') {
                            X = "getInt16";
                            id = 4;
                            break;
                        }
                        if (c3 != 's') break;
                        X = "setInt16";
                        id = 12;
                        break;
                    }
                    if (c3 == '3') {
                        c3 = s2.charAt(0);
                        if (c3 == 'g') {
                            X = "getInt32";
                            id = 6;
                            break;
                        }
                        if (c3 != 's') break;
                        X = "setInt32";
                        id = 14;
                        break;
                    }
                    if (c3 != 't') break;
                    c3 = s2.charAt(0);
                    if (c3 == 'g') {
                        X = "getUint8";
                        id = 3;
                        break;
                    }
                    if (c3 != 's') break;
                    X = "setUint8";
                    id = 11;
                    break;
                }
                case 9: {
                    char c4 = s2.charAt(0);
                    if (c4 == 'g') {
                        c4 = s2.charAt(8);
                        if (c4 == '2') {
                            X = "getUint32";
                            id = 7;
                            break;
                        }
                        if (c4 != '6') break;
                        X = "getUint16";
                        id = 5;
                        break;
                    }
                    if (c4 != 's') break;
                    c4 = s2.charAt(8);
                    if (c4 == '2') {
                        X = "setUint32";
                        id = 15;
                        break;
                    }
                    if (c4 != '6') break;
                    X = "setUint16";
                    id = 13;
                    break;
                }
                case 10: {
                    char c5 = s2.charAt(0);
                    if (c5 == 'g') {
                        c5 = s2.charAt(9);
                        if (c5 == '2') {
                            X = "getFloat32";
                            id = 8;
                            break;
                        }
                        if (c5 != '4') break;
                        X = "getFloat64";
                        id = 9;
                        break;
                    }
                    if (c5 != 's') break;
                    c5 = s2.charAt(9);
                    if (c5 == '2') {
                        X = "setFloat32";
                        id = 16;
                        break;
                    }
                    if (c5 != '4') break;
                    X = "setFloat64";
                    id = 17;
                    break;
                }
                case 11: {
                    X = "constructor";
                    id = 1;
                    break;
                }
            }
            if (X == null || X == s2 || X.equals(s2)) break block19;
            id = 0;
        }
        return id;
    }
}

