/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.ByteIo;
import org.mozilla.javascript.typedarrays.NativeArrayBuffer;
import org.mozilla.javascript.typedarrays.NativeTypedArrayView;

public class NativeFloat32Array
extends NativeTypedArrayView<Float> {
    private static final long serialVersionUID = -8963461831950499340L;
    private static final String CLASS_NAME = "Float32Array";
    private static final int BYTES_PER_ELEMENT = 4;

    public NativeFloat32Array() {
    }

    public NativeFloat32Array(NativeArrayBuffer ab, int off, int len2) {
        super(ab, off, len2, len2 * 4);
    }

    public NativeFloat32Array(int len2) {
        this(new NativeArrayBuffer(len2 * 4), 0, len2);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeFloat32Array a2 = new NativeFloat32Array();
        a2.exportAsJSClass(5, scope, sealed);
    }

    @Override
    protected NativeTypedArrayView construct(NativeArrayBuffer ab, int off, int len2) {
        return new NativeFloat32Array(ab, off, len2);
    }

    @Override
    public int getBytesPerElement() {
        return 4;
    }

    @Override
    protected NativeTypedArrayView realThis(Scriptable thisObj, IdFunctionObject f2) {
        if (!(thisObj instanceof NativeFloat32Array)) {
            throw NativeFloat32Array.incompatibleCallError(f2);
        }
        return (NativeFloat32Array)thisObj;
    }

    @Override
    protected Object js_get(int index) {
        if (this.checkIndex(index)) {
            return Undefined.instance;
        }
        return ByteIo.readFloat32(this.arrayBuffer.buffer, index * 4 + this.offset, false);
    }

    @Override
    protected Object js_set(int index, Object c2) {
        if (this.checkIndex(index)) {
            return Undefined.instance;
        }
        double val = ScriptRuntime.toNumber(c2);
        ByteIo.writeFloat32(this.arrayBuffer.buffer, index * 4 + this.offset, val, false);
        return null;
    }

    @Override
    public Float get(int i2) {
        if (this.checkIndex(i2)) {
            throw new IndexOutOfBoundsException();
        }
        return (Float)this.js_get(i2);
    }

    @Override
    public Float set(int i2, Float aByte) {
        if (this.checkIndex(i2)) {
            throw new IndexOutOfBoundsException();
        }
        return (Float)this.js_set(i2, aByte);
    }
}

