/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.ByteIo;
import org.mozilla.javascript.typedarrays.Conversions;
import org.mozilla.javascript.typedarrays.NativeArrayBuffer;
import org.mozilla.javascript.typedarrays.NativeTypedArrayView;

public class NativeInt16Array
extends NativeTypedArrayView<Short> {
    private static final long serialVersionUID = -8592870435287581398L;
    private static final String CLASS_NAME = "Int16Array";
    private static final int BYTES_PER_ELEMENT = 2;

    public NativeInt16Array() {
    }

    public NativeInt16Array(NativeArrayBuffer ab, int off, int len2) {
        super(ab, off, len2, len2 * 2);
    }

    public NativeInt16Array(int len2) {
        this(new NativeArrayBuffer(len2 * 2), 0, len2);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeInt16Array a2 = new NativeInt16Array();
        a2.exportAsJSClass(5, scope, sealed);
    }

    @Override
    protected NativeTypedArrayView construct(NativeArrayBuffer ab, int off, int len2) {
        return new NativeInt16Array(ab, off, len2);
    }

    @Override
    public int getBytesPerElement() {
        return 2;
    }

    @Override
    protected NativeTypedArrayView realThis(Scriptable thisObj, IdFunctionObject f2) {
        if (!(thisObj instanceof NativeInt16Array)) {
            throw NativeInt16Array.incompatibleCallError(f2);
        }
        return (NativeInt16Array)thisObj;
    }

    @Override
    protected Object js_get(int index) {
        if (this.checkIndex(index)) {
            return Undefined.instance;
        }
        return ByteIo.readInt16(this.arrayBuffer.buffer, index * 2 + this.offset, false);
    }

    @Override
    protected Object js_set(int index, Object c2) {
        if (this.checkIndex(index)) {
            return Undefined.instance;
        }
        int val = Conversions.toInt16(c2);
        ByteIo.writeInt16(this.arrayBuffer.buffer, index * 2 + this.offset, val, false);
        return null;
    }

    @Override
    public Short get(int i2) {
        if (this.checkIndex(i2)) {
            throw new IndexOutOfBoundsException();
        }
        return (Short)this.js_get(i2);
    }

    @Override
    public Short set(int i2, Short aByte) {
        if (this.checkIndex(i2)) {
            throw new IndexOutOfBoundsException();
        }
        return (Short)this.js_set(i2, aByte);
    }
}

