/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.ByteIo;
import org.mozilla.javascript.typedarrays.Conversions;
import org.mozilla.javascript.typedarrays.NativeArrayBuffer;
import org.mozilla.javascript.typedarrays.NativeTypedArrayView;

public class NativeInt8Array
extends NativeTypedArrayView<Byte> {
    private static final long serialVersionUID = -3349419704390398895L;
    private static final String CLASS_NAME = "Int8Array";

    public NativeInt8Array() {
    }

    public NativeInt8Array(NativeArrayBuffer ab, int off, int len2) {
        super(ab, off, len2, len2);
    }

    public NativeInt8Array(int len2) {
        this(new NativeArrayBuffer(len2), 0, len2);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeInt8Array a2 = new NativeInt8Array();
        a2.exportAsJSClass(5, scope, sealed);
    }

    @Override
    protected NativeTypedArrayView construct(NativeArrayBuffer ab, int off, int len2) {
        return new NativeInt8Array(ab, off, len2);
    }

    @Override
    public int getBytesPerElement() {
        return 1;
    }

    @Override
    protected NativeTypedArrayView realThis(Scriptable thisObj, IdFunctionObject f2) {
        if (!(thisObj instanceof NativeInt8Array)) {
            throw NativeInt8Array.incompatibleCallError(f2);
        }
        return (NativeInt8Array)thisObj;
    }

    @Override
    protected Object js_get(int index) {
        if (this.checkIndex(index)) {
            return Undefined.instance;
        }
        return ByteIo.readInt8(this.arrayBuffer.buffer, index + this.offset);
    }

    @Override
    protected Object js_set(int index, Object c2) {
        if (this.checkIndex(index)) {
            return Undefined.instance;
        }
        int val = Conversions.toInt8(c2);
        ByteIo.writeInt8(this.arrayBuffer.buffer, index + this.offset, val);
        return null;
    }

    @Override
    public Byte get(int i2) {
        if (this.checkIndex(i2)) {
            throw new IndexOutOfBoundsException();
        }
        return (Byte)this.js_get(i2);
    }

    @Override
    public Byte set(int i2, Byte aByte) {
        if (this.checkIndex(i2)) {
            throw new IndexOutOfBoundsException();
        }
        return (Byte)this.js_set(i2, aByte);
    }
}

