/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ExternalArrayData;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeArrayIterator;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.NativeArrayBuffer;
import org.mozilla.javascript.typedarrays.NativeArrayBufferView;
import org.mozilla.javascript.typedarrays.NativeTypedArrayIterator;

public abstract class NativeTypedArrayView<T>
extends NativeArrayBufferView
implements List<T>,
RandomAccess,
ExternalArrayData {
    protected final int length;
    private static final int Id_constructor = 1;
    private static final int Id_get = 2;
    private static final int Id_set = 3;
    private static final int Id_subarray = 4;
    private static final int SymbolId_iterator = 5;
    protected static final int MAX_PROTOTYPE_ID = 5;
    private static final int Id_length = 10;
    private static final int Id_BYTES_PER_ELEMENT = 11;
    private static final int MAX_INSTANCE_ID = 11;

    protected NativeTypedArrayView() {
        this.length = 0;
    }

    protected NativeTypedArrayView(NativeArrayBuffer ab, int off, int len2, int byteLen) {
        super(ab, off, byteLen);
        this.length = len2;
    }

    @Override
    public Object get(int index, Scriptable start2) {
        return this.js_get(index);
    }

    @Override
    public boolean has(int index, Scriptable start2) {
        return index > 0 && index < this.length;
    }

    @Override
    public void put(int index, Scriptable start2, Object val) {
        this.js_set(index, val);
    }

    @Override
    public void delete(int index) {
    }

    @Override
    public Object[] getIds() {
        Object[] ret = new Object[this.length];
        for (int i2 = 0; i2 < this.length; ++i2) {
            ret[i2] = i2;
        }
        return ret;
    }

    protected boolean checkIndex(int index) {
        return index < 0 || index >= this.length;
    }

    public abstract int getBytesPerElement();

    protected abstract NativeTypedArrayView construct(NativeArrayBuffer var1, int var2, int var3);

    protected abstract Object js_get(int var1);

    protected abstract Object js_set(int var1, Object var2);

    protected abstract NativeTypedArrayView realThis(Scriptable var1, IdFunctionObject var2);

    private NativeArrayBuffer makeArrayBuffer(Context cx, Scriptable scope, int length) {
        return (NativeArrayBuffer)cx.newObject(scope, "ArrayBuffer", new Object[]{length});
    }

    private NativeTypedArrayView js_constructor(Context cx, Scriptable scope, Object[] args2) {
        if (!NativeTypedArrayView.isArg(args2, 0)) {
            return this.construct(NativeArrayBuffer.EMPTY_BUFFER, 0, 0);
        }
        if (args2[0] instanceof Number || args2[0] instanceof String) {
            int length = ScriptRuntime.toInt32(args2[0]);
            NativeArrayBuffer buffer = this.makeArrayBuffer(cx, scope, length * this.getBytesPerElement());
            return this.construct(buffer, 0, length);
        }
        if (args2[0] instanceof NativeTypedArrayView) {
            NativeTypedArrayView src = (NativeTypedArrayView)args2[0];
            NativeArrayBuffer na = this.makeArrayBuffer(cx, scope, src.length * this.getBytesPerElement());
            NativeTypedArrayView v = this.construct(na, 0, src.length);
            for (int i2 = 0; i2 < src.length; ++i2) {
                v.js_set(i2, src.js_get(i2));
            }
            return v;
        }
        if (args2[0] instanceof NativeArrayBuffer) {
            NativeArrayBuffer na = (NativeArrayBuffer)args2[0];
            int byteOff = NativeTypedArrayView.isArg(args2, 1) ? ScriptRuntime.toInt32(args2[1]) : 0;
            int byteLen = NativeTypedArrayView.isArg(args2, 2) ? ScriptRuntime.toInt32(args2[2]) * this.getBytesPerElement() : na.getLength() - byteOff;
            if (byteOff < 0 || byteOff > na.buffer.length) {
                throw ScriptRuntime.constructError("RangeError", "offset out of range");
            }
            if (byteLen < 0 || byteOff + byteLen > na.buffer.length) {
                throw ScriptRuntime.constructError("RangeError", "length out of range");
            }
            if (byteOff % this.getBytesPerElement() != 0) {
                throw ScriptRuntime.constructError("RangeError", "offset must be a multiple of the byte size");
            }
            if (byteLen % this.getBytesPerElement() != 0) {
                throw ScriptRuntime.constructError("RangeError", "offset and buffer must be a multiple of the byte size");
            }
            return this.construct(na, byteOff, byteLen / this.getBytesPerElement());
        }
        if (args2[0] instanceof NativeArray) {
            List l = (List)args2[0];
            NativeArrayBuffer na = this.makeArrayBuffer(cx, scope, l.size() * this.getBytesPerElement());
            NativeTypedArrayView v = this.construct(na, 0, l.size());
            int p = 0;
            for (Object o : l) {
                v.js_set(p, o);
                ++p;
            }
            return v;
        }
        throw ScriptRuntime.constructError("Error", "invalid argument");
    }

    private void setRange(NativeTypedArrayView v, int off) {
        if (off >= this.length) {
            throw ScriptRuntime.constructError("RangeError", "offset out of range");
        }
        if (v.length > this.length - off) {
            throw ScriptRuntime.constructError("RangeError", "source array too long");
        }
        if (v.arrayBuffer == this.arrayBuffer) {
            int i2;
            Object[] tmp = new Object[v.length];
            for (i2 = 0; i2 < v.length; ++i2) {
                tmp[i2] = v.js_get(i2);
            }
            for (i2 = 0; i2 < v.length; ++i2) {
                this.js_set(i2 + off, tmp[i2]);
            }
        } else {
            for (int i3 = 0; i3 < v.length; ++i3) {
                this.js_set(i3 + off, v.js_get(i3));
            }
        }
    }

    private void setRange(NativeArray a2, int off) {
        if (off > this.length) {
            throw ScriptRuntime.constructError("RangeError", "offset out of range");
        }
        if (off + a2.size() > this.length) {
            throw ScriptRuntime.constructError("RangeError", "offset + length out of range");
        }
        int pos = off;
        for (Object val : a2) {
            this.js_set(pos, val);
            ++pos;
        }
    }

    private Object js_subarray(Context cx, Scriptable scope, int s2, int e2) {
        int start2 = s2 < 0 ? this.length + s2 : s2;
        int end2 = e2 < 0 ? this.length + e2 : e2;
        start2 = Math.max(0, start2);
        end2 = Math.min(this.length, end2);
        int len2 = Math.max(0, end2 - start2);
        int byteOff = Math.min(start2 * this.getBytesPerElement(), this.arrayBuffer.getLength());
        return cx.newObject(scope, this.getClassName(), new Object[]{this.arrayBuffer, byteOff, len2});
    }

    @Override
    public Object execIdCall(IdFunctionObject f2, Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        if (!f2.hasTag(this.getClassName())) {
            return super.execIdCall(f2, cx, scope, thisObj, args2);
        }
        int id = f2.methodId();
        switch (id) {
            case 1: {
                return this.js_constructor(cx, scope, args2);
            }
            case 2: {
                if (args2.length > 0) {
                    return this.realThis(thisObj, f2).js_get(ScriptRuntime.toInt32(args2[0]));
                }
                throw ScriptRuntime.constructError("Error", "invalid arguments");
            }
            case 3: {
                if (args2.length > 0) {
                    NativeTypedArrayView self = this.realThis(thisObj, f2);
                    if (args2[0] instanceof NativeTypedArrayView) {
                        int offset = NativeTypedArrayView.isArg(args2, 1) ? ScriptRuntime.toInt32(args2[1]) : 0;
                        self.setRange((NativeTypedArrayView)args2[0], offset);
                        return Undefined.instance;
                    }
                    if (args2[0] instanceof NativeArray) {
                        int offset = NativeTypedArrayView.isArg(args2, 1) ? ScriptRuntime.toInt32(args2[1]) : 0;
                        self.setRange((NativeArray)args2[0], offset);
                        return Undefined.instance;
                    }
                    if (args2[0] instanceof Scriptable) {
                        return Undefined.instance;
                    }
                    if (NativeTypedArrayView.isArg(args2, 2)) {
                        return self.js_set(ScriptRuntime.toInt32(args2[0]), args2[1]);
                    }
                }
                throw ScriptRuntime.constructError("Error", "invalid arguments");
            }
            case 4: {
                if (args2.length > 0) {
                    NativeTypedArrayView self = this.realThis(thisObj, f2);
                    int start2 = ScriptRuntime.toInt32(args2[0]);
                    int end2 = NativeTypedArrayView.isArg(args2, 1) ? ScriptRuntime.toInt32(args2[1]) : self.length;
                    return self.js_subarray(cx, scope, start2, end2);
                }
                throw ScriptRuntime.constructError("Error", "invalid arguments");
            }
            case 5: {
                return new NativeArrayIterator(scope, thisObj);
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    @Override
    protected void initPrototypeId(int id) {
        String s2;
        int arity;
        if (id == 5) {
            this.initPrototypeMethod((Object)this.getClassName(), id, SymbolKey.ITERATOR, "[Symbol.iterator]", 0);
            return;
        }
        String fnName = null;
        switch (id) {
            case 1: {
                arity = 1;
                s2 = "constructor";
                break;
            }
            case 2: {
                arity = 1;
                s2 = "get";
                break;
            }
            case 3: {
                arity = 2;
                s2 = "set";
                break;
            }
            case 4: {
                arity = 2;
                s2 = "subarray";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod((Object)this.getClassName(), id, s2, fnName, arity);
    }

    @Override
    protected int findPrototypeId(Symbol k2) {
        if (SymbolKey.ITERATOR.equals(k2)) {
            return 5;
        }
        return 0;
    }

    @Override
    protected int findPrototypeId(String s2) {
        int id;
        block6: {
            String X;
            block5: {
                int s_length;
                block3: {
                    char c2;
                    block4: {
                        id = 0;
                        X = null;
                        s_length = s2.length();
                        if (s_length != 3) break block3;
                        c2 = s2.charAt(0);
                        if (c2 != 'g') break block4;
                        if (s2.charAt(2) != 't' || s2.charAt(1) != 'e') break block5;
                        id = 2;
                        break block6;
                    }
                    if (c2 != 's' || s2.charAt(2) != 't' || s2.charAt(1) != 'e') break block5;
                    id = 3;
                    break block6;
                }
                if (s_length == 8) {
                    X = "subarray";
                    id = 4;
                } else if (s_length == 11) {
                    X = "constructor";
                    id = 1;
                }
            }
            if (X == null || X == s2 || X.equals(s2)) break block6;
            id = 0;
        }
        return id;
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject ctor) {
        ctor.put("BYTES_PER_ELEMENT", (Scriptable)ctor, (Object)ScriptRuntime.wrapInt(this.getBytesPerElement()));
    }

    @Override
    protected int getMaxInstanceId() {
        return 11;
    }

    @Override
    protected String getInstanceIdName(int id) {
        switch (id) {
            case 10: {
                return "length";
            }
            case 11: {
                return "BYTES_PER_ELEMENT";
            }
        }
        return super.getInstanceIdName(id);
    }

    @Override
    protected Object getInstanceIdValue(int id) {
        switch (id) {
            case 10: {
                return ScriptRuntime.wrapInt(this.length);
            }
            case 11: {
                return ScriptRuntime.wrapInt(this.getBytesPerElement());
            }
        }
        return super.getInstanceIdValue(id);
    }

    @Override
    protected int findInstanceIdInfo(String s2) {
        int id = 0;
        String X = null;
        int s_length = s2.length();
        if (s_length == 6) {
            X = "length";
            id = 10;
        } else if (s_length == 17) {
            X = "BYTES_PER_ELEMENT";
            id = 11;
        }
        if (X != null && X != s2 && !X.equals(s2)) {
            id = 0;
        }
        if (id == 0) {
            return super.findInstanceIdInfo(s2);
        }
        return NativeTypedArrayView.instanceIdInfo(5, id);
    }

    @Override
    public Object getArrayElement(int index) {
        return this.js_get(index);
    }

    @Override
    public void setArrayElement(int index, Object value2) {
        this.js_set(index, value2);
    }

    @Override
    public int getArrayLength() {
        return this.length;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        for (Object o : objects) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(Object o) {
        for (int i2 = 0; i2 < this.length; ++i2) {
            if (!o.equals(this.js_get(i2))) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i2 = this.length - 1; i2 >= 0; --i2) {
            if (!o.equals(this.js_get(i2))) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public Object[] toArray() {
        Object[] a2 = new Object[this.length];
        for (int i2 = 0; i2 < this.length; ++i2) {
            a2[i2] = this.js_get(i2);
        }
        return a2;
    }

    @Override
    public <U> U[] toArray(U[] ts) {
        Object[] a2 = ts.length >= this.length ? ts : (Object[])Array.newInstance(ts.getClass().getComponentType(), this.length);
        for (int i2 = 0; i2 < this.length; ++i2) {
            try {
                a2[i2] = this.js_get(i2);
                continue;
            }
            catch (ClassCastException cce) {
                throw new ArrayStoreException();
            }
        }
        return a2;
    }

    @Override
    public boolean equals(Object o) {
        try {
            NativeTypedArrayView v = (NativeTypedArrayView)o;
            if (this.length != v.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.length; ++i2) {
                if (this.js_get(i2).equals(v.js_get(i2))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int hc = 0;
        for (int i2 = 0; i2 < this.length; ++i2) {
            hc += this.js_get(i2).hashCode();
        }
        return 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new NativeTypedArrayIterator(this, 0);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new NativeTypedArrayIterator(this, 0);
    }

    @Override
    public ListIterator<T> listIterator(int start2) {
        if (this.checkIndex(start2)) {
            throw new IndexOutOfBoundsException();
        }
        return new NativeTypedArrayIterator(this, start2);
    }

    @Override
    public List<T> subList(int i2, int i22) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T aByte) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int i2, T aByte) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int i2, Collection<? extends T> bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int i2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        throw new UnsupportedOperationException();
    }
}

