/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.v8dtoa;

class DiyFp {
    private long f;
    private int e;
    static final int kSignificandSize = 64;
    static final long kUint64MSB = Long.MIN_VALUE;

    DiyFp() {
        this.f = 0L;
        this.e = 0;
    }

    DiyFp(long f2, int e2) {
        this.f = f2;
        this.e = e2;
    }

    private static boolean uint64_gte(long a2, long b2) {
        return a2 == b2 || a2 > b2 ^ a2 < 0L ^ b2 < 0L;
    }

    void subtract(DiyFp other) {
        assert (this.e == other.e);
        assert (DiyFp.uint64_gte(this.f, other.f));
        this.f -= other.f;
    }

    static DiyFp minus(DiyFp a2, DiyFp b2) {
        DiyFp result2 = new DiyFp(a2.f, a2.e);
        result2.subtract(b2);
        return result2;
    }

    void multiply(DiyFp other) {
        long kM32 = 0xFFFFFFFFL;
        long a2 = this.f >>> 32;
        long b2 = this.f & 0xFFFFFFFFL;
        long c2 = other.f >>> 32;
        long d2 = other.f & 0xFFFFFFFFL;
        long ac = a2 * c2;
        long bc = b2 * c2;
        long ad = a2 * d2;
        long bd = b2 * d2;
        long tmp = (bd >>> 32) + (ad & 0xFFFFFFFFL) + (bc & 0xFFFFFFFFL);
        long result_f = ac + (ad >>> 32) + (bc >>> 32) + ((tmp += 0x80000000L) >>> 32);
        this.e += other.e + 64;
        this.f = result_f;
    }

    static DiyFp times(DiyFp a2, DiyFp b2) {
        DiyFp result2 = new DiyFp(a2.f, a2.e);
        result2.multiply(b2);
        return result2;
    }

    void normalize() {
        assert (this.f != 0L);
        long f2 = this.f;
        int e2 = this.e;
        long k10MSBits = -18014398509481984L;
        while ((f2 & 0xFFC0000000000000L) == 0L) {
            f2 <<= 10;
            e2 -= 10;
        }
        while ((f2 & Long.MIN_VALUE) == 0L) {
            f2 <<= 1;
            --e2;
        }
        this.f = f2;
        this.e = e2;
    }

    static DiyFp normalize(DiyFp a2) {
        DiyFp result2 = new DiyFp(a2.f, a2.e);
        result2.normalize();
        return result2;
    }

    long f() {
        return this.f;
    }

    int e() {
        return this.e;
    }

    void setF(long new_value) {
        this.f = new_value;
    }

    void setE(int new_value) {
        this.e = new_value;
    }

    public String toString() {
        return "[DiyFp f:" + this.f + ", e:" + this.e + "]";
    }
}

