/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xmlimpl.QName;
import org.mozilla.javascript.xmlimpl.XMLName;
import org.mozilla.javascript.xmlimpl.XmlNode;

class Namespace
extends IdScriptableObject {
    static final long serialVersionUID = -5765755238131301744L;
    private static final Object NAMESPACE_TAG = "Namespace";
    private Namespace prototype;
    private XmlNode.Namespace ns;
    private static final int Id_prefix = 1;
    private static final int Id_uri = 2;
    private static final int MAX_INSTANCE_ID = 2;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int MAX_PROTOTYPE_ID = 3;

    private Namespace() {
    }

    static Namespace create(Scriptable scope, Namespace prototype, XmlNode.Namespace namespace) {
        Namespace rv = new Namespace();
        rv.setParentScope(scope);
        rv.prototype = prototype;
        rv.setPrototype(prototype);
        rv.ns = namespace;
        return rv;
    }

    final XmlNode.Namespace getDelegate() {
        return this.ns;
    }

    public void exportAsJSClass(boolean sealed) {
        this.exportAsJSClass(3, this.getParentScope(), sealed);
    }

    public String uri() {
        return this.ns.getUri();
    }

    public String prefix() {
        return this.ns.getPrefix();
    }

    public String toString() {
        return this.uri();
    }

    public String toLocaleString() {
        return this.toString();
    }

    private boolean equals(Namespace n) {
        return this.uri().equals(n.uri());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Namespace)) {
            return false;
        }
        return this.equals((Namespace)obj);
    }

    public int hashCode() {
        return this.uri().hashCode();
    }

    @Override
    protected Object equivalentValues(Object value2) {
        if (!(value2 instanceof Namespace)) {
            return Scriptable.NOT_FOUND;
        }
        boolean result2 = this.equals((Namespace)value2);
        return result2 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public String getClassName() {
        return "Namespace";
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        return this.uri();
    }

    @Override
    protected int getMaxInstanceId() {
        return super.getMaxInstanceId() + 2;
    }

    @Override
    protected int findInstanceIdInfo(String s2) {
        int attr;
        int id = 0;
        String X = null;
        int s_length = s2.length();
        if (s_length == 3) {
            X = "uri";
            id = 2;
        } else if (s_length == 6) {
            X = "prefix";
            id = 1;
        }
        if (X != null && X != s2 && !X.equals(s2)) {
            id = 0;
        }
        if (id == 0) {
            return super.findInstanceIdInfo(s2);
        }
        switch (id) {
            case 1: 
            case 2: {
                attr = 5;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return Namespace.instanceIdInfo(attr, super.getMaxInstanceId() + id);
    }

    @Override
    protected String getInstanceIdName(int id) {
        switch (id - super.getMaxInstanceId()) {
            case 1: {
                return "prefix";
            }
            case 2: {
                return "uri";
            }
        }
        return super.getInstanceIdName(id);
    }

    @Override
    protected Object getInstanceIdValue(int id) {
        switch (id - super.getMaxInstanceId()) {
            case 1: {
                if (this.ns.getPrefix() == null) {
                    return Undefined.instance;
                }
                return this.ns.getPrefix();
            }
            case 2: {
                return this.ns.getUri();
            }
        }
        return super.getInstanceIdValue(id);
    }

    @Override
    protected int findPrototypeId(String s2) {
        int id;
        block6: {
            id = 0;
            String X = null;
            int s_length = s2.length();
            if (s_length == 8) {
                char c2 = s2.charAt(3);
                if (c2 == 'o') {
                    X = "toSource";
                    id = 3;
                } else if (c2 == 't') {
                    X = "toString";
                    id = 2;
                }
            } else if (s_length == 11) {
                X = "constructor";
                id = 1;
            }
            if (X == null || X == s2 || X.equals(s2)) break block6;
            id = 0;
        }
        return id;
    }

    @Override
    protected void initPrototypeId(int id) {
        String s2;
        int arity;
        switch (id) {
            case 1: {
                arity = 2;
                s2 = "constructor";
                break;
            }
            case 2: {
                arity = 0;
                s2 = "toString";
                break;
            }
            case 3: {
                arity = 0;
                s2 = "toSource";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(NAMESPACE_TAG, id, s2, arity);
    }

    @Override
    public Object execIdCall(IdFunctionObject f2, Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        if (!f2.hasTag(NAMESPACE_TAG)) {
            return super.execIdCall(f2, cx, scope, thisObj, args2);
        }
        int id = f2.methodId();
        switch (id) {
            case 1: {
                return this.jsConstructor(cx, thisObj == null, args2);
            }
            case 2: {
                return this.realThis(thisObj, f2).toString();
            }
            case 3: {
                return this.realThis(thisObj, f2).js_toSource();
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    private Namespace realThis(Scriptable thisObj, IdFunctionObject f2) {
        if (!(thisObj instanceof Namespace)) {
            throw Namespace.incompatibleCallError(f2);
        }
        return (Namespace)thisObj;
    }

    Namespace newNamespace(String uri2) {
        Namespace prototype = this.prototype == null ? this : this.prototype;
        return Namespace.create(this.getParentScope(), prototype, XmlNode.Namespace.create(uri2));
    }

    Namespace newNamespace(String prefix2, String uri2) {
        if (prefix2 == null) {
            return this.newNamespace(uri2);
        }
        Namespace prototype = this.prototype == null ? this : this.prototype;
        return Namespace.create(this.getParentScope(), prototype, XmlNode.Namespace.create(prefix2, uri2));
    }

    Namespace constructNamespace(Object uriValue) {
        String uri2;
        String prefix2;
        if (uriValue instanceof Namespace) {
            Namespace ns = (Namespace)uriValue;
            prefix2 = ns.prefix();
            uri2 = ns.uri();
        } else if (uriValue instanceof QName) {
            QName qname = (QName)uriValue;
            uri2 = qname.uri();
            if (uri2 != null) {
                prefix2 = qname.prefix();
            } else {
                uri2 = qname.toString();
                prefix2 = null;
            }
        } else {
            uri2 = ScriptRuntime.toString(uriValue);
            prefix2 = uri2.length() == 0 ? "" : null;
        }
        return this.newNamespace(prefix2, uri2);
    }

    Namespace castToNamespace(Object namespaceObj) {
        if (namespaceObj instanceof Namespace) {
            return (Namespace)namespaceObj;
        }
        return this.constructNamespace(namespaceObj);
    }

    private Namespace constructNamespace(Object prefixValue, Object uriValue) {
        String prefix2;
        String uri2;
        if (uriValue instanceof QName) {
            QName qname = (QName)uriValue;
            uri2 = qname.uri();
            if (uri2 == null) {
                uri2 = qname.toString();
            }
        } else {
            uri2 = ScriptRuntime.toString(uriValue);
        }
        if (uri2.length() == 0) {
            if (prefixValue == Undefined.instance) {
                prefix2 = "";
            } else {
                prefix2 = ScriptRuntime.toString(prefixValue);
                if (prefix2.length() != 0) {
                    throw ScriptRuntime.typeError("Illegal prefix '" + prefix2 + "' for 'no namespace'.");
                }
            }
        } else {
            prefix2 = prefixValue == Undefined.instance ? "" : (!XMLName.accept(prefixValue) ? "" : ScriptRuntime.toString(prefixValue));
        }
        return this.newNamespace(prefix2, uri2);
    }

    private Namespace constructNamespace() {
        return this.newNamespace("", "");
    }

    private Object jsConstructor(Context cx, boolean inNewExpr, Object[] args2) {
        if (!inNewExpr && args2.length == 1) {
            return this.castToNamespace(args2[0]);
        }
        if (args2.length == 0) {
            return this.constructNamespace();
        }
        if (args2.length == 1) {
            return this.constructNamespace(args2[0]);
        }
        return this.constructNamespace(args2[0], args2[1]);
    }

    private String js_toSource() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        Namespace.toSourceImpl(this.ns.getPrefix(), this.ns.getUri(), sb);
        sb.append(')');
        return sb.toString();
    }

    static void toSourceImpl(String prefix2, String uri2, StringBuilder sb) {
        sb.append("new Namespace(");
        if (uri2.length() == 0) {
            if (!"".equals(prefix2)) {
                throw new IllegalArgumentException(prefix2);
            }
        } else {
            sb.append('\'');
            if (prefix2 != null) {
                sb.append(ScriptRuntime.escapeString(prefix2, '\''));
                sb.append("', '");
            }
            sb.append(ScriptRuntime.escapeString(uri2, '\''));
            sb.append('\'');
        }
        sb.append(')');
    }
}

