/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Ref;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xmlimpl.XML;
import org.mozilla.javascript.xmlimpl.XMLList;
import org.mozilla.javascript.xmlimpl.XMLObjectImpl;
import org.mozilla.javascript.xmlimpl.XmlNode;

class XMLName
extends Ref {
    static final long serialVersionUID = 3832176310755686977L;
    private XmlNode.QName qname;
    private boolean isAttributeName;
    private boolean isDescendants;
    private XMLObjectImpl xmlObject;

    private static boolean isNCNameStartChar(int c2) {
        if ((c2 & 0xFFFFFF80) == 0) {
            if (c2 >= 97) {
                return c2 <= 122;
            }
            if (c2 >= 65) {
                if (c2 <= 90) {
                    return true;
                }
                return c2 == 95;
            }
        } else if ((c2 & 0xFFFFE000) == 0) {
            return 192 <= c2 && c2 <= 214 || 216 <= c2 && c2 <= 246 || 248 <= c2 && c2 <= 767 || 880 <= c2 && c2 <= 893 || 895 <= c2;
        }
        return 8204 <= c2 && c2 <= 8205 || 8304 <= c2 && c2 <= 8591 || 11264 <= c2 && c2 <= 12271 || 12289 <= c2 && c2 <= 55295 || 63744 <= c2 && c2 <= 64975 || 65008 <= c2 && c2 <= 65533 || 65536 <= c2 && c2 <= 983039;
    }

    private static boolean isNCNameChar(int c2) {
        if ((c2 & 0xFFFFFF80) == 0) {
            if (c2 >= 97) {
                return c2 <= 122;
            }
            if (c2 >= 65) {
                if (c2 <= 90) {
                    return true;
                }
                return c2 == 95;
            }
            if (c2 >= 48) {
                return c2 <= 57;
            }
            return c2 == 45 || c2 == 46;
        }
        if ((c2 & 0xFFFFE000) == 0) {
            return XMLName.isNCNameStartChar(c2) || c2 == 183 || 768 <= c2 && c2 <= 879;
        }
        return XMLName.isNCNameStartChar(c2) || 8255 <= c2 && c2 <= 8256;
    }

    static boolean accept(Object nameObj) {
        String name;
        try {
            name = ScriptRuntime.toString(nameObj);
        }
        catch (EcmaError ee) {
            if ("TypeError".equals(ee.getName())) {
                return false;
            }
            throw ee;
        }
        int length = name.length();
        if (length != 0 && XMLName.isNCNameStartChar(name.charAt(0))) {
            for (int i2 = 1; i2 != length; ++i2) {
                if (XMLName.isNCNameChar(name.charAt(i2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private XMLName() {
    }

    static XMLName formStar() {
        XMLName rv = new XMLName();
        rv.qname = XmlNode.QName.create(null, null);
        return rv;
    }

    @Deprecated
    static XMLName formProperty(XmlNode.Namespace namespace, String localName) {
        if (localName != null && localName.equals("*")) {
            localName = null;
        }
        XMLName rv = new XMLName();
        rv.qname = XmlNode.QName.create(namespace, localName);
        return rv;
    }

    static XMLName formProperty(String uri2, String localName) {
        return XMLName.formProperty(XmlNode.Namespace.create(uri2), localName);
    }

    static XMLName create(String defaultNamespaceUri, String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        int l = name.length();
        if (l != 0) {
            char firstChar = name.charAt(0);
            if (firstChar == '*') {
                if (l == 1) {
                    return XMLName.formStar();
                }
            } else if (firstChar == '@') {
                XMLName xmlName = XMLName.formProperty("", name.substring(1));
                xmlName.setAttributeName();
                return xmlName;
            }
        }
        return XMLName.formProperty(defaultNamespaceUri, name);
    }

    static XMLName create(XmlNode.QName qname, boolean attribute, boolean descendants) {
        XMLName rv = new XMLName();
        rv.qname = qname;
        rv.isAttributeName = attribute;
        rv.isDescendants = descendants;
        return rv;
    }

    @Deprecated
    static XMLName create(XmlNode.QName qname) {
        return XMLName.create(qname, false, false);
    }

    void initXMLObject(XMLObjectImpl xmlObject) {
        if (xmlObject == null) {
            throw new IllegalArgumentException();
        }
        if (this.xmlObject != null) {
            throw new IllegalStateException();
        }
        this.xmlObject = xmlObject;
    }

    String uri() {
        if (this.qname.getNamespace() == null) {
            return null;
        }
        return this.qname.getNamespace().getUri();
    }

    String localName() {
        if (this.qname.getLocalName() == null) {
            return "*";
        }
        return this.qname.getLocalName();
    }

    private void addDescendantChildren(XMLList list, XML target) {
        XMLName xmlName = this;
        if (target.isElement()) {
            XML[] children2 = target.getChildren();
            for (int i2 = 0; i2 < children2.length; ++i2) {
                if (xmlName.matches(children2[i2])) {
                    list.addToList(children2[i2]);
                }
                this.addDescendantChildren(list, children2[i2]);
            }
        }
    }

    void addMatchingAttributes(XMLList list, XML target) {
        XMLName name = this;
        if (target.isElement()) {
            XML[] attributes2 = target.getAttributes();
            for (int i2 = 0; i2 < attributes2.length; ++i2) {
                if (!name.matches(attributes2[i2])) continue;
                list.addToList(attributes2[i2]);
            }
        }
    }

    private void addDescendantAttributes(XMLList list, XML target) {
        if (target.isElement()) {
            this.addMatchingAttributes(list, target);
            XML[] children2 = target.getChildren();
            for (int i2 = 0; i2 < children2.length; ++i2) {
                this.addDescendantAttributes(list, children2[i2]);
            }
        }
    }

    XMLList matchDescendantAttributes(XMLList rv, XML target) {
        rv.setTargets(target, null);
        this.addDescendantAttributes(rv, target);
        return rv;
    }

    XMLList matchDescendantChildren(XMLList rv, XML target) {
        rv.setTargets(target, null);
        this.addDescendantChildren(rv, target);
        return rv;
    }

    void addDescendants(XMLList rv, XML target) {
        XMLName xmlName = this;
        if (xmlName.isAttributeName()) {
            this.matchDescendantAttributes(rv, target);
        } else {
            this.matchDescendantChildren(rv, target);
        }
    }

    private void addAttributes(XMLList rv, XML target) {
        this.addMatchingAttributes(rv, target);
    }

    void addMatches(XMLList rv, XML target) {
        if (this.isDescendants()) {
            this.addDescendants(rv, target);
        } else if (this.isAttributeName()) {
            this.addAttributes(rv, target);
        } else {
            XML[] children2 = target.getChildren();
            if (children2 != null) {
                for (int i2 = 0; i2 < children2.length; ++i2) {
                    if (!this.matches(children2[i2])) continue;
                    rv.addToList(children2[i2]);
                }
            }
            rv.setTargets(target, this.toQname());
        }
    }

    XMLList getMyValueOn(XML target) {
        XMLList rv = target.newXMLList();
        this.addMatches(rv, target);
        return rv;
    }

    void setMyValueOn(XML target, Object value2) {
        if (value2 == null) {
            value2 = "null";
        } else if (value2 instanceof Undefined) {
            value2 = "undefined";
        }
        XMLName xmlName = this;
        if (xmlName.isAttributeName()) {
            target.setAttribute(xmlName, value2);
        } else if (xmlName.uri() == null && xmlName.localName().equals("*")) {
            target.setChildren(value2);
        } else {
            XMLList matches2;
            XMLObjectImpl xmlValue = null;
            if (value2 instanceof XMLObjectImpl) {
                xmlValue = (XMLObjectImpl)value2;
                if (xmlValue instanceof XML && ((XML)xmlValue).isAttribute()) {
                    xmlValue = target.makeXmlFromString(xmlName, xmlValue.toString());
                }
                if (xmlValue instanceof XMLList) {
                    for (int i2 = 0; i2 < xmlValue.length(); ++i2) {
                        XML xml = ((XMLList)xmlValue).item(i2);
                        if (!xml.isAttribute()) continue;
                        ((XMLList)xmlValue).replace(i2, target.makeXmlFromString(xmlName, xml.toString()));
                    }
                }
            } else {
                xmlValue = target.makeXmlFromString(xmlName, ScriptRuntime.toString(value2));
            }
            if ((matches2 = target.getPropertyList(xmlName)).length() == 0) {
                target.appendChild(xmlValue);
            } else {
                for (int i3 = 1; i3 < matches2.length(); ++i3) {
                    target.removeChild(matches2.item(i3).childIndex());
                }
                XML firstMatch = matches2.item(0);
                target.replace(firstMatch.childIndex(), (Object)xmlValue);
            }
        }
    }

    @Override
    public boolean has(Context cx) {
        if (this.xmlObject == null) {
            return false;
        }
        return this.xmlObject.hasXMLProperty(this);
    }

    @Override
    public Object get(Context cx) {
        if (this.xmlObject == null) {
            throw ScriptRuntime.undefReadError(Undefined.instance, this.toString());
        }
        return this.xmlObject.getXMLProperty(this);
    }

    @Override
    public Object set(Context cx, Object value2) {
        if (this.xmlObject == null) {
            throw ScriptRuntime.undefWriteError(Undefined.instance, this.toString(), value2);
        }
        if (this.isDescendants) {
            throw Kit.codeBug();
        }
        this.xmlObject.putXMLProperty(this, value2);
        return value2;
    }

    @Override
    public boolean delete(Context cx) {
        if (this.xmlObject == null) {
            return true;
        }
        this.xmlObject.deleteXMLProperty(this);
        return !this.xmlObject.hasXMLProperty(this);
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        if (this.isDescendants) {
            buff.append("..");
        }
        if (this.isAttributeName) {
            buff.append('@');
        }
        if (this.uri() == null) {
            buff.append('*');
            if (this.localName().equals("*")) {
                return buff.toString();
            }
        } else {
            buff.append('\"').append(this.uri()).append('\"');
        }
        buff.append(':').append(this.localName());
        return buff.toString();
    }

    final XmlNode.QName toQname() {
        return this.qname;
    }

    final boolean matchesLocalName(String localName) {
        return this.localName().equals("*") || this.localName().equals(localName);
    }

    final boolean matchesElement(XmlNode.QName qname) {
        return !(this.uri() != null && !this.uri().equals(qname.getNamespace().getUri()) || !this.localName().equals("*") && !this.localName().equals(qname.getLocalName()));
    }

    final boolean matches(XML node) {
        XmlNode.QName qname = node.getNodeQname();
        String nodeUri = null;
        if (qname.getNamespace() != null) {
            nodeUri = qname.getNamespace().getUri();
        }
        if (this.isAttributeName) {
            if (node.isAttribute()) {
                return !(this.uri() != null && !this.uri().equals(nodeUri) || !this.localName().equals("*") && !this.localName().equals(qname.getLocalName()));
            }
            return false;
        }
        if (this.uri() == null || node.isElement() && this.uri().equals(nodeUri)) {
            if (this.localName().equals("*")) {
                return true;
            }
            if (node.isElement() && this.localName().equals(qname.getLocalName())) {
                return true;
            }
        }
        return false;
    }

    boolean isAttributeName() {
        return this.isAttributeName;
    }

    void setAttributeName() {
        this.isAttributeName = true;
    }

    boolean isDescendants() {
        return this.isDescendants;
    }

    @Deprecated
    void setIsDescendants() {
        this.isDescendants = true;
    }
}

