/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.xmlimpl.XMLObjectImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XmlProcessor
implements Serializable {
    private static final long serialVersionUID = 6903514433204808713L;
    private boolean ignoreComments;
    private boolean ignoreProcessingInstructions;
    private boolean ignoreWhitespace;
    private boolean prettyPrint;
    private int prettyIndent;
    private transient DocumentBuilderFactory dom;
    private transient TransformerFactory xform;
    private transient LinkedBlockingDeque<DocumentBuilder> documentBuilderPool;
    private RhinoSAXErrorHandler errorHandler = new RhinoSAXErrorHandler();

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.dom = DocumentBuilderFactory.newInstance();
        this.dom.setNamespaceAware(true);
        this.dom.setIgnoringComments(false);
        this.xform = TransformerFactory.newInstance();
        int poolSize = Runtime.getRuntime().availableProcessors() * 2;
        this.documentBuilderPool = new LinkedBlockingDeque(poolSize);
    }

    XmlProcessor() {
        this.setDefault();
        this.dom = DocumentBuilderFactory.newInstance();
        this.dom.setNamespaceAware(true);
        this.dom.setIgnoringComments(false);
        this.xform = TransformerFactory.newInstance();
        int poolSize = Runtime.getRuntime().availableProcessors() * 2;
        this.documentBuilderPool = new LinkedBlockingDeque(poolSize);
    }

    final void setDefault() {
        this.setIgnoreComments(true);
        this.setIgnoreProcessingInstructions(true);
        this.setIgnoreWhitespace(true);
        this.setPrettyPrinting(true);
        this.setPrettyIndent(2);
    }

    final void setIgnoreComments(boolean b2) {
        this.ignoreComments = b2;
    }

    final void setIgnoreWhitespace(boolean b2) {
        this.ignoreWhitespace = b2;
    }

    final void setIgnoreProcessingInstructions(boolean b2) {
        this.ignoreProcessingInstructions = b2;
    }

    final void setPrettyPrinting(boolean b2) {
        this.prettyPrint = b2;
    }

    final void setPrettyIndent(int i2) {
        this.prettyIndent = i2;
    }

    final boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    final boolean isIgnoreProcessingInstructions() {
        return this.ignoreProcessingInstructions;
    }

    final boolean isIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    final boolean isPrettyPrinting() {
        return this.prettyPrint;
    }

    final int getPrettyIndent() {
        return this.prettyIndent;
    }

    private String toXmlNewlines(String rv) {
        StringBuilder nl = new StringBuilder();
        for (int i2 = 0; i2 < rv.length(); ++i2) {
            if (rv.charAt(i2) == '\r') {
                if (rv.charAt(i2 + 1) == '\n') continue;
                nl.append('\n');
                continue;
            }
            nl.append(rv.charAt(i2));
        }
        return nl.toString();
    }

    private DocumentBuilderFactory getDomFactory() {
        return this.dom;
    }

    private DocumentBuilder getDocumentBuilderFromPool() throws ParserConfigurationException {
        DocumentBuilder builder = this.documentBuilderPool.pollFirst();
        if (builder == null) {
            builder = this.getDomFactory().newDocumentBuilder();
        }
        builder.setErrorHandler(this.errorHandler);
        return builder;
    }

    private void returnDocumentBuilderToPool(DocumentBuilder db) {
        try {
            db.reset();
            this.documentBuilderPool.offerFirst(db);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private void addProcessingInstructionsTo(List<Node> list, Node node) {
        if (node instanceof ProcessingInstruction) {
            list.add(node);
        }
        if (node.getChildNodes() != null) {
            for (int i2 = 0; i2 < node.getChildNodes().getLength(); ++i2) {
                this.addProcessingInstructionsTo(list, node.getChildNodes().item(i2));
            }
        }
    }

    private void addCommentsTo(List<Node> list, Node node) {
        if (node instanceof Comment) {
            list.add(node);
        }
        if (node.getChildNodes() != null) {
            for (int i2 = 0; i2 < node.getChildNodes().getLength(); ++i2) {
                this.addProcessingInstructionsTo(list, node.getChildNodes().item(i2));
            }
        }
    }

    private void addTextNodesToRemoveAndTrim(List<Node> toRemove, Node node) {
        if (node instanceof Text) {
            Text text = (Text)node;
            boolean BUG_369394_IS_VALID = false;
            if (!BUG_369394_IS_VALID) {
                text.setData(text.getData().trim());
            } else if (text.getData().trim().length() == 0) {
                text.setData("");
            }
            if (text.getData().length() == 0) {
                toRemove.add(node);
            }
        }
        if (node.getChildNodes() != null) {
            for (int i2 = 0; i2 < node.getChildNodes().getLength(); ++i2) {
                this.addTextNodesToRemoveAndTrim(toRemove, node.getChildNodes().item(i2));
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Node toXml(String defaultNamespaceUri, String xml) throws SAXException {
        Text text;
        Node node;
        NodeList rv;
        Document document;
        DocumentBuilder builder = null;
        try {
            ArrayList<Node> list;
            String syntheticXml = "<parent xmlns=\"" + defaultNamespaceUri + "\">" + xml + "</parent>";
            builder = this.getDocumentBuilderFromPool();
            document = builder.parse(new InputSource(new StringReader(syntheticXml)));
            if (this.ignoreProcessingInstructions) {
                list = new ArrayList<Node>();
                this.addProcessingInstructionsTo(list, document);
                for (Node node2 : list) {
                    node2.getParentNode().removeChild(node2);
                }
            }
            if (this.ignoreComments) {
                list = new ArrayList();
                this.addCommentsTo(list, document);
                for (Node node2 : list) {
                    node2.getParentNode().removeChild(node2);
                }
            }
            if (this.ignoreWhitespace) {
                list = new ArrayList();
                this.addTextNodesToRemoveAndTrim(list, document);
                for (Node node2 : list) {
                    node2.getParentNode().removeChild(node2);
                }
            }
            if ((rv = document.getDocumentElement().getChildNodes()).getLength() > 1) {
                throw ScriptRuntime.constructError("SyntaxError", "XML objects may contain at most one node.");
            }
            if (rv.getLength() == 0) {
                text = node = document.createTextNode("");
                if (builder != null) {
                    this.returnDocumentBuilderToPool(builder);
                }
                return text;
            }
        }
        catch (IOException e2) {
            try {
                throw new RuntimeException("Unreachable.");
                catch (ParserConfigurationException e3) {
                    throw new RuntimeException(e3);
                }
            }
            catch (Throwable throwable) {
                if (builder != null) {
                    this.returnDocumentBuilderToPool(builder);
                }
                throw throwable;
            }
        }
        {
            node = rv.item(0);
            document.getDocumentElement().removeChild(node);
            text = node;
            if (builder != null) {
                this.returnDocumentBuilderToPool(builder);
            }
            return text;
        }
    }

    Document newDocument() {
        DocumentBuilder builder = null;
        try {
            builder = this.getDocumentBuilderFromPool();
            Document document = builder.newDocument();
            return document;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (builder != null) {
                this.returnDocumentBuilderToPool(builder);
            }
        }
    }

    private String toString(Node node) {
        DOMSource source2 = new DOMSource(node);
        StringWriter writer = new StringWriter();
        StreamResult result2 = new StreamResult(writer);
        try {
            Transformer transformer = this.xform.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(source2, result2);
        }
        catch (TransformerConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
        return this.toXmlNewlines(writer.toString());
    }

    String escapeAttributeValue(Object value2) {
        String text = ScriptRuntime.toString(value2);
        if (text.length() == 0) {
            return "";
        }
        Document dom = this.newDocument();
        Element e2 = dom.createElement("a");
        e2.setAttribute("b", text);
        String elementText = this.toString(e2);
        int begin = elementText.indexOf(34);
        int end2 = elementText.lastIndexOf(34);
        return elementText.substring(begin + 1, end2);
    }

    String escapeTextValue(Object value2) {
        if (value2 instanceof XMLObjectImpl) {
            return ((XMLObjectImpl)value2).toXMLString();
        }
        String text = ScriptRuntime.toString(value2);
        if (text.length() == 0) {
            return text;
        }
        Document dom = this.newDocument();
        Element e2 = dom.createElement("a");
        e2.setTextContent(text);
        String elementText = this.toString(e2);
        int begin = elementText.indexOf(62) + 1;
        int end2 = elementText.lastIndexOf(60);
        return begin < end2 ? elementText.substring(begin, end2) : "";
    }

    private String escapeElementValue(String s2) {
        return this.escapeTextValue(s2);
    }

    private String elementToXmlString(Element element) {
        Element copy2 = (Element)element.cloneNode(true);
        if (this.prettyPrint) {
            this.beautifyElement(copy2, 0);
        }
        return this.toString(copy2);
    }

    final String ecmaToXmlString(Node node) {
        StringBuilder s2 = new StringBuilder();
        int indentLevel = 0;
        if (this.prettyPrint) {
            for (int i2 = 0; i2 < indentLevel; ++i2) {
                s2.append(' ');
            }
        }
        if (node instanceof Text) {
            String data2 = ((Text)node).getData();
            String v = this.prettyPrint ? data2.trim() : data2;
            s2.append(this.escapeElementValue(v));
            return s2.toString();
        }
        if (node instanceof Attr) {
            String value2 = ((Attr)node).getValue();
            s2.append(this.escapeAttributeValue(value2));
            return s2.toString();
        }
        if (node instanceof Comment) {
            s2.append("<!--" + ((Comment)node).getNodeValue() + "-->");
            return s2.toString();
        }
        if (node instanceof ProcessingInstruction) {
            ProcessingInstruction pi = (ProcessingInstruction)node;
            s2.append("<?" + pi.getTarget() + " " + pi.getData() + "?>");
            return s2.toString();
        }
        s2.append(this.elementToXmlString((Element)node));
        return s2.toString();
    }

    private void beautifyElement(Element e2, int indent) {
        int i2;
        StringBuilder s2 = new StringBuilder();
        s2.append('\n');
        for (int i3 = 0; i3 < indent; ++i3) {
            s2.append(' ');
        }
        String afterContent = s2.toString();
        for (int i4 = 0; i4 < this.prettyIndent; ++i4) {
            s2.append(' ');
        }
        String beforeContent = s2.toString();
        ArrayList<Node> toIndent = new ArrayList<Node>();
        boolean indentChildren = false;
        for (i2 = 0; i2 < e2.getChildNodes().getLength(); ++i2) {
            if (i2 == 1) {
                indentChildren = true;
            }
            if (e2.getChildNodes().item(i2) instanceof Text) {
                toIndent.add(e2.getChildNodes().item(i2));
                continue;
            }
            indentChildren = true;
            toIndent.add(e2.getChildNodes().item(i2));
        }
        if (indentChildren) {
            for (i2 = 0; i2 < toIndent.size(); ++i2) {
                e2.insertBefore(e2.getOwnerDocument().createTextNode(beforeContent), (Node)toIndent.get(i2));
            }
        }
        NodeList nodes2 = e2.getChildNodes();
        ArrayList<Element> list = new ArrayList<Element>();
        for (int i5 = 0; i5 < nodes2.getLength(); ++i5) {
            if (!(nodes2.item(i5) instanceof Element)) continue;
            list.add((Element)nodes2.item(i5));
        }
        for (Element elem : list) {
            this.beautifyElement(elem, indent + this.prettyIndent);
        }
        if (indentChildren) {
            e2.appendChild(e2.getOwnerDocument().createTextNode(afterContent));
        }
    }

    private static class RhinoSAXErrorHandler
    implements ErrorHandler,
    Serializable {
        private static final long serialVersionUID = 6918417235413084055L;

        private RhinoSAXErrorHandler() {
        }

        private void throwError(SAXParseException e2) {
            throw ScriptRuntime.constructError("TypeError", e2.getMessage(), e2.getLineNumber() - 1);
        }

        @Override
        public void error(SAXParseException e2) {
            this.throwError(e2);
        }

        @Override
        public void fatalError(SAXParseException e2) {
            this.throwError(e2);
        }

        @Override
        public void warning(SAXParseException e2) {
            Context.reportWarning(e2.getMessage());
        }
    }
}

