/*
 * Decompiled with CFR 0.152.
 */
package org.reflections;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javassist.bytecode.ClassFile;
import javax.annotation.Nullable;
import org.reflections.Configuration;
import org.reflections.ReflectionUtils;
import org.reflections.ReflectionsException;
import org.reflections.Store;
import org.reflections.scanners.MemberUsageScanner;
import org.reflections.scanners.MethodParameterNamesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.serializers.Serializer;
import org.reflections.serializers.XmlSerializer;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.reflections.util.NameHelper;
import org.reflections.util.QueryFunction;
import org.reflections.vfs.Vfs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reflections
implements NameHelper {
    public static final Logger log = LoggerFactory.getLogger(Reflections.class);
    protected final transient Configuration configuration;
    protected final Store store;

    public Reflections(Configuration configuration) {
        this.configuration = configuration;
        Map<String, Map<String, Set<String>>> storeMap = this.scan();
        if (configuration.shouldExpandSuperTypes()) {
            this.expandSuperTypes(storeMap.get(Scanners.SubTypes.index()), storeMap.get(Scanners.TypesAnnotated.index()));
        }
        this.store = new Store(storeMap);
    }

    public Reflections(Store store2) {
        this.configuration = new ConfigurationBuilder();
        this.store = store2;
    }

    public Reflections(String prefix2, Scanner ... scanners) {
        this(new Object[]{prefix2, scanners});
    }

    public Reflections(Object ... params) {
        this(ConfigurationBuilder.build(params));
    }

    protected Reflections() {
        this.configuration = new ConfigurationBuilder();
        this.store = new Store((Map<String, Map<String, Set<String>>>)new HashMap<String, Map<String, Set<String>>>());
    }

    protected Map<String, Map<String, Set<String>>> scan() {
        long start2 = System.currentTimeMillis();
        Map<String, Set> collect2 = this.configuration.getScanners().stream().map(Scanner::index).distinct().collect(Collectors.toMap(s2 -> s2, s2 -> Collections.synchronizedSet(new HashSet())));
        Set<URL> urls2 = this.configuration.getUrls();
        (this.configuration.isParallel() ? (Stream)urls2.stream().parallel() : urls2.stream()).forEach(url2 -> {
            try (Vfs.Dir dir = null;){
                dir = Vfs.fromURL(url2);
                for (Vfs.File file2 : dir.getFiles()) {
                    if (!this.doFilter(file2, this.configuration.getInputsFilter())) continue;
                    ClassFile classFile = null;
                    for (Scanner scanner : this.configuration.getScanners()) {
                        try {
                            if (!this.doFilter(file2, scanner::acceptsInput)) continue;
                            List<Map.Entry<String, String>> entries2 = scanner.scan(file2);
                            if (entries2 == null) {
                                if (classFile == null) {
                                    classFile = this.getClassFile(file2);
                                }
                                entries2 = scanner.scan(classFile);
                            }
                            if (entries2 == null) continue;
                            ((Set)collect2.get(scanner.index())).addAll(entries2);
                        }
                        catch (Exception e2) {
                            if (log == null) continue;
                            log.trace("could not scan file {} with scanner {}", file2.getRelativePath(), scanner.getClass().getSimpleName(), e2);
                        }
                    }
                }
            }
        });
        Map<String, Map<String, Set<String>>> storeMap = collect2.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Set)entry.getValue()).stream().filter(e2 -> e2.getKey() != null).collect(Collectors.groupingBy(Map.Entry::getKey, HashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toSet())))));
        if (log != null) {
            int keys2 = 0;
            int values2 = 0;
            for (Map<String, Set<String>> map2 : storeMap.values()) {
                keys2 += map2.size();
                values2 = (int)((long)values2 + map2.values().stream().mapToLong(Set::size).sum());
            }
            log.info(String.format("Reflections took %d ms to scan %d urls, producing %d keys and %d values", System.currentTimeMillis() - start2, urls2.size(), keys2, values2));
        }
        return storeMap;
    }

    private boolean doFilter(Vfs.File file2, @Nullable Predicate<String> predicate) {
        String path2 = file2.getRelativePath();
        String fqn = path2.replace('/', '.');
        return predicate == null || predicate.test(path2) || predicate.test(fqn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClassFile getClassFile(Vfs.File file2) {
        try (DataInputStream dis = new DataInputStream(new BufferedInputStream(file2.openInputStream()));){
            ClassFile classFile = new ClassFile(dis);
            return classFile;
        }
        catch (Exception e2) {
            throw new ReflectionsException("could not create class object from file " + file2.getRelativePath(), e2);
        }
    }

    public static Reflections collect() {
        return Reflections.collect("META-INF/reflections/", new FilterBuilder().includePattern(".*-reflections\\.xml"));
    }

    public static Reflections collect(String packagePrefix, Predicate<String> resourceNameFilter) {
        return Reflections.collect(packagePrefix, resourceNameFilter, new XmlSerializer());
    }

    public static Reflections collect(String packagePrefix, Predicate<String> resourceNameFilter, Serializer serializer2) {
        Collection<URL> urls2 = ClasspathHelper.forPackage(packagePrefix, new ClassLoader[0]);
        Iterable<Vfs.File> files2 = Vfs.findFiles(urls2, packagePrefix, resourceNameFilter);
        Reflections reflections = new Reflections();
        StreamSupport.stream(files2.spliterator(), false).forEach(file2 -> {
            try (InputStream inputStream2 = file2.openInputStream();){
                reflections.collect(inputStream2, serializer2);
            }
            catch (IOException e2) {
                throw new ReflectionsException("could not merge " + file2, e2);
            }
        });
        return reflections;
    }

    public Reflections collect(InputStream inputStream2, Serializer serializer2) {
        return this.merge(serializer2.read(inputStream2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Reflections collect(File file2, Serializer serializer2) {
        try (FileInputStream inputStream2 = new FileInputStream(file2);){
            Reflections reflections = this.collect(inputStream2, serializer2);
            return reflections;
        }
        catch (IOException e2) {
            throw new ReflectionsException("could not obtain input stream from file " + file2, e2);
        }
    }

    public Reflections merge(Reflections reflections) {
        reflections.store.forEach((index, map2) -> this.store.merge(index, map2, (m1, m22) -> {
            m22.forEach((k2, v) -> m1.merge(k2, v, (s1, s2) -> {
                s1.addAll(s2);
                return s1;
            }));
            return m1;
        }));
        return this;
    }

    public void expandSuperTypes(Map<String, Set<String>> subTypesStore, Map<String, Set<String>> typesAnnotatedStore) {
        if (subTypesStore == null || subTypesStore.isEmpty()) {
            return;
        }
        LinkedHashSet<String> keys2 = new LinkedHashSet<String>(subTypesStore.keySet());
        keys2.removeAll(subTypesStore.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
        keys2.remove("java.lang.Object");
        for (String key2 : keys2) {
            Class<?> type2 = this.forClass(key2, this.loaders());
            if (type2 == null) continue;
            this.expandSupertypes(subTypesStore, typesAnnotatedStore, key2, type2);
        }
    }

    private void expandSupertypes(Map<String, Set<String>> subTypesStore, Map<String, Set<String>> typesAnnotatedStore, String key2, Class<?> type2) {
        Set<Annotation> typeAnnotations = ReflectionUtils.getAnnotations(type2, new Predicate[0]);
        if (typesAnnotatedStore != null && !typeAnnotations.isEmpty()) {
            String typeName2 = type2.getName();
            for (Annotation typeAnnotation : typeAnnotations) {
                String annotationName = typeAnnotation.annotationType().getName();
                typesAnnotatedStore.computeIfAbsent(annotationName, s2 -> new HashSet()).add(typeName2);
            }
        }
        for (Class<?> supertype : ReflectionUtils.getSuperTypes(type2)) {
            String supertypeName = supertype.getName();
            if (subTypesStore.containsKey(supertypeName)) {
                subTypesStore.get(supertypeName).add(key2);
                continue;
            }
            subTypesStore.computeIfAbsent(supertypeName, s2 -> new HashSet()).add(key2);
            this.expandSupertypes(subTypesStore, typesAnnotatedStore, supertypeName, supertype);
        }
    }

    public <T> Set<T> get(QueryFunction<Store, T> query2) {
        return query2.apply((Object)this.store);
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type2) {
        return this.get(Scanners.SubTypes.of(type2).as(Class.class, this.loaders()));
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.get(Scanners.SubTypes.of(Scanners.TypesAnnotated.with(annotation)).asClass(this.loaders()));
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation, boolean honorInherited) {
        if (!honorInherited) {
            return this.getTypesAnnotatedWith(annotation);
        }
        if (annotation.isAnnotationPresent(Inherited.class)) {
            return this.get(Scanners.TypesAnnotated.get(annotation).add(Scanners.SubTypes.of(Scanners.TypesAnnotated.get(annotation).filter(c2 -> !this.forClass((String)c2, this.loaders()).isInterface()))).asClass(this.loaders()));
        }
        return this.get(Scanners.TypesAnnotated.get(annotation).asClass(this.loaders()));
    }

    public Set<Class<?>> getTypesAnnotatedWith(Annotation annotation) {
        return this.get(Scanners.SubTypes.of(Scanners.TypesAnnotated.of(Scanners.TypesAnnotated.get(annotation.annotationType()).filter(c2 -> ReflectionUtils.withAnnotation(annotation).test(this.forClass((String)c2, this.loaders()))))).asClass(this.loaders()));
    }

    public Set<Class<?>> getTypesAnnotatedWith(Annotation annotation, boolean honorInherited) {
        if (!honorInherited) {
            return this.getTypesAnnotatedWith(annotation);
        }
        Class<? extends Annotation> type2 = annotation.annotationType();
        if (type2.isAnnotationPresent(Inherited.class)) {
            return this.get(Scanners.TypesAnnotated.with(type2).asClass(this.loaders()).filter(ReflectionUtils.withAnnotation(annotation)).add(Scanners.SubTypes.of(Scanners.TypesAnnotated.with(type2).asClass(this.loaders()).filter(c2 -> !c2.isInterface()))));
        }
        return this.get(Scanners.TypesAnnotated.with(type2).asClass(this.loaders()).filter(ReflectionUtils.withAnnotation(annotation)));
    }

    public Set<Method> getMethodsAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.get(Scanners.MethodsAnnotated.with(annotation).as(Method.class, this.loaders()));
    }

    public Set<Method> getMethodsAnnotatedWith(Annotation annotation) {
        return this.get(Scanners.MethodsAnnotated.with(annotation.annotationType()).as(Method.class, this.loaders()).filter(ReflectionUtils.withAnnotation(annotation)));
    }

    public Set<Method> getMethodsWithSignature(Class<?> ... types) {
        return this.get(Scanners.MethodsSignature.with(types).as(Method.class, this.loaders()));
    }

    public Set<Method> getMethodsWithParameter(AnnotatedElement type2) {
        return this.get(Scanners.MethodsParameter.with(type2).as(Method.class, this.loaders()));
    }

    public Set<Method> getMethodsReturn(Class<?> type2) {
        return this.get(Scanners.MethodsReturn.of(type2).as(Method.class, this.loaders()));
    }

    public Set<Constructor> getConstructorsAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.get(Scanners.ConstructorsAnnotated.with(annotation).as(Constructor.class, this.loaders()));
    }

    public Set<Constructor> getConstructorsAnnotatedWith(Annotation annotation) {
        return this.get(Scanners.ConstructorsAnnotated.with(annotation.annotationType()).as(Constructor.class, this.loaders()).filter(ReflectionUtils.withAnyParameterAnnotation(annotation)));
    }

    public Set<Constructor> getConstructorsWithSignature(Class<?> ... types) {
        return this.get(Scanners.ConstructorsSignature.with(types).as(Constructor.class, this.loaders()));
    }

    public Set<Constructor> getConstructorsWithParameter(AnnotatedElement type2) {
        return this.get(Scanners.ConstructorsParameter.of(type2).as(Constructor.class, this.loaders()));
    }

    public Set<Field> getFieldsAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.get(Scanners.FieldsAnnotated.with(annotation).as(Field.class, this.loaders()));
    }

    public Set<Field> getFieldsAnnotatedWith(Annotation annotation) {
        return this.get(Scanners.FieldsAnnotated.with(annotation.annotationType()).as(Field.class, this.loaders()).filter(ReflectionUtils.withAnnotation(annotation)));
    }

    public Set<String> getResources(String pattern2) {
        return this.get(Scanners.Resources.with(pattern2));
    }

    public Set<String> getResources(Pattern pattern2) {
        return this.getResources(pattern2.pattern());
    }

    public List<String> getMemberParameterNames(Member member) {
        return this.store.getOrDefault(MethodParameterNamesScanner.class.getSimpleName(), Collections.emptyMap()).getOrDefault(this.toName((AnnotatedElement)((Object)member)), Collections.emptySet()).stream().flatMap(s2 -> Stream.of(s2.split(", "))).collect(Collectors.toList());
    }

    public Collection<Member> getMemberUsage(Member member) {
        Set<String> usages = this.store.getOrDefault(MemberUsageScanner.class.getSimpleName(), Collections.emptyMap()).getOrDefault(this.toName((AnnotatedElement)((Object)member)), Collections.emptySet());
        return this.forNames(usages, Member.class, this.loaders());
    }

    @Deprecated
    public Set<String> getAllTypes() {
        return this.getAll(Scanners.SubTypes);
    }

    public Set<String> getAll(Scanner scanner) {
        Map map2 = this.store.getOrDefault(scanner.index(), Collections.emptyMap());
        return Stream.concat(map2.keySet().stream(), map2.values().stream().flatMap(Collection::stream)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Store getStore() {
        return this.store;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public File save(String filename) {
        return this.save(filename, new XmlSerializer());
    }

    public File save(String filename, Serializer serializer2) {
        return serializer2.save(this, filename);
    }

    ClassLoader[] loaders() {
        return this.configuration.getClassLoaders();
    }
}

