/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javassist.bytecode.AccessFlag;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.Descriptor;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;

public class JavassistHelper {
    public static boolean includeInvisibleTag = true;

    public static String fieldName(ClassFile classFile, FieldInfo object) {
        return String.format("%s.%s", classFile.getName(), object.getName());
    }

    public static String methodName(ClassFile classFile, MethodInfo object) {
        return String.format("%s.%s(%s)", classFile.getName(), object.getName(), String.join((CharSequence)", ", JavassistHelper.getParameters(object)));
    }

    public static boolean isPublic(Object object) {
        if (object instanceof ClassFile) {
            return AccessFlag.isPublic(((ClassFile)object).getAccessFlags());
        }
        if (object instanceof FieldInfo) {
            return AccessFlag.isPublic(((FieldInfo)object).getAccessFlags());
        }
        if (object instanceof MethodInfo) {
            return AccessFlag.isPublic(((MethodInfo)object).getAccessFlags());
        }
        return false;
    }

    public static Stream<MethodInfo> getMethods(ClassFile classFile) {
        return classFile.getMethods().stream().filter(MethodInfo::isMethod);
    }

    public static Stream<MethodInfo> getConstructors(ClassFile classFile) {
        return classFile.getMethods().stream().filter(methodInfo -> !methodInfo.isMethod());
    }

    public static List<String> getParameters(MethodInfo method2) {
        ArrayList<String> result2 = new ArrayList<String>();
        String descriptor2 = method2.getDescriptor().substring(1);
        Descriptor.Iterator iterator2 = new Descriptor.Iterator(descriptor2);
        Integer prev = null;
        while (iterator2.hasNext()) {
            int cur = iterator2.next();
            if (prev != null) {
                result2.add(Descriptor.toString(descriptor2.substring(prev, cur)));
            }
            prev = cur;
        }
        return result2;
    }

    public static String getReturnType(MethodInfo method2) {
        String descriptor2 = method2.getDescriptor();
        descriptor2 = descriptor2.substring(descriptor2.lastIndexOf(")") + 1);
        return Descriptor.toString(descriptor2);
    }

    public static List<String> getAnnotations(Function<String, AttributeInfo> function) {
        Function<String, List> names2 = function.andThen(attribute -> attribute != null ? ((AnnotationsAttribute)attribute).getAnnotations() : null).andThen(JavassistHelper::annotationNames);
        ArrayList<String> result2 = new ArrayList<String>(names2.apply("RuntimeVisibleAnnotations"));
        if (includeInvisibleTag) {
            result2.addAll(names2.apply("RuntimeInvisibleAnnotations"));
        }
        return result2;
    }

    public static List<List<String>> getParametersAnnotations(MethodInfo method2) {
        Function<String, List> names2 = ((Function<String, AttributeInfo>)method2::getAttribute).andThen(attribute -> attribute != null ? ((ParameterAnnotationsAttribute)attribute).getAnnotations() : (Annotation[][])null).andThen(aa -> aa != null ? Stream.of(aa).map(JavassistHelper::annotationNames).collect(Collectors.toList()) : Collections.emptyList());
        List visibleAnnotations = names2.apply("RuntimeVisibleParameterAnnotations");
        if (!includeInvisibleTag) {
            return new ArrayList<List<String>>(visibleAnnotations);
        }
        List invisibleAnnotations = names2.apply("RuntimeInvisibleParameterAnnotations");
        if (invisibleAnnotations.isEmpty()) {
            return new ArrayList<List<String>>(visibleAnnotations);
        }
        ArrayList<List<String>> result2 = new ArrayList<List<String>>();
        for (int i2 = 0; i2 < Math.max(visibleAnnotations.size(), invisibleAnnotations.size()); ++i2) {
            ArrayList concat2 = new ArrayList();
            if (i2 < visibleAnnotations.size()) {
                concat2.addAll((Collection)visibleAnnotations.get(i2));
            }
            if (i2 < invisibleAnnotations.size()) {
                concat2.addAll((Collection)invisibleAnnotations.get(i2));
            }
            result2.add(concat2);
        }
        return result2;
    }

    private static List<String> annotationNames(Annotation[] annotations) {
        return annotations != null ? Stream.of(annotations).map(Annotation::getTypeName).collect(Collectors.toList()) : Collections.emptyList();
    }
}

