/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.vfs;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.vfs.Vfs;
import org.reflections.vfs.ZipDir;

public class UrlTypeVFS
implements Vfs.UrlType {
    public static final String[] REPLACE_EXTENSION = new String[]{".ear/", ".jar/", ".war/", ".sar/", ".har/", ".par/"};
    final String VFSZIP = "vfszip";
    final String VFSFILE = "vfsfile";

    @Override
    public boolean matches(URL url2) {
        return "vfszip".equals(url2.getProtocol()) || "vfsfile".equals(url2.getProtocol());
    }

    @Override
    public Vfs.Dir createDir(URL url2) {
        try {
            URL adaptedUrl = this.adaptURL(url2);
            return new ZipDir(new JarFile(adaptedUrl.getFile()));
        }
        catch (Exception e2) {
            try {
                return new ZipDir(new JarFile(url2.getFile()));
            }
            catch (IOException e1) {
                if (Reflections.log != null) {
                    Reflections.log.warn("Could not get URL", e2);
                }
                return null;
            }
        }
    }

    public URL adaptURL(URL url2) throws MalformedURLException {
        if ("vfszip".equals(url2.getProtocol())) {
            return this.replaceZipSeparators(url2.getPath(), file2 -> file2.exists() && file2.isFile());
        }
        if ("vfsfile".equals(url2.getProtocol())) {
            return new URL(url2.toString().replace("vfsfile", "file"));
        }
        return url2;
    }

    URL replaceZipSeparators(String path2, Predicate<File> acceptFile) throws MalformedURLException {
        int pos = 0;
        while (pos != -1) {
            File file2;
            if ((pos = this.findFirstMatchOfDeployableExtention(path2, pos)) <= 0 || !acceptFile.test(file2 = new File(path2.substring(0, pos - 1)))) continue;
            return this.replaceZipSeparatorStartingFrom(path2, pos);
        }
        throw new ReflectionsException("Unable to identify the real zip file in path '" + path2 + "'.");
    }

    int findFirstMatchOfDeployableExtention(String path2, int pos) {
        Pattern p = Pattern.compile("\\.[ejprw]ar/");
        Matcher m4 = p.matcher(path2);
        if (m4.find(pos)) {
            return m4.end();
        }
        return -1;
    }

    URL replaceZipSeparatorStartingFrom(String path2, int pos) throws MalformedURLException {
        String zipFile = path2.substring(0, pos - 1);
        String zipPath = path2.substring(pos);
        int numSubs = 1;
        for (String ext : REPLACE_EXTENSION) {
            while (zipPath.contains(ext)) {
                zipPath = zipPath.replace(ext, ext.substring(0, 4) + "!");
                ++numSubs;
            }
        }
        String prefix2 = "";
        for (int i2 = 0; i2 < numSubs; ++i2) {
            prefix2 = prefix2 + "zip:";
        }
        if (zipPath.trim().length() == 0) {
            return new URL(prefix2 + "/" + zipFile);
        }
        return new URL(prefix2 + "/" + zipFile + "!" + zipPath);
    }
}

