/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.util.ClasspathHelper;
import org.reflections.vfs.JarInputDir;
import org.reflections.vfs.JbossDir;
import org.reflections.vfs.SystemDir;
import org.reflections.vfs.UrlTypeVFS;
import org.reflections.vfs.ZipDir;

public abstract class Vfs {
    private static List<UrlType> defaultUrlTypes = new ArrayList<DefaultUrlTypes>(Arrays.asList(DefaultUrlTypes.values()));

    public static List<UrlType> getDefaultUrlTypes() {
        return defaultUrlTypes;
    }

    public static void setDefaultURLTypes(List<UrlType> urlTypes) {
        defaultUrlTypes = urlTypes;
    }

    public static void addDefaultURLTypes(UrlType urlType) {
        defaultUrlTypes.add(0, urlType);
    }

    public static Dir fromURL(URL url2) {
        return Vfs.fromURL(url2, defaultUrlTypes);
    }

    public static Dir fromURL(URL url2, List<UrlType> urlTypes) {
        for (UrlType type2 : urlTypes) {
            try {
                Dir dir;
                if (!type2.matches(url2) || (dir = type2.createDir(url2)) == null) continue;
                return dir;
            }
            catch (Throwable e2) {
                if (Reflections.log == null) continue;
                Reflections.log.warn("could not create Dir using " + type2 + " from url " + url2.toExternalForm() + ". skipping.", e2);
            }
        }
        throw new ReflectionsException("could not create Vfs.Dir from url, no matching UrlType was found [" + url2.toExternalForm() + "]\neither use fromURL(final URL url, final List<UrlType> urlTypes) or use the static setDefaultURLTypes(final List<UrlType> urlTypes) or addDefaultURLTypes(UrlType urlType) with your specialized UrlType.");
    }

    public static Dir fromURL(URL url2, UrlType ... urlTypes) {
        return Vfs.fromURL(url2, Arrays.asList(urlTypes));
    }

    public static Iterable<File> findFiles(Collection<URL> inUrls, String packagePrefix, Predicate<String> nameFilter) {
        Predicate<File> fileNamePredicate = file2 -> {
            String path2 = file2.getRelativePath();
            if (path2.startsWith(packagePrefix)) {
                String filename = path2.substring(path2.indexOf(packagePrefix) + packagePrefix.length());
                return !filename.isEmpty() && nameFilter.test(filename.substring(1));
            }
            return false;
        };
        return Vfs.findFiles(inUrls, fileNamePredicate);
    }

    public static Iterable<File> findFiles(Collection<URL> urls2, Predicate<File> filePredicate) {
        return () -> urls2.stream().flatMap(url2 -> {
            try {
                return StreamSupport.stream(Vfs.fromURL(url2).getFiles().spliterator(), false);
            }
            catch (Throwable e2) {
                if (Reflections.log != null) {
                    Reflections.log.error("could not findFiles for url. continuing. [" + url2 + "]", e2);
                }
                return Stream.of(new File[0]);
            }
        }).filter(filePredicate).iterator();
    }

    public static java.io.File getFile(URL url2) {
        java.io.File file2;
        String path2;
        try {
            path2 = url2.toURI().getSchemeSpecificPart();
            file2 = new java.io.File(path2);
            if (file2.exists()) {
                return file2;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        try {
            path2 = URLDecoder.decode(url2.getPath(), "UTF-8");
            if (path2.contains(".jar!")) {
                path2 = path2.substring(0, path2.lastIndexOf(".jar!") + ".jar".length());
            }
            if ((file2 = new java.io.File(path2)).exists()) {
                return file2;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            path2 = url2.toExternalForm();
            if (path2.startsWith("jar:")) {
                path2 = path2.substring("jar:".length());
            }
            if (path2.startsWith("wsjar:")) {
                path2 = path2.substring("wsjar:".length());
            }
            if (path2.startsWith("file:")) {
                path2 = path2.substring("file:".length());
            }
            if (path2.contains(".jar!")) {
                path2 = path2.substring(0, path2.indexOf(".jar!") + ".jar".length());
            }
            if (path2.contains(".war!")) {
                path2 = path2.substring(0, path2.indexOf(".war!") + ".war".length());
            }
            if ((file2 = new java.io.File(path2)).exists()) {
                return file2;
            }
            file2 = new java.io.File(path2 = path2.replace("%20", " "));
            if (file2.exists()) {
                return file2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean hasJarFileInPath(URL url2) {
        return url2.toExternalForm().matches(".*\\.jar(!.*|$)");
    }

    private static boolean hasInnerJarFileInPath(URL url2) {
        return url2.toExternalForm().matches(".+\\.jar!/.+");
    }

    public static enum DefaultUrlTypes implements UrlType
    {
        jarFile{

            @Override
            public boolean matches(URL url2) {
                return url2.getProtocol().equals("file") && Vfs.hasJarFileInPath(url2);
            }

            @Override
            public Dir createDir(URL url2) throws Exception {
                return new ZipDir(new JarFile(Vfs.getFile(url2)));
            }
        }
        ,
        jarUrl{

            @Override
            public boolean matches(URL url2) {
                return ("jar".equals(url2.getProtocol()) || "zip".equals(url2.getProtocol()) || "wsjar".equals(url2.getProtocol())) && !Vfs.hasInnerJarFileInPath(url2);
            }

            @Override
            public Dir createDir(URL url2) throws Exception {
                try {
                    URLConnection urlConnection = url2.openConnection();
                    if (urlConnection instanceof JarURLConnection) {
                        urlConnection.setUseCaches(false);
                        return new ZipDir(((JarURLConnection)urlConnection).getJarFile());
                    }
                }
                catch (Throwable urlConnection) {
                    // empty catch block
                }
                java.io.File file2 = Vfs.getFile(url2);
                if (file2 != null) {
                    return new ZipDir(new JarFile(file2));
                }
                return null;
            }
        }
        ,
        directory{

            @Override
            public boolean matches(URL url2) {
                if (url2.getProtocol().equals("file") && !Vfs.hasJarFileInPath(url2)) {
                    java.io.File file2 = Vfs.getFile(url2);
                    return file2 != null && file2.isDirectory();
                }
                return false;
            }

            @Override
            public Dir createDir(URL url2) throws Exception {
                return new SystemDir(Vfs.getFile(url2));
            }
        }
        ,
        jboss_vfs{

            @Override
            public boolean matches(URL url2) {
                return url2.getProtocol().equals("vfs");
            }

            @Override
            public Dir createDir(URL url2) throws Exception {
                return JbossDir.createDir(url2);
            }
        }
        ,
        jboss_vfsfile{

            @Override
            public boolean matches(URL url2) throws Exception {
                return "vfszip".equals(url2.getProtocol()) || "vfsfile".equals(url2.getProtocol());
            }

            @Override
            public Dir createDir(URL url2) throws Exception {
                return new UrlTypeVFS().createDir(url2);
            }
        }
        ,
        bundle{

            @Override
            public boolean matches(URL url2) throws Exception {
                return url2.getProtocol().startsWith("bundle");
            }

            @Override
            public Dir createDir(URL url2) throws Exception {
                return Vfs.fromURL((URL)ClasspathHelper.contextClassLoader().loadClass("org.eclipse.core.runtime.FileLocator").getMethod("resolve", URL.class).invoke(null, url2));
            }
        }
        ,
        jarInputStream{

            @Override
            public boolean matches(URL url2) throws Exception {
                return url2.toExternalForm().contains(".jar");
            }

            @Override
            public Dir createDir(URL url2) throws Exception {
                return new JarInputDir(url2);
            }
        };

    }

    public static interface UrlType {
        public boolean matches(URL var1) throws Exception;

        public Dir createDir(URL var1) throws Exception;
    }

    public static interface File {
        public String getName();

        public String getRelativePath();

        public InputStream openInputStream() throws IOException;
    }

    public static interface Dir {
        public String getPath();

        public Iterable<File> getFiles();

        default public void close() {
        }
    }
}

