/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.DialectConfiguration;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.Thymeleaf;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.dialect.IExecutionAttributeDialect;
import org.thymeleaf.dialect.IExpressionObjectDialect;
import org.thymeleaf.dialect.IPostProcessorDialect;
import org.thymeleaf.dialect.IPreProcessorDialect;
import org.thymeleaf.dialect.IProcessorDialect;
import org.thymeleaf.expression.IExpressionObjectFactory;
import org.thymeleaf.linkbuilder.ILinkBuilder;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.postprocessor.IPostProcessor;
import org.thymeleaf.preprocessor.IPreProcessor;
import org.thymeleaf.processor.IProcessor;
import org.thymeleaf.processor.cdatasection.ICDATASectionProcessor;
import org.thymeleaf.processor.comment.ICommentProcessor;
import org.thymeleaf.processor.doctype.IDocTypeProcessor;
import org.thymeleaf.processor.element.IElementModelProcessor;
import org.thymeleaf.processor.element.IElementTagProcessor;
import org.thymeleaf.processor.element.MatchingAttributeName;
import org.thymeleaf.processor.element.MatchingElementName;
import org.thymeleaf.processor.processinginstruction.IProcessingInstructionProcessor;
import org.thymeleaf.processor.text.ITextProcessor;
import org.thymeleaf.processor.xmldeclaration.IXMLDeclarationProcessor;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.util.ProcessorComparators;
import org.thymeleaf.util.StringUtils;

final class ConfigurationPrinterHelper {
    public static final String CONFIGURATION_LOGGER_NAME = TemplateEngine.class.getName() + ".CONFIG";
    private static final Logger configLogger = LoggerFactory.getLogger(CONFIGURATION_LOGGER_NAME);
    private static String THYMELEAF_VERSION = Thymeleaf.getVersion();
    private static String THYMELEAF_BUILD_TIMESTAMP = Thymeleaf.getBuildTimestamp();

    static void printConfiguration(IEngineConfiguration configuration) {
        ConfigLogBuilder logBuilder = new ConfigLogBuilder();
        ICacheManager cacheManager = configuration.getCacheManager();
        Set<ITemplateResolver> templateResolvers = configuration.getTemplateResolvers();
        Set<IMessageResolver> messageResolvers = configuration.getMessageResolvers();
        Set<ILinkBuilder> linkBuilders = configuration.getLinkBuilders();
        logBuilder.line("Initializing Thymeleaf Template engine configuration...");
        logBuilder.line("[THYMELEAF] TEMPLATE ENGINE CONFIGURATION:");
        if (!StringUtils.isEmptyOrWhitespace(THYMELEAF_VERSION)) {
            if (!StringUtils.isEmptyOrWhitespace(THYMELEAF_BUILD_TIMESTAMP)) {
                logBuilder.line("[THYMELEAF] * Thymeleaf version: {} (built {})", THYMELEAF_VERSION, THYMELEAF_BUILD_TIMESTAMP);
            } else {
                logBuilder.line("[THYMELEAF] * Thymeleaf version: {}", THYMELEAF_VERSION);
            }
        }
        logBuilder.line("[THYMELEAF] * Cache Manager implementation: {}", cacheManager == null ? "[no caches]" : cacheManager.getClass().getName());
        logBuilder.line("[THYMELEAF] * Template resolvers:");
        for (ITemplateResolver templateResolver : templateResolvers) {
            if (templateResolver.getOrder() != null) {
                logBuilder.line("[THYMELEAF]     * [{}] {}", templateResolver.getOrder(), templateResolver.getName());
                continue;
            }
            logBuilder.line("[THYMELEAF]     * {}", templateResolver.getName());
        }
        logBuilder.line("[THYMELEAF] * Message resolvers:");
        for (IMessageResolver messageResolver : messageResolvers) {
            if (messageResolver.getOrder() != null) {
                logBuilder.line("[THYMELEAF]     * [{}] {}", messageResolver.getOrder(), messageResolver.getName());
                continue;
            }
            logBuilder.line("[THYMELEAF]     * {}", messageResolver.getName());
        }
        logBuilder.line("[THYMELEAF] * Link builders:");
        for (ILinkBuilder linkBuilder : linkBuilders) {
            if (linkBuilder.getOrder() != null) {
                logBuilder.line("[THYMELEAF]     * [{}] {}", linkBuilder.getOrder(), linkBuilder.getName());
                continue;
            }
            logBuilder.line("[THYMELEAF]     * {}", linkBuilder.getName());
        }
        Set<DialectConfiguration> dialectConfigurations = configuration.getDialectConfigurations();
        int dialectIndex = 1;
        Integer totalDialects = dialectConfigurations.size();
        for (DialectConfiguration dialectConfiguration : dialectConfigurations) {
            IDialect dialect = dialectConfiguration.getDialect();
            if (totalDialects > 1) {
                logBuilder.line("[THYMELEAF] * Dialect [{} of {}]: {} ({})", new Object[]{dialectIndex, totalDialects, dialect.getName(), dialect.getClass().getName()});
            } else {
                logBuilder.line("[THYMELEAF] * Dialect: {} ({})", dialect.getName(), dialect.getClass().getName());
            }
            String dialectPrefix = null;
            if (dialect instanceof IProcessorDialect) {
                dialectPrefix = dialectConfiguration.isPrefixSpecified() ? dialectConfiguration.getPrefix() : ((IProcessorDialect)dialect).getPrefix();
                logBuilder.line("[THYMELEAF]     * Prefix: \"{}\"", dialectPrefix != null ? dialectPrefix : "(none)");
            }
            if (configLogger.isDebugEnabled()) {
                ConfigurationPrinterHelper.printDebugConfiguration(logBuilder, dialect, dialectPrefix);
            }
            ++dialectIndex;
        }
        logBuilder.end("[THYMELEAF] TEMPLATE ENGINE CONFIGURED OK");
        if (configLogger.isTraceEnabled()) {
            configLogger.trace(logBuilder.toString());
        } else if (configLogger.isDebugEnabled()) {
            configLogger.debug(logBuilder.toString());
        }
    }

    private static void printDebugConfiguration(ConfigLogBuilder logBuilder, IDialect idialect, String dialectPrefix) {
        Map<String, Object> executionAttributes;
        Set<String> expressionObjectNames;
        IExpressionObjectFactory expressionObjectFactory;
        IDialect dialect;
        if (idialect instanceof IProcessorDialect) {
            dialect = (IProcessorDialect)idialect;
            Set<IProcessor> processors = dialect.getProcessors(dialectPrefix);
            ConfigurationPrinterHelper.printProcessorsForTemplateMode(logBuilder, processors, TemplateMode.HTML);
            ConfigurationPrinterHelper.printProcessorsForTemplateMode(logBuilder, processors, TemplateMode.XML);
            ConfigurationPrinterHelper.printProcessorsForTemplateMode(logBuilder, processors, TemplateMode.TEXT);
            ConfigurationPrinterHelper.printProcessorsForTemplateMode(logBuilder, processors, TemplateMode.JAVASCRIPT);
            ConfigurationPrinterHelper.printProcessorsForTemplateMode(logBuilder, processors, TemplateMode.CSS);
            ConfigurationPrinterHelper.printProcessorsForTemplateMode(logBuilder, processors, TemplateMode.RAW);
        }
        if (idialect instanceof IPreProcessorDialect) {
            dialect = (IPreProcessorDialect)idialect;
            Set<IPreProcessor> preProcessors = dialect.getPreProcessors();
            ConfigurationPrinterHelper.printPreProcessorsForTemplateMode(logBuilder, preProcessors, TemplateMode.HTML);
            ConfigurationPrinterHelper.printPreProcessorsForTemplateMode(logBuilder, preProcessors, TemplateMode.XML);
            ConfigurationPrinterHelper.printPreProcessorsForTemplateMode(logBuilder, preProcessors, TemplateMode.TEXT);
            ConfigurationPrinterHelper.printPreProcessorsForTemplateMode(logBuilder, preProcessors, TemplateMode.JAVASCRIPT);
            ConfigurationPrinterHelper.printPreProcessorsForTemplateMode(logBuilder, preProcessors, TemplateMode.CSS);
            ConfigurationPrinterHelper.printPreProcessorsForTemplateMode(logBuilder, preProcessors, TemplateMode.RAW);
        }
        if (idialect instanceof IPostProcessorDialect) {
            dialect = (IPostProcessorDialect)idialect;
            Set<IPostProcessor> postProcessors = dialect.getPostProcessors();
            ConfigurationPrinterHelper.printPostProcessorsForTemplateMode(logBuilder, postProcessors, TemplateMode.HTML);
            ConfigurationPrinterHelper.printPostProcessorsForTemplateMode(logBuilder, postProcessors, TemplateMode.XML);
            ConfigurationPrinterHelper.printPostProcessorsForTemplateMode(logBuilder, postProcessors, TemplateMode.TEXT);
            ConfigurationPrinterHelper.printPostProcessorsForTemplateMode(logBuilder, postProcessors, TemplateMode.JAVASCRIPT);
            ConfigurationPrinterHelper.printPostProcessorsForTemplateMode(logBuilder, postProcessors, TemplateMode.CSS);
            ConfigurationPrinterHelper.printPostProcessorsForTemplateMode(logBuilder, postProcessors, TemplateMode.RAW);
        }
        if (idialect instanceof IExpressionObjectDialect && (expressionObjectFactory = (dialect = (IExpressionObjectDialect)idialect).getExpressionObjectFactory()) != null && (expressionObjectNames = expressionObjectFactory.getAllExpressionObjectNames()) != null && !expressionObjectNames.isEmpty()) {
            logBuilder.line("[THYMELEAF]     * Expression Objects:");
            for (String expressionObjectName : expressionObjectNames) {
                logBuilder.line("[THYMELEAF]         * #{}", new Object[]{expressionObjectName});
            }
        }
        if (idialect instanceof IExecutionAttributeDialect && (executionAttributes = (dialect = (IExecutionAttributeDialect)idialect).getExecutionAttributes()) != null && !executionAttributes.isEmpty()) {
            logBuilder.line("[THYMELEAF]     * Execution Attributes:");
            for (Map.Entry<String, Object> executionAttributesEntry : executionAttributes.entrySet()) {
                String attrName = executionAttributesEntry.getKey();
                String attrValue = executionAttributesEntry.getValue() == null ? null : executionAttributesEntry.getValue().toString();
                logBuilder.line("[THYMELEAF]         * \"{}\": {}", new Object[]{attrName, attrValue});
            }
        }
    }

    private static void printProcessorsForTemplateMode(ConfigLogBuilder logBuilder, Set<IProcessor> processors, TemplateMode templateMode) {
        String attributeName;
        String elementName;
        MatchingAttributeName matchingAttributeName;
        MatchingElementName matchingElementName;
        if (processors == null || processors.isEmpty()) {
            return;
        }
        ArrayList<ICDATASectionProcessor> cdataSectionProcessors = new ArrayList<ICDATASectionProcessor>();
        ArrayList<ICommentProcessor> commentProcessors = new ArrayList<ICommentProcessor>();
        ArrayList<IDocTypeProcessor> docTypeProcessors = new ArrayList<IDocTypeProcessor>();
        ArrayList<IElementTagProcessor> elementTagProcessors = new ArrayList<IElementTagProcessor>();
        ArrayList<IElementModelProcessor> elementModelProcessors = new ArrayList<IElementModelProcessor>();
        ArrayList<IProcessingInstructionProcessor> processingInstructionProcessors = new ArrayList<IProcessingInstructionProcessor>();
        ArrayList<ITextProcessor> textProcessors = new ArrayList<ITextProcessor>();
        ArrayList<IXMLDeclarationProcessor> xmlDeclarationProcessors = new ArrayList<IXMLDeclarationProcessor>();
        boolean processorsForTemplateModeExist = false;
        for (IProcessor iProcessor : processors) {
            if (!templateMode.equals((Object)iProcessor.getTemplateMode())) continue;
            processorsForTemplateModeExist = true;
            if (iProcessor instanceof ICDATASectionProcessor) {
                cdataSectionProcessors.add((ICDATASectionProcessor)iProcessor);
                continue;
            }
            if (iProcessor instanceof ICommentProcessor) {
                commentProcessors.add((ICommentProcessor)iProcessor);
                continue;
            }
            if (iProcessor instanceof IDocTypeProcessor) {
                docTypeProcessors.add((IDocTypeProcessor)iProcessor);
                continue;
            }
            if (iProcessor instanceof IElementTagProcessor) {
                elementTagProcessors.add((IElementTagProcessor)iProcessor);
                continue;
            }
            if (iProcessor instanceof IElementModelProcessor) {
                elementModelProcessors.add((IElementModelProcessor)iProcessor);
                continue;
            }
            if (iProcessor instanceof IProcessingInstructionProcessor) {
                processingInstructionProcessors.add((IProcessingInstructionProcessor)iProcessor);
                continue;
            }
            if (iProcessor instanceof ITextProcessor) {
                textProcessors.add((ITextProcessor)iProcessor);
                continue;
            }
            if (!(iProcessor instanceof IXMLDeclarationProcessor)) continue;
            xmlDeclarationProcessors.add((IXMLDeclarationProcessor)iProcessor);
        }
        if (!processorsForTemplateModeExist) {
            return;
        }
        logBuilder.line("[THYMELEAF]     * Processors for Template Mode: {}", (Object)templateMode);
        Collections.sort(cdataSectionProcessors, ProcessorComparators.PROCESSOR_COMPARATOR);
        Collections.sort(commentProcessors, ProcessorComparators.PROCESSOR_COMPARATOR);
        Collections.sort(docTypeProcessors, ProcessorComparators.PROCESSOR_COMPARATOR);
        Collections.sort(elementTagProcessors, ProcessorComparators.PROCESSOR_COMPARATOR);
        Collections.sort(elementModelProcessors, ProcessorComparators.PROCESSOR_COMPARATOR);
        Collections.sort(processingInstructionProcessors, ProcessorComparators.PROCESSOR_COMPARATOR);
        Collections.sort(textProcessors, ProcessorComparators.PROCESSOR_COMPARATOR);
        Collections.sort(xmlDeclarationProcessors, ProcessorComparators.PROCESSOR_COMPARATOR);
        if (!elementTagProcessors.isEmpty()) {
            logBuilder.line("[THYMELEAF]         * Element Tag Processors by [matching element and attribute name] [precedence]:");
            for (IElementTagProcessor iElementTagProcessor : elementTagProcessors) {
                matchingElementName = iElementTagProcessor.getMatchingElementName();
                matchingAttributeName = iElementTagProcessor.getMatchingAttributeName();
                elementName = matchingElementName == null ? "*" : matchingElementName.toString();
                attributeName = matchingAttributeName == null ? "*" : matchingAttributeName.toString();
                logBuilder.line("[THYMELEAF]             * [{} {}] [{}]: {}", new Object[]{elementName, attributeName, iElementTagProcessor.getPrecedence(), iElementTagProcessor.getClass().getName()});
            }
        }
        if (!elementModelProcessors.isEmpty()) {
            logBuilder.line("[THYMELEAF]         * Element Model Processors by [matching element and attribute name] [precedence]:");
            for (IElementModelProcessor iElementModelProcessor : elementModelProcessors) {
                matchingElementName = iElementModelProcessor.getMatchingElementName();
                matchingAttributeName = iElementModelProcessor.getMatchingAttributeName();
                elementName = matchingElementName == null ? "*" : matchingElementName.toString();
                attributeName = matchingAttributeName == null ? "*" : matchingAttributeName.toString();
                logBuilder.line("[THYMELEAF]             * [{} {}] [{}]: {}", new Object[]{elementName, attributeName, iElementModelProcessor.getPrecedence(), iElementModelProcessor.getClass().getName()});
            }
        }
        if (!textProcessors.isEmpty()) {
            logBuilder.line("[THYMELEAF]         * Text Processors by [precedence]:");
            for (ITextProcessor iTextProcessor : textProcessors) {
                logBuilder.line("[THYMELEAF]             * [{}]: {}", new Object[]{iTextProcessor.getPrecedence(), iTextProcessor.getClass().getName()});
            }
        }
        if (!docTypeProcessors.isEmpty()) {
            logBuilder.line("[THYMELEAF]         * DOCTYPE Processors by [precedence]:");
            for (IDocTypeProcessor iDocTypeProcessor : docTypeProcessors) {
                logBuilder.line("[THYMELEAF]             * [{}]: {}", new Object[]{iDocTypeProcessor.getPrecedence(), iDocTypeProcessor.getClass().getName()});
            }
        }
        if (!cdataSectionProcessors.isEmpty()) {
            logBuilder.line("[THYMELEAF]         * CDATA Section Processors by [precedence]:");
            for (ICDATASectionProcessor iCDATASectionProcessor : cdataSectionProcessors) {
                logBuilder.line("[THYMELEAF]             * [{}]: {}", new Object[]{iCDATASectionProcessor.getPrecedence(), iCDATASectionProcessor.getClass().getName()});
            }
        }
        if (!commentProcessors.isEmpty()) {
            logBuilder.line("[THYMELEAF]         * Comment Processors by [precedence]:");
            for (ICommentProcessor iCommentProcessor : commentProcessors) {
                logBuilder.line("[THYMELEAF]             * [{}]: {}", new Object[]{iCommentProcessor.getPrecedence(), iCommentProcessor.getClass().getName()});
            }
        }
        if (!xmlDeclarationProcessors.isEmpty()) {
            logBuilder.line("[THYMELEAF]         * XML Declaration Processors by [precedence]:");
            for (IXMLDeclarationProcessor iXMLDeclarationProcessor : xmlDeclarationProcessors) {
                logBuilder.line("[THYMELEAF]             * [{}]: {}", new Object[]{iXMLDeclarationProcessor.getPrecedence(), iXMLDeclarationProcessor.getClass().getName()});
            }
        }
        if (!processingInstructionProcessors.isEmpty()) {
            logBuilder.line("[THYMELEAF]         * Processing Instruction Processors by [precedence]:");
            for (IProcessingInstructionProcessor iProcessingInstructionProcessor : processingInstructionProcessors) {
                logBuilder.line("[THYMELEAF]             * [{}]: {}", new Object[]{iProcessingInstructionProcessor.getPrecedence(), iProcessingInstructionProcessor.getClass().getName()});
            }
        }
    }

    private static void printPreProcessorsForTemplateMode(ConfigLogBuilder logBuilder, Set<IPreProcessor> preProcessors, TemplateMode templateMode) {
        if (preProcessors == null || preProcessors.isEmpty()) {
            return;
        }
        ArrayList<IPreProcessor> preProcessorsForTemplateMode = new ArrayList<IPreProcessor>();
        for (IPreProcessor preProcessor : preProcessors) {
            if (!templateMode.equals((Object)preProcessor.getTemplateMode())) continue;
            preProcessorsForTemplateMode.add(preProcessor);
        }
        if (preProcessorsForTemplateMode.isEmpty()) {
            return;
        }
        Collections.sort(preProcessorsForTemplateMode, ProcessorComparators.PRE_PROCESSOR_COMPARATOR);
        logBuilder.line("[THYMELEAF]     * Pre-Processors for Template Mode: {} by [precedence]", (Object)templateMode);
        for (IPreProcessor preProcessor : preProcessorsForTemplateMode) {
            logBuilder.line("[THYMELEAF]             * [{}]: {}", new Object[]{preProcessor.getPrecedence(), preProcessor.getClass().getName()});
        }
    }

    private static void printPostProcessorsForTemplateMode(ConfigLogBuilder logBuilder, Set<IPostProcessor> postProcessors, TemplateMode templateMode) {
        if (postProcessors == null || postProcessors.isEmpty()) {
            return;
        }
        ArrayList<IPostProcessor> postProcessorsForTemplateMode = new ArrayList<IPostProcessor>();
        for (IPostProcessor postProcessor : postProcessors) {
            if (!templateMode.equals((Object)postProcessor.getTemplateMode())) continue;
            postProcessorsForTemplateMode.add(postProcessor);
        }
        if (postProcessorsForTemplateMode.isEmpty()) {
            return;
        }
        Collections.sort(postProcessorsForTemplateMode, ProcessorComparators.POST_PROCESSOR_COMPARATOR);
        logBuilder.line("[THYMELEAF]     * Post-Processors for Template Mode: {} by [precedence]", (Object)templateMode);
        for (IPostProcessor postProcessor : postProcessorsForTemplateMode) {
            logBuilder.line("[THYMELEAF]             * [{}]: {}", new Object[]{postProcessor.getPrecedence(), postProcessor.getClass().getName()});
        }
    }

    private ConfigurationPrinterHelper() {
    }

    private static final class ConfigLogBuilder {
        private static final String PLACEHOLDER = "\\{\\}";
        private final StringBuilder strBuilder = new StringBuilder();

        protected ConfigLogBuilder() {
        }

        protected void end(String line) {
            this.strBuilder.append(line);
        }

        protected void line(String line) {
            this.strBuilder.append(line).append("\n");
        }

        protected void line(String line, Object p1) {
            this.strBuilder.append(this.replace(line, p1)).append("\n");
        }

        protected void line(String line, Object p1, Object p2) {
            this.strBuilder.append(this.replace(this.replace(line, p1), p2)).append("\n");
        }

        protected void line(String line, Object[] pArr) {
            String newLine = line;
            for (Object aPArr : pArr) {
                newLine = this.replace(newLine, aPArr);
            }
            this.strBuilder.append(newLine).append("\n");
        }

        public String toString() {
            return this.strBuilder.toString();
        }

        private String replace(String str, Object replacement) {
            return str.replaceFirst(PLACEHOLDER, replacement == null ? "" : this.param(replacement));
        }

        private String param(Object p) {
            if (p == null) {
                return null;
            }
            return p.toString().replaceAll("\\$", "\\.");
        }
    }
}

