/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.ConfigurationPrinterHelper;
import org.thymeleaf.DialectConfiguration;
import org.thymeleaf.EngineConfiguration;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.ITemplateEngine;
import org.thymeleaf.IThrottledTemplateProcessor;
import org.thymeleaf.TemplateSpec;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.cache.StandardCacheManager;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IEngineContextFactory;
import org.thymeleaf.context.StandardEngineContextFactory;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.engine.TemplateManager;
import org.thymeleaf.engine.ThrottledTemplateProcessor;
import org.thymeleaf.exceptions.TemplateEngineException;
import org.thymeleaf.exceptions.TemplateOutputException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.linkbuilder.ILinkBuilder;
import org.thymeleaf.linkbuilder.StandardLinkBuilder;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.messageresolver.StandardMessageResolver;
import org.thymeleaf.standard.StandardDialect;
import org.thymeleaf.templateparser.markup.decoupled.IDecoupledTemplateLogicResolver;
import org.thymeleaf.templateparser.markup.decoupled.StandardDecoupledTemplateLogicResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.StringTemplateResolver;
import org.thymeleaf.util.FastStringWriter;
import org.thymeleaf.util.LoggingUtils;
import org.thymeleaf.util.Validate;

public class TemplateEngine
implements ITemplateEngine {
    public static final String TIMER_LOGGER_NAME = TemplateEngine.class.getName() + ".TIMER";
    private static final Logger logger = LoggerFactory.getLogger(TemplateEngine.class);
    private static final Logger timerLogger = LoggerFactory.getLogger(TIMER_LOGGER_NAME);
    private static final int NANOS_IN_SECOND = 1000000;
    private volatile boolean initialized = false;
    private final Set<DialectConfiguration> dialectConfigurations = new LinkedHashSet<DialectConfiguration>(3);
    private final Set<ITemplateResolver> templateResolvers = new LinkedHashSet<ITemplateResolver>(3);
    private final Set<IMessageResolver> messageResolvers = new LinkedHashSet<IMessageResolver>(3);
    private final Set<ILinkBuilder> linkBuilders = new LinkedHashSet<ILinkBuilder>(3);
    private ICacheManager cacheManager = null;
    private IEngineContextFactory engineContextFactory = null;
    private IDecoupledTemplateLogicResolver decoupledTemplateLogicResolver = null;
    private IEngineConfiguration configuration = null;

    public TemplateEngine() {
        this.setCacheManager(new StandardCacheManager());
        this.setEngineContextFactory(new StandardEngineContextFactory());
        this.setMessageResolver(new StandardMessageResolver());
        this.setLinkBuilder(new StandardLinkBuilder());
        this.setDecoupledTemplateLogicResolver(new StandardDecoupledTemplateLogicResolver());
        this.setDialect(new StandardDialect());
    }

    private void checkNotInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("Template engine has already been initialized (probably because it has already been executed or a fully-built Configuration object has been requested from it. At this state, no modifications on its configuration are allowed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void initialize() {
        if (!this.initialized) {
            TemplateEngine templateEngine = this;
            synchronized (templateEngine) {
                if (!this.initialized) {
                    logger.debug("[THYMELEAF] INITIALIZING TEMPLATE ENGINE");
                    this.initializeSpecific();
                    if (this.templateResolvers.isEmpty()) {
                        this.templateResolvers.add(new StringTemplateResolver());
                    }
                    this.configuration = new EngineConfiguration(this.templateResolvers, this.messageResolvers, this.linkBuilders, this.dialectConfigurations, this.cacheManager, this.engineContextFactory, this.decoupledTemplateLogicResolver);
                    ((EngineConfiguration)this.configuration).initialize();
                    this.initialized = true;
                    ConfigurationPrinterHelper.printConfiguration(this.configuration);
                    logger.debug("[THYMELEAF] TEMPLATE ENGINE INITIALIZED");
                }
            }
        }
    }

    protected void initializeSpecific() {
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public IEngineConfiguration getConfiguration() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.configuration;
    }

    public final Map<String, Set<IDialect>> getDialectsByPrefix() {
        Set<DialectConfiguration> dialectConfs = this.initialized ? this.configuration.getDialectConfigurations() : this.dialectConfigurations;
        LinkedHashMap<String, LinkedHashSet<IDialect>> dialectsByPrefix = new LinkedHashMap<String, LinkedHashSet<IDialect>>(3);
        for (DialectConfiguration dialectConfiguration : dialectConfs) {
            String prefix2 = dialectConfiguration.getPrefix();
            LinkedHashSet<IDialect> dialectsForPrefix = (LinkedHashSet<IDialect>)dialectsByPrefix.get(prefix2);
            if (dialectsForPrefix == null) {
                dialectsForPrefix = new LinkedHashSet<IDialect>(2);
                dialectsByPrefix.put(prefix2, dialectsForPrefix);
            }
            dialectsForPrefix.add(dialectConfiguration.getDialect());
        }
        return Collections.unmodifiableMap(dialectsByPrefix);
    }

    public final Set<IDialect> getDialects() {
        if (this.initialized) {
            return this.configuration.getDialects();
        }
        LinkedHashSet<IDialect> dialects = new LinkedHashSet<IDialect>(this.dialectConfigurations.size());
        for (DialectConfiguration dialectConfiguration : this.dialectConfigurations) {
            dialects.add(dialectConfiguration.getDialect());
        }
        return Collections.unmodifiableSet(dialects);
    }

    public void setDialect(IDialect dialect) {
        Validate.notNull(dialect, "Dialect cannot be null");
        this.checkNotInitialized();
        this.dialectConfigurations.clear();
        this.dialectConfigurations.add(new DialectConfiguration(dialect));
    }

    public void addDialect(String prefix2, IDialect dialect) {
        Validate.notNull(dialect, "Dialect cannot be null");
        this.checkNotInitialized();
        this.dialectConfigurations.add(new DialectConfiguration(prefix2, dialect));
    }

    public void addDialect(IDialect dialect) {
        Validate.notNull(dialect, "Dialect cannot be null");
        this.checkNotInitialized();
        this.dialectConfigurations.add(new DialectConfiguration(dialect));
    }

    public void setDialectsByPrefix(Map<String, IDialect> dialects) {
        Validate.notNull(dialects, "Dialect map cannot be null");
        this.checkNotInitialized();
        this.dialectConfigurations.clear();
        for (Map.Entry<String, IDialect> dialectEntry : dialects.entrySet()) {
            this.addDialect(dialectEntry.getKey(), dialectEntry.getValue());
        }
    }

    public void setDialects(Set<IDialect> dialects) {
        Validate.notNull(dialects, "Dialect set cannot be null");
        this.checkNotInitialized();
        this.dialectConfigurations.clear();
        for (IDialect dialect : dialects) {
            this.addDialect(dialect);
        }
    }

    public void setAdditionalDialects(Set<IDialect> additionalDialects) {
        Validate.notNull(additionalDialects, "Dialect set cannot be null");
        this.checkNotInitialized();
        for (IDialect dialect : additionalDialects) {
            this.addDialect(dialect);
        }
    }

    public void clearDialects() {
        this.checkNotInitialized();
        this.dialectConfigurations.clear();
    }

    public final Set<ITemplateResolver> getTemplateResolvers() {
        if (this.initialized) {
            return this.configuration.getTemplateResolvers();
        }
        return Collections.unmodifiableSet(this.templateResolvers);
    }

    public void setTemplateResolvers(Set<ITemplateResolver> templateResolvers) {
        Validate.notNull(templateResolvers, "Template Resolver set cannot be null");
        this.checkNotInitialized();
        this.templateResolvers.clear();
        for (ITemplateResolver templateResolver : templateResolvers) {
            this.addTemplateResolver(templateResolver);
        }
    }

    public void addTemplateResolver(ITemplateResolver templateResolver) {
        Validate.notNull(templateResolver, "Template Resolver cannot be null");
        this.checkNotInitialized();
        this.templateResolvers.add(templateResolver);
    }

    public void setTemplateResolver(ITemplateResolver templateResolver) {
        Validate.notNull(templateResolver, "Template Resolver cannot be null");
        this.checkNotInitialized();
        this.templateResolvers.clear();
        this.templateResolvers.add(templateResolver);
    }

    public final ICacheManager getCacheManager() {
        if (this.initialized) {
            return this.configuration.getCacheManager();
        }
        return this.cacheManager;
    }

    public void setCacheManager(ICacheManager cacheManager) {
        this.checkNotInitialized();
        this.cacheManager = cacheManager;
    }

    public final IEngineContextFactory getEngineContextFactory() {
        if (this.initialized) {
            return this.configuration.getEngineContextFactory();
        }
        return this.engineContextFactory;
    }

    public void setEngineContextFactory(IEngineContextFactory engineContextFactory) {
        Validate.notNull(engineContextFactory, "Engine Context Factory cannot be set to null");
        this.checkNotInitialized();
        this.engineContextFactory = engineContextFactory;
    }

    public final IDecoupledTemplateLogicResolver getDecoupledTemplateLogicResolver() {
        if (this.initialized) {
            return this.configuration.getDecoupledTemplateLogicResolver();
        }
        return this.decoupledTemplateLogicResolver;
    }

    public void setDecoupledTemplateLogicResolver(IDecoupledTemplateLogicResolver decoupledTemplateLogicResolver) {
        Validate.notNull(decoupledTemplateLogicResolver, "Decoupled Template Logic Resolver cannot be set to null");
        this.checkNotInitialized();
        this.decoupledTemplateLogicResolver = decoupledTemplateLogicResolver;
    }

    public final Set<IMessageResolver> getMessageResolvers() {
        if (this.initialized) {
            return this.configuration.getMessageResolvers();
        }
        return Collections.unmodifiableSet(this.messageResolvers);
    }

    public void setMessageResolvers(Set<IMessageResolver> messageResolvers) {
        Validate.notNull(messageResolvers, "Message Resolver set cannot be null");
        this.checkNotInitialized();
        this.messageResolvers.clear();
        for (IMessageResolver messageResolver : messageResolvers) {
            this.addMessageResolver(messageResolver);
        }
    }

    public void addMessageResolver(IMessageResolver messageResolver) {
        Validate.notNull(messageResolver, "Message Resolver cannot be null");
        this.checkNotInitialized();
        this.messageResolvers.add(messageResolver);
    }

    public void setMessageResolver(IMessageResolver messageResolver) {
        Validate.notNull(messageResolver, "Message Resolver cannot be null");
        this.checkNotInitialized();
        this.messageResolvers.clear();
        this.messageResolvers.add(messageResolver);
    }

    public final Set<ILinkBuilder> getLinkBuilders() {
        if (this.initialized) {
            return this.configuration.getLinkBuilders();
        }
        return Collections.unmodifiableSet(this.linkBuilders);
    }

    public void setLinkBuilders(Set<ILinkBuilder> linkBuilders) {
        Validate.notNull(linkBuilders, "Link Builder set cannot be null");
        this.checkNotInitialized();
        this.linkBuilders.clear();
        for (ILinkBuilder linkBuilder : linkBuilders) {
            this.addLinkBuilder(linkBuilder);
        }
    }

    public void addLinkBuilder(ILinkBuilder linkBuilder) {
        Validate.notNull(linkBuilder, "Link Builder cannot be null");
        this.checkNotInitialized();
        this.linkBuilders.add(linkBuilder);
    }

    public void setLinkBuilder(ILinkBuilder linkBuilder) {
        Validate.notNull(linkBuilder, "Link Builder cannot be null");
        this.checkNotInitialized();
        this.linkBuilders.clear();
        this.linkBuilders.add(linkBuilder);
    }

    public void clearTemplateCache() {
        if (!this.initialized) {
            this.initialize();
        }
        this.configuration.getTemplateManager().clearCaches();
    }

    public void clearTemplateCacheFor(String templateName) {
        Validate.notNull(templateName, "Template name cannot be null");
        if (!this.initialized) {
            this.initialize();
        }
        this.configuration.getTemplateManager().clearCachesFor(templateName);
    }

    public static String threadIndex() {
        return Thread.currentThread().getName();
    }

    @Override
    public final String process(String template, IContext context) {
        return this.process(new TemplateSpec(template, null, null, null, null), context);
    }

    @Override
    public final String process(String template, Set<String> templateSelectors, IContext context) {
        return this.process(new TemplateSpec(template, templateSelectors, null, null, null), context);
    }

    @Override
    public final String process(TemplateSpec templateSpec, IContext context) {
        FastStringWriter stringWriter = new FastStringWriter(100);
        this.process(templateSpec, context, (Writer)stringWriter);
        return ((Object)stringWriter).toString();
    }

    @Override
    public final void process(String template, IContext context, Writer writer) {
        this.process(new TemplateSpec(template, null, null, null, null), context, writer);
    }

    @Override
    public final void process(String template, Set<String> templateSelectors, IContext context, Writer writer) {
        this.process(new TemplateSpec(template, templateSelectors, null, null, null), context, writer);
    }

    @Override
    public final void process(TemplateSpec templateSpec, IContext context, Writer writer) {
        if (!this.initialized) {
            this.initialize();
        }
        try {
            Validate.notNull(templateSpec, "Template Specification cannot be null");
            Validate.notNull(context, "Context cannot be null");
            Validate.notNull(writer, "Writer cannot be null");
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] STARTING PROCESS OF TEMPLATE \"{}\" WITH LOCALE {}", TemplateEngine.threadIndex(), templateSpec, context.getLocale());
            }
            long startNanos = System.nanoTime();
            TemplateManager templateManager = this.configuration.getTemplateManager();
            templateManager.parseAndProcess(templateSpec, context, writer);
            long endNanos = System.nanoTime();
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] FINISHED PROCESS AND OUTPUT OF TEMPLATE \"{}\" WITH LOCALE {}", TemplateEngine.threadIndex(), templateSpec, context.getLocale());
            }
            if (timerLogger.isTraceEnabled()) {
                BigDecimal elapsed = BigDecimal.valueOf(endNanos - startNanos);
                BigDecimal elapsedMs = elapsed.divide(BigDecimal.valueOf(1000000L), RoundingMode.HALF_UP);
                timerLogger.trace("[THYMELEAF][{}][{}][{}][{}][{}] TEMPLATE \"{}\" WITH LOCALE {} PROCESSED IN {} nanoseconds (approx. {}ms)", TemplateEngine.threadIndex(), LoggingUtils.loggifyTemplateName(templateSpec.getTemplate()), context.getLocale(), elapsed, elapsedMs, templateSpec, context.getLocale(), elapsed, elapsedMs);
            }
            try {
                writer.flush();
            }
            catch (IOException e2) {
                throw new TemplateOutputException("An error happened while flushing output writer", templateSpec.getTemplate(), -1, -1, e2);
            }
        }
        catch (TemplateOutputException e3) {
            logger.error(String.format("[THYMELEAF][%s] Exception processing template \"%s\": %s", TemplateEngine.threadIndex(), templateSpec, e3.getMessage()), e3);
            throw e3;
        }
        catch (TemplateEngineException e4) {
            logger.error(String.format("[THYMELEAF][%s] Exception processing template \"%s\": %s", TemplateEngine.threadIndex(), templateSpec, e4.getMessage()), e4);
            throw e4;
        }
        catch (RuntimeException e5) {
            logger.error(String.format("[THYMELEAF][%s] Exception processing template \"%s\": %s", TemplateEngine.threadIndex(), templateSpec, e5.getMessage()), e5);
            throw new TemplateProcessingException("Exception processing template", templateSpec.toString(), e5);
        }
    }

    @Override
    public final IThrottledTemplateProcessor processThrottled(String template, IContext context) {
        return this.processThrottled(new TemplateSpec(template, null, null, null, null), context);
    }

    @Override
    public final IThrottledTemplateProcessor processThrottled(String template, Set<String> templateSelectors, IContext context) {
        return this.processThrottled(new TemplateSpec(template, templateSelectors, null, null, null), context);
    }

    @Override
    public final IThrottledTemplateProcessor processThrottled(TemplateSpec templateSpec, IContext context) {
        ThrottledTemplateProcessor throttledTemplateProcessor;
        if (!this.initialized) {
            this.initialize();
        }
        try {
            Validate.notNull(templateSpec, "Template Specification cannot be null");
            Validate.notNull(context, "Context cannot be null");
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] STARTING PREPARATION OF THROTTLED TEMPLATE \"{}\" WITH LOCALE {}", TemplateEngine.threadIndex(), templateSpec, context.getLocale());
            }
            long startNanos = System.nanoTime();
            TemplateManager templateManager = this.configuration.getTemplateManager();
            throttledTemplateProcessor = templateManager.parseAndProcessThrottled(templateSpec, context);
            long endNanos = System.nanoTime();
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] FINISHED PREPARATION OF THROTTLED TEMPLATE \"{}\" WITH LOCALE {}", TemplateEngine.threadIndex(), templateSpec, context.getLocale());
            }
            if (timerLogger.isTraceEnabled()) {
                BigDecimal elapsed = BigDecimal.valueOf(endNanos - startNanos);
                BigDecimal elapsedMs = elapsed.divide(BigDecimal.valueOf(1000000L), RoundingMode.HALF_UP);
                timerLogger.trace("[THYMELEAF][{}][{}][{}][{}][{}] TEMPLATE \"{}\" WITH LOCALE {} PREPARED FOR THROTTLED PROCESSING IN {} nanoseconds (approx. {}ms)", TemplateEngine.threadIndex(), LoggingUtils.loggifyTemplateName(templateSpec.getTemplate()), context.getLocale(), elapsed, elapsedMs, templateSpec, context.getLocale(), elapsed, elapsedMs);
            }
        }
        catch (TemplateOutputException e2) {
            logger.error(String.format("[THYMELEAF][%s] Exception preparing throttled template \"%s\": %s", TemplateEngine.threadIndex(), templateSpec, e2.getMessage()), e2);
            throw e2;
        }
        catch (TemplateEngineException e3) {
            logger.error(String.format("[THYMELEAF][%s] Exception preparing throttled template \"%s\": %s", TemplateEngine.threadIndex(), templateSpec, e3.getMessage()), e3);
            throw e3;
        }
        catch (RuntimeException e4) {
            logger.error(String.format("[THYMELEAF][%s] Exception preparing throttled template \"%s\": %s", TemplateEngine.threadIndex(), templateSpec, e4.getMessage()), e4);
            throw new TemplateProcessingException("Exception preparing throttled template", templateSpec.toString(), e4);
        }
        return throttledTemplateProcessor;
    }
}

