/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf;

import java.util.Properties;
import org.thymeleaf.util.ClassLoaderUtils;
import org.thymeleaf.util.VersionUtils;

public final class Thymeleaf {
    private static final VersionUtils.VersionSpec VERSION_SPEC;

    public static String getVersion() {
        return VERSION_SPEC.getVersion();
    }

    public static String getBuildTimestamp() {
        return VERSION_SPEC.getBuildTimestamp();
    }

    public static int getVersionMajor() {
        return VERSION_SPEC.getMajor();
    }

    public static int getVersionMinor() {
        return VERSION_SPEC.getMinor();
    }

    public static int getVersionPatch() {
        return VERSION_SPEC.getPatch();
    }

    public static String getVersionQualifier() {
        return VERSION_SPEC.getQualifier();
    }

    public static boolean isVersionStableRelease() {
        return VERSION_SPEC.isStableRelease();
    }

    private Thymeleaf() {
    }

    static {
        String version2 = null;
        String buildTimestamp = null;
        try {
            Properties properties = new Properties();
            properties.load(ClassLoaderUtils.loadResourceAsStream("org/thymeleaf/thymeleaf.properties"));
            version2 = properties.getProperty("version");
            buildTimestamp = properties.getProperty("build.date");
        }
        catch (Exception exception) {
            // empty catch block
        }
        VERSION_SPEC = VersionUtils.parseVersion(version2, buildTimestamp);
    }
}

