/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.util.Validate;

public final class IdentifierSequences {
    private final Map<String, Integer> idCounts = new HashMap<String, Integer>(1, 1.0f);

    public Integer getAndIncrementIDSeq(String id) {
        Validate.notNull(id, "ID cannot be null");
        Integer count2 = this.idCounts.get(id);
        if (count2 == null) {
            count2 = 1;
        }
        this.idCounts.put(id, count2 + 1);
        return count2;
    }

    public Integer getNextIDSeq(String id) {
        Validate.notNull(id, "ID cannot be null");
        Integer count2 = this.idCounts.get(id);
        if (count2 == null) {
            count2 = 1;
        }
        return count2;
    }

    public Integer getPreviousIDSeq(String id) {
        Validate.notNull(id, "ID cannot be null");
        Integer count2 = this.idCounts.get(id);
        if (count2 == null) {
            throw new TemplateProcessingException("Cannot obtain previous ID count for ID \"" + id + "\"");
        }
        return count2 - 1;
    }
}

