/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.AbstractEngineContext;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.context.ILazyContextVariable;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.engine.TemplateData;
import org.thymeleaf.inline.IInliner;
import org.thymeleaf.inline.NoOpInliner;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.util.Validate;
import org.thymeleaf.web.IWebApplication;
import org.thymeleaf.web.IWebExchange;
import org.thymeleaf.web.IWebRequest;
import org.thymeleaf.web.IWebSession;

public class WebEngineContext
extends AbstractEngineContext
implements IEngineContext,
IWebContext {
    private static final String PARAM_VARIABLE_NAME = "param";
    private static final String SESSION_VARIABLE_NAME = "session";
    private static final String APPLICATION_VARIABLE_NAME = "application";
    private final IWebExchange webExchange;
    private final ExchangeAttributeMap exchangeAttributeMap;
    private final RequestParameterMap requestParameterMap;
    private final SessionAttributeMap sessionAttributeMap;
    private final ApplicationAttributeMap applicationAttributeMap;

    public WebEngineContext(IEngineConfiguration configuration, TemplateData templateData, Map<String, Object> templateResolutionAttributes, IWebExchange webExchange, Locale locale, Map<String, Object> variables) {
        super(configuration, templateResolutionAttributes, locale);
        Validate.notNull(webExchange, "Web exchange cannot be null in web context");
        this.webExchange = webExchange;
        this.exchangeAttributeMap = new ExchangeAttributeMap(configuration, templateData, templateResolutionAttributes, this.webExchange, locale, variables);
        this.requestParameterMap = new RequestParameterMap(this.webExchange);
        this.applicationAttributeMap = new ApplicationAttributeMap(this.webExchange);
        this.sessionAttributeMap = new SessionAttributeMap(this.webExchange);
    }

    @Override
    public IWebExchange getExchange() {
        return this.webExchange;
    }

    @Override
    public boolean containsVariable(String name) {
        if (SESSION_VARIABLE_NAME.equals(name)) {
            return this.sessionAttributeMap != null;
        }
        if (PARAM_VARIABLE_NAME.equals(name)) {
            return true;
        }
        return APPLICATION_VARIABLE_NAME.equals(name) || this.exchangeAttributeMap.containsVariable(name);
    }

    @Override
    public Object getVariable(String key2) {
        if (SESSION_VARIABLE_NAME.equals(key2)) {
            return this.sessionAttributeMap;
        }
        if (PARAM_VARIABLE_NAME.equals(key2)) {
            return this.requestParameterMap;
        }
        if (APPLICATION_VARIABLE_NAME.equals(key2)) {
            return this.applicationAttributeMap;
        }
        return this.exchangeAttributeMap.getVariable(key2);
    }

    @Override
    public Set<String> getVariableNames() {
        return this.exchangeAttributeMap.getVariableNames();
    }

    @Override
    public void setVariable(String name, Object value2) {
        if (SESSION_VARIABLE_NAME.equals(name) || PARAM_VARIABLE_NAME.equals(name) || APPLICATION_VARIABLE_NAME.equals(name)) {
            throw new IllegalArgumentException("Cannot set variable called '" + name + "' into web variables map: such name is a reserved word");
        }
        this.exchangeAttributeMap.setVariable(name, value2);
    }

    @Override
    public void setVariables(Map<String, Object> variables) {
        if (variables == null || variables.isEmpty()) {
            return;
        }
        for (String name : variables.keySet()) {
            if (!SESSION_VARIABLE_NAME.equals(name) && !PARAM_VARIABLE_NAME.equals(name) && !APPLICATION_VARIABLE_NAME.equals(name)) continue;
            throw new IllegalArgumentException("Cannot set variable called '" + name + "' into web variables map: such name is a reserved word");
        }
        this.exchangeAttributeMap.setVariables(variables);
    }

    @Override
    public void removeVariable(String name) {
        if (SESSION_VARIABLE_NAME.equals(name) || PARAM_VARIABLE_NAME.equals(name) || APPLICATION_VARIABLE_NAME.equals(name)) {
            throw new IllegalArgumentException("Cannot remove variable called '" + name + "' in web variables map: such name is a reserved word");
        }
        this.exchangeAttributeMap.removeVariable(name);
    }

    @Override
    public boolean isVariableLocal(String name) {
        return this.exchangeAttributeMap.isVariableLocal(name);
    }

    @Override
    public boolean hasSelectionTarget() {
        return this.exchangeAttributeMap.hasSelectionTarget();
    }

    @Override
    public Object getSelectionTarget() {
        return this.exchangeAttributeMap.getSelectionTarget();
    }

    @Override
    public void setSelectionTarget(Object selectionTarget) {
        this.exchangeAttributeMap.setSelectionTarget(selectionTarget);
    }

    @Override
    public IInliner getInliner() {
        return this.exchangeAttributeMap.getInliner();
    }

    @Override
    public void setInliner(IInliner inliner) {
        this.exchangeAttributeMap.setInliner(inliner);
    }

    @Override
    public TemplateData getTemplateData() {
        return this.exchangeAttributeMap.getTemplateData();
    }

    @Override
    public void setTemplateData(TemplateData templateData) {
        this.exchangeAttributeMap.setTemplateData(templateData);
    }

    @Override
    public List<TemplateData> getTemplateStack() {
        return this.exchangeAttributeMap.getTemplateStack();
    }

    @Override
    public void setElementTag(IProcessableElementTag elementTag) {
        this.exchangeAttributeMap.setElementTag(elementTag);
    }

    @Override
    public List<IProcessableElementTag> getElementStack() {
        return this.exchangeAttributeMap.getElementStack();
    }

    @Override
    public List<IProcessableElementTag> getElementStackAbove(int contextLevel) {
        return this.exchangeAttributeMap.getElementStackAbove(contextLevel);
    }

    @Override
    public int level() {
        return this.exchangeAttributeMap.level();
    }

    @Override
    public void increaseLevel() {
        this.exchangeAttributeMap.increaseLevel();
    }

    @Override
    public void decreaseLevel() {
        this.exchangeAttributeMap.decreaseLevel();
    }

    public String getStringRepresentationByLevel() {
        return this.exchangeAttributeMap.getStringRepresentationByLevel();
    }

    public String toString() {
        return this.exchangeAttributeMap.toString();
    }

    static Object resolveLazy(Object variable) {
        if (variable != null && variable instanceof ILazyContextVariable) {
            return ((ILazyContextVariable)variable).getValue();
        }
        return variable;
    }

    private static final class ExchangeAttributeMap
    extends AbstractEngineContext
    implements IEngineContext {
        private static final int DEFAULT_ELEMENT_HIERARCHY_SIZE = 20;
        private static final int DEFAULT_LEVELS_SIZE = 10;
        private static final int DEFAULT_LEVELARRAYS_SIZE = 5;
        private final IWebExchange webExchange;
        private int level = 0;
        private int index = 0;
        private int[] levels;
        private String[][] names;
        private Object[][] oldValues;
        private Object[][] newValues;
        private int[] levelSizes;
        private SelectionTarget[] selectionTargets;
        private IInliner[] inliners;
        private TemplateData[] templateDatas;
        private IProcessableElementTag[] elementTags;
        private SelectionTarget lastSelectionTarget = null;
        private IInliner lastInliner = null;
        private TemplateData lastTemplateData = null;
        private final List<TemplateData> templateStack;

        ExchangeAttributeMap(IEngineConfiguration configuration, TemplateData templateData, Map<String, Object> templateResolutionAttributes, IWebExchange webExchange, Locale locale, Map<String, Object> variables) {
            super(configuration, templateResolutionAttributes, locale);
            this.webExchange = webExchange;
            this.levels = new int[10];
            this.names = new String[10][];
            this.oldValues = new Object[10][];
            this.newValues = new Object[10][];
            this.levelSizes = new int[10];
            this.selectionTargets = new SelectionTarget[10];
            this.inliners = new IInliner[10];
            this.templateDatas = new TemplateData[10];
            this.elementTags = new IProcessableElementTag[20];
            Arrays.fill(this.levels, Integer.MAX_VALUE);
            Arrays.fill((Object[])this.names, null);
            Arrays.fill((Object[])this.oldValues, null);
            Arrays.fill((Object[])this.newValues, null);
            Arrays.fill(this.levelSizes, 0);
            Arrays.fill(this.selectionTargets, null);
            Arrays.fill(this.inliners, null);
            Arrays.fill(this.templateDatas, null);
            Arrays.fill(this.elementTags, null);
            this.levels[0] = 0;
            this.templateDatas[0] = templateData;
            this.lastTemplateData = templateData;
            this.templateStack = new ArrayList<TemplateData>(10);
            this.templateStack.add(templateData);
            if (variables != null) {
                this.setVariables(variables);
            }
        }

        @Override
        public boolean containsVariable(String name) {
            return this.webExchange.containsAttribute(name);
        }

        @Override
        public Object getVariable(String name) {
            return WebEngineContext.resolveLazy(this.webExchange.getAttributeValue(name));
        }

        @Override
        public Set<String> getVariableNames() {
            return this.webExchange.getAllAttributeNames();
        }

        private int searchNameInIndex(String name, int idx) {
            int n = this.levelSizes[idx];
            if (name == null) {
                while (n-- != 0) {
                    if (this.names[idx][n] != null) continue;
                    return n;
                }
                return -1;
            }
            while (n-- != 0) {
                if (!name.equals(this.names[idx][n])) continue;
                return n;
            }
            return -1;
        }

        @Override
        public void setVariable(String name, Object value2) {
            this.ensureLevelInitialized(true);
            if (this.level > 0) {
                int levelIndex = this.searchNameInIndex(name, this.index);
                if (levelIndex >= 0) {
                    this.newValues[this.index][levelIndex] = value2;
                } else {
                    if (this.names[this.index].length == this.levelSizes[this.index]) {
                        this.names[this.index] = Arrays.copyOf(this.names[this.index], this.names[this.index].length + 5);
                        this.newValues[this.index] = Arrays.copyOf(this.newValues[this.index], this.newValues[this.index].length + 5);
                        this.oldValues[this.index] = Arrays.copyOf(this.oldValues[this.index], this.oldValues[this.index].length + 5);
                    }
                    levelIndex = this.levelSizes[this.index];
                    this.names[this.index][levelIndex] = name;
                    this.oldValues[this.index][levelIndex] = this.webExchange.getAttributeValue(name);
                    this.newValues[this.index][levelIndex] = value2;
                    int n = this.index;
                    this.levelSizes[n] = this.levelSizes[n] + 1;
                }
            }
            this.webExchange.setAttributeValue(name, value2);
        }

        @Override
        public void setVariables(Map<String, Object> variables) {
            if (variables == null || variables.isEmpty()) {
                return;
            }
            for (Map.Entry<String, Object> entry : variables.entrySet()) {
                this.setVariable(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void removeVariable(String name) {
            this.setVariable(name, null);
        }

        @Override
        public boolean isVariableLocal(String name) {
            if (this.level == 0) {
                return false;
            }
            int n = this.index + 1;
            while (n-- > 1) {
                int idx = this.searchNameInIndex(name, n);
                if (idx < 0) continue;
                return this.newValues[n][idx] != null;
            }
            return false;
        }

        @Override
        public boolean hasSelectionTarget() {
            if (this.lastSelectionTarget != null) {
                return true;
            }
            int n = this.index + 1;
            while (n-- != 0) {
                if (this.selectionTargets[n] == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getSelectionTarget() {
            if (this.lastSelectionTarget != null) {
                return this.lastSelectionTarget.selectionTarget;
            }
            int n = this.index + 1;
            while (n-- != 0) {
                if (this.selectionTargets[n] == null) continue;
                this.lastSelectionTarget = this.selectionTargets[n];
                return this.lastSelectionTarget.selectionTarget;
            }
            return null;
        }

        @Override
        public void setSelectionTarget(Object selectionTarget) {
            this.ensureLevelInitialized(false);
            this.selectionTargets[this.index] = this.lastSelectionTarget = new SelectionTarget(selectionTarget);
        }

        @Override
        public IInliner getInliner() {
            if (this.lastInliner != null) {
                if (this.lastInliner == NoOpInliner.INSTANCE) {
                    return null;
                }
                return this.lastInliner;
            }
            int n = this.index + 1;
            while (n-- != 0) {
                if (this.inliners[n] == null) continue;
                this.lastInliner = this.inliners[n];
                if (this.lastInliner == NoOpInliner.INSTANCE) {
                    return null;
                }
                return this.lastInliner;
            }
            return null;
        }

        @Override
        public void setInliner(IInliner inliner) {
            this.ensureLevelInitialized(false);
            this.inliners[this.index] = this.lastInliner = inliner == null ? NoOpInliner.INSTANCE : inliner;
        }

        @Override
        public TemplateData getTemplateData() {
            if (this.lastTemplateData != null) {
                return this.lastTemplateData;
            }
            int n = this.index + 1;
            while (n-- != 0) {
                if (this.templateDatas[n] == null) continue;
                this.lastTemplateData = this.templateDatas[n];
                return this.lastTemplateData;
            }
            return null;
        }

        @Override
        public void setTemplateData(TemplateData templateData) {
            Validate.notNull(templateData, "Template Data cannot be null");
            this.ensureLevelInitialized(false);
            this.templateDatas[this.index] = this.lastTemplateData = templateData;
            this.templateStack.clear();
        }

        @Override
        public List<TemplateData> getTemplateStack() {
            if (!this.templateStack.isEmpty()) {
                return Collections.unmodifiableList(new ArrayList<TemplateData>(this.templateStack));
            }
            for (int i2 = 0; i2 <= this.index; ++i2) {
                if (this.templateDatas[i2] == null) continue;
                this.templateStack.add(this.templateDatas[i2]);
            }
            return Collections.unmodifiableList(new ArrayList<TemplateData>(this.templateStack));
        }

        @Override
        public void setElementTag(IProcessableElementTag elementTag) {
            if (this.elementTags.length <= this.level) {
                this.elementTags = Arrays.copyOf(this.elementTags, Math.max(this.level, this.elementTags.length + 20));
            }
            this.elementTags[this.level] = elementTag;
        }

        @Override
        public List<IProcessableElementTag> getElementStack() {
            ArrayList<IProcessableElementTag> elementStack = new ArrayList<IProcessableElementTag>(this.level);
            for (int i2 = 0; i2 <= this.level && i2 < this.elementTags.length; ++i2) {
                if (this.elementTags[i2] == null) continue;
                elementStack.add(this.elementTags[i2]);
            }
            return Collections.unmodifiableList(elementStack);
        }

        @Override
        public List<IProcessableElementTag> getElementStackAbove(int contextLevel) {
            ArrayList<IProcessableElementTag> elementStack = new ArrayList<IProcessableElementTag>(this.level);
            for (int i2 = contextLevel + 1; i2 <= this.level && i2 < this.elementTags.length; ++i2) {
                if (this.elementTags[i2] == null) continue;
                elementStack.add(this.elementTags[i2]);
            }
            return Collections.unmodifiableList(elementStack);
        }

        private void ensureLevelInitialized(boolean initVariables) {
            if (this.levels[this.index] != this.level) {
                ++this.index;
                if (this.levels.length == this.index) {
                    this.levels = Arrays.copyOf(this.levels, this.levels.length + 10);
                    Arrays.fill(this.levels, this.index, this.levels.length, Integer.MAX_VALUE);
                    this.names = (String[][])Arrays.copyOf(this.names, this.names.length + 10);
                    this.newValues = (Object[][])Arrays.copyOf(this.newValues, this.newValues.length + 10);
                    this.oldValues = (Object[][])Arrays.copyOf(this.oldValues, this.oldValues.length + 10);
                    this.levelSizes = Arrays.copyOf(this.levelSizes, this.levelSizes.length + 10);
                    this.selectionTargets = Arrays.copyOf(this.selectionTargets, this.selectionTargets.length + 10);
                    this.inliners = Arrays.copyOf(this.inliners, this.inliners.length + 10);
                    this.templateDatas = Arrays.copyOf(this.templateDatas, this.templateDatas.length + 10);
                }
                this.levels[this.index] = this.level;
            }
            if (this.level > 0 && initVariables && this.names[this.index] == null) {
                this.names[this.index] = new String[5];
                Arrays.fill(this.names[this.index], null);
                this.newValues[this.index] = new Object[5];
                Arrays.fill(this.newValues[this.index], null);
                this.oldValues[this.index] = new Object[5];
                Arrays.fill(this.oldValues[this.index], null);
                this.levelSizes[this.index] = 0;
            }
        }

        @Override
        public int level() {
            return this.level;
        }

        @Override
        public void increaseLevel() {
            ++this.level;
        }

        @Override
        public void decreaseLevel() {
            Validate.isTrue(this.level > 0, "Cannot decrease variable map level below 0");
            if (this.levels[this.index] == this.level) {
                this.levels[this.index] = Integer.MAX_VALUE;
                if (this.names[this.index] != null && this.levelSizes[this.index] > 0) {
                    int n = this.levelSizes[this.index];
                    while (n-- != 0) {
                        String name = this.names[this.index][n];
                        Object newValue = this.newValues[this.index][n];
                        Object oldValue = this.oldValues[this.index][n];
                        Object currentValue = this.webExchange.getAttributeValue(name);
                        if (newValue != currentValue) continue;
                        this.webExchange.setAttributeValue(name, oldValue);
                    }
                    this.levelSizes[this.index] = 0;
                }
                this.selectionTargets[this.index] = null;
                this.inliners[this.index] = null;
                this.templateDatas[this.index] = null;
                --this.index;
                this.lastSelectionTarget = null;
                this.lastInliner = null;
                this.lastTemplateData = null;
                this.templateStack.clear();
            }
            if (this.level < this.elementTags.length) {
                this.elementTags[this.level] = null;
            }
            --this.level;
        }

        public String getStringRepresentationByLevel() {
            Object oldValue;
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append('{');
            LinkedHashMap oldValuesSum = new LinkedHashMap();
            int n = this.index + 1;
            while (n-- != 1) {
                LinkedHashMap<String, Object> levelVars = new LinkedHashMap<String, Object>();
                if (this.names[n] != null && this.levelSizes[n] > 0) {
                    for (int i2 = 0; i2 < this.levelSizes[n]; ++i2) {
                        String name = this.names[n][i2];
                        Object object = this.newValues[n][i2];
                        oldValue = this.oldValues[n][i2];
                        if (object == oldValue || (!oldValuesSum.containsKey(name) ? object != this.webExchange.getAttributeValue(name) : object != oldValuesSum.get(name))) continue;
                        levelVars.put(name, object);
                        oldValuesSum.put(name, oldValue);
                    }
                }
                if (levelVars.isEmpty() && this.selectionTargets[n] == null && this.inliners[n] == null) continue;
                if (strBuilder.length() > 1) {
                    strBuilder.append(',');
                }
                strBuilder.append(this.levels[n]).append(":");
                if (!levelVars.isEmpty() || n == 0) {
                    strBuilder.append(levelVars);
                }
                if (this.selectionTargets[n] != null) {
                    strBuilder.append("<").append(this.selectionTargets[n].selectionTarget).append(">");
                }
                if (this.inliners[n] != null) {
                    strBuilder.append("[").append(this.inliners[n].getName()).append("]");
                }
                if (this.templateDatas[n] == null) continue;
                strBuilder.append("(").append(this.templateDatas[n].getTemplate()).append(")");
            }
            LinkedHashMap<String, Object> requestAttributes = new LinkedHashMap<String, Object>();
            Set<String> attrNames = this.webExchange.getAllAttributeNames();
            for (String string : attrNames) {
                if (oldValuesSum.containsKey(string)) {
                    oldValue = oldValuesSum.get(string);
                    if (oldValue != null) {
                        requestAttributes.put(string, oldValuesSum.get(string));
                    }
                    oldValuesSum.remove(string);
                    continue;
                }
                requestAttributes.put(string, this.webExchange.getAttributeValue(string));
            }
            for (Map.Entry entry : oldValuesSum.entrySet()) {
                Object oldValue2;
                String name = (String)entry.getKey();
                if (requestAttributes.containsKey(name) || (oldValue2 = entry.getValue()) == null) continue;
                requestAttributes.put(name, oldValue2);
            }
            if (strBuilder.length() > 1) {
                strBuilder.append(',');
            }
            strBuilder.append(this.levels[n]).append(":");
            strBuilder.append(((Object)requestAttributes).toString());
            if (this.selectionTargets[0] != null) {
                strBuilder.append("<").append(this.selectionTargets[0].selectionTarget).append(">");
            }
            if (this.inliners[0] != null) {
                strBuilder.append("[").append(this.inliners[0].getName()).append("]");
            }
            if (this.templateDatas[0] != null) {
                strBuilder.append("(").append(this.templateDatas[0].getTemplate()).append(")");
            }
            strBuilder.append("}[");
            strBuilder.append(this.level);
            strBuilder.append(']');
            return strBuilder.toString();
        }

        public String toString() {
            Map<String, Object> attributeMap = this.webExchange.getAttributeMap();
            String textInliningStr = this.getInliner() != null ? "[" + this.getInliner().getName() + "]" : "";
            String templateDataStr = "(" + this.getTemplateData().getTemplate() + ")";
            return attributeMap.toString() + (this.hasSelectionTarget() ? "<" + this.getSelectionTarget() + ">" : "") + textInliningStr + templateDataStr;
        }

        private static final class SelectionTarget {
            final Object selectionTarget;

            SelectionTarget(Object selectionTarget) {
                this.selectionTarget = selectionTarget;
            }
        }
    }

    private static final class RequestParameterMap
    extends NoOpMapImpl {
        private final IWebExchange webExchange;
        private IWebRequest webRequest;

        RequestParameterMap(IWebExchange webExchange) {
            this.webExchange = webExchange;
        }

        private IWebRequest getRequest() {
            if (this.webRequest == null) {
                this.webRequest = this.webExchange.getRequest();
            }
            return this.webRequest;
        }

        @Override
        public int size() {
            return this.getRequest().getParameterCount();
        }

        @Override
        public boolean isEmpty() {
            return this.getRequest().getParameterCount() == 0;
        }

        @Override
        public boolean containsKey(Object key2) {
            return true;
        }

        @Override
        public boolean containsValue(Object value2) {
            throw new UnsupportedOperationException("Map does not support #containsValue()");
        }

        @Override
        public Object get(Object key2) {
            String[] parameterValues = this.getRequest().getParameterValues(key2 != null ? key2.toString() : null);
            if (parameterValues == null) {
                return null;
            }
            return new RequestParameterValues(parameterValues);
        }

        @Override
        public Set<String> keySet() {
            return this.getRequest().getAllParameterNames();
        }

        @Override
        public Collection<Object> values() {
            return this.getRequest().getParameterMap().values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.getRequest().getParameterMap().entrySet();
        }
    }

    private static final class ApplicationAttributeMap
    extends NoOpMapImpl {
        private final IWebExchange webExchange;
        private IWebApplication webApplication;

        ApplicationAttributeMap(IWebExchange webExchange) {
            this.webExchange = webExchange;
        }

        private IWebApplication getApplication() {
            if (this.webApplication == null) {
                this.webApplication = this.webExchange.getApplication();
            }
            return this.webApplication;
        }

        @Override
        public int size() {
            return this.getApplication().getAttributeCount();
        }

        @Override
        public boolean isEmpty() {
            return this.getApplication().getAttributeCount() == 0;
        }

        @Override
        public boolean containsKey(Object key2) {
            return true;
        }

        @Override
        public boolean containsValue(Object value2) {
            throw new UnsupportedOperationException("Map does not support #containsValue()");
        }

        @Override
        public Object get(Object key2) {
            return WebEngineContext.resolveLazy(this.getApplication().getAttributeValue(key2 != null ? key2.toString() : null));
        }

        @Override
        public Set<String> keySet() {
            return this.getApplication().getAllAttributeNames();
        }

        @Override
        public Collection<Object> values() {
            return this.getApplication().getAttributeMap().values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.getApplication().getAttributeMap().entrySet();
        }
    }

    private static final class SessionAttributeMap
    extends NoOpMapImpl {
        private final IWebExchange webExchange;

        SessionAttributeMap(IWebExchange webExchange) {
            this.webExchange = webExchange;
        }

        private IWebSession getSession() {
            return this.webExchange.getSession();
        }

        @Override
        public int size() {
            IWebSession webSession = this.getSession();
            if (webSession == null) {
                return 0;
            }
            return webSession.getAttributeCount();
        }

        @Override
        public boolean isEmpty() {
            IWebSession webSession = this.getSession();
            if (webSession == null) {
                return true;
            }
            return webSession.getAttributeCount() == 0;
        }

        @Override
        public boolean containsKey(Object key2) {
            return true;
        }

        @Override
        public boolean containsValue(Object value2) {
            throw new UnsupportedOperationException("Map does not support #containsValue()");
        }

        @Override
        public Object get(Object key2) {
            IWebSession webSession = this.getSession();
            if (webSession == null) {
                return null;
            }
            return WebEngineContext.resolveLazy(webSession.getAttributeValue(key2 != null ? key2.toString() : null));
        }

        @Override
        public Set<String> keySet() {
            IWebSession webSession = this.getSession();
            if (webSession == null) {
                return Collections.emptySet();
            }
            return webSession.getAllAttributeNames();
        }

        @Override
        public Collection<Object> values() {
            IWebSession webSession = this.getSession();
            if (webSession == null) {
                return Collections.emptySet();
            }
            return webSession.getAttributeMap().values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            IWebSession webSession = this.getSession();
            if (webSession == null) {
                return Collections.emptySet();
            }
            return webSession.getAttributeMap().entrySet();
        }
    }

    public static final class RequestParameterValues
    extends AbstractList<String> {
        private final String[] parameterValues;
        public final int length;

        RequestParameterValues(String[] parameterValues) {
            this.parameterValues = parameterValues;
            this.length = this.parameterValues.length;
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public Object[] toArray() {
            return (Object[])this.parameterValues.clone();
        }

        @Override
        public <T> T[] toArray(T[] arr) {
            if (arr.length < this.length) {
                Object[] copy2 = (Object[])Array.newInstance(arr.getClass().getComponentType(), this.length);
                System.arraycopy(this.parameterValues, 0, copy2, 0, this.length);
                return copy2;
            }
            System.arraycopy(this.parameterValues, 0, arr, 0, this.length);
            if (arr.length > this.length) {
                arr[this.length] = null;
            }
            return arr;
        }

        @Override
        public String get(int index) {
            return this.parameterValues[index];
        }

        @Override
        public int indexOf(Object obj) {
            String[] a2 = this.parameterValues;
            if (obj == null) {
                for (int i2 = 0; i2 < a2.length; ++i2) {
                    if (a2[i2] != null) continue;
                    return i2;
                }
            } else {
                for (int i3 = 0; i3 < a2.length; ++i3) {
                    if (!obj.equals(a2[i3])) continue;
                    return i3;
                }
            }
            return -1;
        }

        @Override
        public boolean contains(Object obj) {
            return this.indexOf(obj) != -1;
        }

        @Override
        public String toString() {
            if (this.length == 0) {
                return "";
            }
            if (this.length == 1) {
                return this.parameterValues[0];
            }
            return super.toString();
        }
    }

    private static abstract class NoOpMapImpl
    implements Map<String, Object> {
        protected NoOpMapImpl() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key2) {
            return false;
        }

        @Override
        public boolean containsValue(Object value2) {
            return false;
        }

        @Override
        public Object get(Object key2) {
            return null;
        }

        @Override
        public Object put(String key2, Object value2) {
            throw new UnsupportedOperationException("Cannot add new entry: map is immutable");
        }

        @Override
        public Object remove(Object key2) {
            throw new UnsupportedOperationException("Cannot remove entry: map is immutable");
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m4) {
            throw new UnsupportedOperationException("Cannot add new entry: map is immutable");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Cannot clear: map is immutable");
        }

        @Override
        public Set<String> keySet() {
            return Collections.emptySet();
        }

        @Override
        public Collection<Object> values() {
            return Collections.emptyList();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return Collections.emptySet();
        }
    }
}

