/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.io.IOException;
import java.io.Writer;
import org.thymeleaf.engine.AbstractTemplateEvent;
import org.thymeleaf.engine.IEngineTemplateEvent;
import org.thymeleaf.util.IWritableCharSequence;

abstract class AbstractTextualTemplateEvent
extends AbstractTemplateEvent
implements IEngineTemplateEvent {
    private final CharSequence contentCharSeq;
    private final String contentStr;
    private final int contentLength;
    private volatile String computedContentStr = null;
    private volatile int computedContentLength = -1;
    private volatile Boolean computedContentIsWhitespace = null;
    private volatile Boolean computedContentIsInlineable = null;

    AbstractTextualTemplateEvent(CharSequence content2) {
        this.contentCharSeq = content2;
        if (content2 != null && content2 instanceof String) {
            this.contentStr = (String)content2;
            this.contentLength = content2.length();
        } else {
            this.contentStr = null;
            this.contentLength = -1;
        }
    }

    AbstractTextualTemplateEvent(CharSequence content2, String templateName, int line, int col) {
        super(templateName, line, col);
        this.contentCharSeq = content2;
        if (content2 != null && content2 instanceof String) {
            this.contentStr = (String)content2;
            this.contentLength = content2.length();
        } else {
            this.contentStr = null;
            this.contentLength = -1;
        }
    }

    protected final String getContentText() {
        if (this.contentStr != null || this.contentCharSeq == null) {
            return this.contentStr;
        }
        String t2 = this.computedContentStr;
        if (t2 == null) {
            this.computedContentStr = t2 = this.contentCharSeq.toString();
        }
        return t2;
    }

    protected final int getContentLength() {
        if (this.contentLength >= 0 || this.contentCharSeq == null) {
            return this.contentLength;
        }
        int l = this.computedContentLength;
        if (l < 0) {
            this.computedContentLength = l = this.contentCharSeq.length();
        }
        return l;
    }

    protected final char charAtContent(int index) {
        if (this.contentStr != null) {
            return this.contentStr.charAt(index);
        }
        if (this.computedContentStr != null) {
            return this.computedContentStr.charAt(index);
        }
        return this.contentCharSeq.charAt(index);
    }

    protected final CharSequence contentSubSequence(int start2, int end2) {
        if (this.contentStr != null) {
            return this.contentStr.subSequence(start2, end2);
        }
        if (this.computedContentStr != null) {
            return this.computedContentStr.subSequence(start2, end2);
        }
        return this.contentCharSeq.subSequence(start2, end2);
    }

    final boolean isWhitespace() {
        Boolean w = this.computedContentIsWhitespace;
        if (w == null) {
            this.computedContentIsWhitespace = w = this.computeWhitespace();
        }
        return w;
    }

    final boolean isInlineable() {
        Boolean i2 = this.computedContentIsInlineable;
        if (i2 == null) {
            this.computedContentIsInlineable = i2 = this.computeInlineable();
        }
        return i2;
    }

    private Boolean computeWhitespace() {
        int n = this.getContentLength();
        if (n == 0) {
            return Boolean.FALSE;
        }
        while (n-- != 0) {
            char c2 = this.charAtContent(n);
            if (c2 == ' ' || c2 == '\n' || Character.isWhitespace(c2)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean computeInlineable() {
        int n = this.getContentLength();
        if (n == 0) {
            return Boolean.FALSE;
        }
        int c0 = 0;
        int inline = 0;
        while (n-- != 0) {
            char c1 = this.charAtContent(n);
            if (n > 0 && c1 == ']' && c0 == 93) {
                inline = 1;
                c1 = this.charAtContent(--n);
            } else if (n > 0 && c1 == ')' && c0 == 93) {
                inline = 2;
                c1 = this.charAtContent(--n);
            } else {
                if (inline == 1 && c1 == '[' && c0 == 91) {
                    return Boolean.TRUE;
                }
                if (inline == 2 && c1 == '[' && c0 == 40) {
                    return Boolean.TRUE;
                }
            }
            c0 = c1;
        }
        return Boolean.FALSE;
    }

    public final void writeContent(Writer writer) throws IOException {
        if (this.contentStr != null) {
            writer.write(this.contentStr);
        } else if (this.computedContentStr != null) {
            writer.write(this.computedContentStr);
        } else if (this.contentCharSeq instanceof IWritableCharSequence) {
            ((IWritableCharSequence)this.contentCharSeq).write(writer);
        } else {
            writer.write(this.getContentText());
        }
    }

    public String toString() {
        return this.getContentText();
    }
}

