/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.thymeleaf.engine.Attribute;
import org.thymeleaf.engine.AttributeDefinition;
import org.thymeleaf.engine.AttributeDefinitions;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.AttributeNames;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.AttributeValueQuotes;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.FastStringWriter;
import org.thymeleaf.util.Validate;

final class Attributes {
    static final String DEFAULT_WHITE_SPACE = " ";
    static final String[] DEFAULT_WHITE_SPACE_ARRAY = new String[]{" "};
    static final Attributes EMPTY_ATTRIBUTES = new Attributes(null, null);
    static final Attribute[] EMPTY_ATTRIBUTE_ARRAY = new Attribute[0];
    final Attribute[] attributes;
    final String[] innerWhiteSpaces;
    private volatile int associatedProcessorCount = -1;

    Attributes(Attribute[] attributes2, String[] innerWhiteSpaces) {
        this.attributes = attributes2;
        this.innerWhiteSpaces = innerWhiteSpaces;
    }

    int getAssociatedProcessorCount() {
        int c2 = this.associatedProcessorCount;
        if (c2 < 0) {
            this.associatedProcessorCount = c2 = this.computeAssociatedProcessorCount();
        }
        return c2;
    }

    private int computeAssociatedProcessorCount() {
        if (this.attributes == null || this.attributes.length == 0) {
            return 0;
        }
        int count2 = 0;
        int n = this.attributes.length;
        while (n-- != 0) {
            if (!this.attributes[n].definition.hasAssociatedProcessors) continue;
            count2 += this.attributes[n].definition.associatedProcessors.length;
        }
        return count2;
    }

    private int searchAttribute(TemplateMode templateMode, String completeName) {
        if (this.attributes == null || this.attributes.length == 0) {
            return -1;
        }
        int n = this.attributes.length;
        while (n-- != 0) {
            if (!this.attributes[n].completeName.equals(completeName)) continue;
            return n;
        }
        return this.searchAttribute(AttributeNames.forName(templateMode, completeName));
    }

    private int searchAttribute(TemplateMode templateMode, String prefix2, String name) {
        if (this.attributes == null || this.attributes.length == 0) {
            return -1;
        }
        if (prefix2 == null || prefix2.length() == 0) {
            return this.searchAttribute(templateMode, name);
        }
        return this.searchAttribute(AttributeNames.forName(templateMode, prefix2, name));
    }

    private int searchAttribute(AttributeName attributeName) {
        if (this.attributes == null || this.attributes.length == 0) {
            return -1;
        }
        int n = this.attributes.length;
        while (n-- != 0) {
            if (this.attributes[n].definition.attributeName != attributeName) continue;
            return n;
        }
        return -1;
    }

    boolean hasAttribute(TemplateMode templateMode, String completeName) {
        return this.searchAttribute(templateMode, completeName) >= 0;
    }

    boolean hasAttribute(TemplateMode templateMode, String prefix2, String name) {
        return this.searchAttribute(templateMode, prefix2, name) >= 0;
    }

    boolean hasAttribute(AttributeName attributeName) {
        return this.searchAttribute(attributeName) >= 0;
    }

    Attribute getAttribute(TemplateMode templateMode, String completeName) {
        int pos = this.searchAttribute(templateMode, completeName);
        if (pos < 0) {
            return null;
        }
        return this.attributes[pos];
    }

    Attribute getAttribute(TemplateMode templateMode, String prefix2, String name) {
        int pos = this.searchAttribute(templateMode, prefix2, name);
        if (pos < 0) {
            return null;
        }
        return this.attributes[pos];
    }

    Attribute getAttribute(AttributeName attributeName) {
        int pos = this.searchAttribute(attributeName);
        if (pos < 0) {
            return null;
        }
        return this.attributes[pos];
    }

    Attribute[] getAllAttributes() {
        if (this.attributes == null || this.attributes.length == 0) {
            return EMPTY_ATTRIBUTE_ARRAY;
        }
        return (Attribute[])this.attributes.clone();
    }

    Map<String, String> getAttributeMap() {
        if (this.attributes == null || this.attributes.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> attributeMap = new LinkedHashMap<String, String>(this.attributes.length + 5);
        for (int i2 = 0; i2 < this.attributes.length; ++i2) {
            attributeMap.put(this.attributes[i2].completeName, this.attributes[i2].value);
        }
        return attributeMap;
    }

    Attributes setAttribute(AttributeDefinitions attributeDefinitions, TemplateMode templateMode, AttributeDefinition attributeDefinition, String completeName, String value2, AttributeValueQuotes valueQuotes) {
        String[] newInnerWhiteSpaces;
        Attribute[] newAttributes2;
        int existingIdx;
        Validate.isTrue(value2 != null || templateMode != TemplateMode.XML, "Cannot set null-value attributes in XML template mode");
        Validate.isTrue(valueQuotes != AttributeValueQuotes.NONE || templateMode != TemplateMode.XML, "Cannot set unquoted attributes in XML template mode");
        int n = existingIdx = attributeDefinition != null ? this.searchAttribute(attributeDefinition.attributeName) : this.searchAttribute(templateMode, completeName);
        if (existingIdx >= 0) {
            Attribute[] newAttributes3 = (Attribute[])this.attributes.clone();
            newAttributes3[existingIdx] = newAttributes3[existingIdx].modify(null, completeName, value2, valueQuotes);
            return new Attributes(newAttributes3, this.innerWhiteSpaces);
        }
        AttributeDefinition newAttributeDefinition = attributeDefinition != null ? attributeDefinition : attributeDefinitions.forName(templateMode, completeName);
        Attribute newAttribute = new Attribute(newAttributeDefinition, completeName, null, value2, valueQuotes, null, -1, -1);
        if (this.attributes != null) {
            newAttributes2 = new Attribute[this.attributes.length + 1];
            System.arraycopy(this.attributes, 0, newAttributes2, 0, this.attributes.length);
            newAttributes2[this.attributes.length] = newAttribute;
        } else {
            newAttributes2 = new Attribute[]{newAttribute};
        }
        if (this.innerWhiteSpaces != null) {
            newInnerWhiteSpaces = new String[this.innerWhiteSpaces.length + 1];
            System.arraycopy(this.innerWhiteSpaces, 0, newInnerWhiteSpaces, 0, this.innerWhiteSpaces.length);
            if (this.innerWhiteSpaces.length == (this.attributes != null ? this.attributes.length : 0)) {
                newInnerWhiteSpaces[this.innerWhiteSpaces.length] = DEFAULT_WHITE_SPACE;
            } else {
                newInnerWhiteSpaces[this.innerWhiteSpaces.length] = newInnerWhiteSpaces[this.innerWhiteSpaces.length - 1];
                newInnerWhiteSpaces[this.innerWhiteSpaces.length - 1] = DEFAULT_WHITE_SPACE;
            }
        } else {
            newInnerWhiteSpaces = DEFAULT_WHITE_SPACE_ARRAY;
        }
        return new Attributes(newAttributes2, newInnerWhiteSpaces);
    }

    Attributes replaceAttribute(AttributeDefinitions attributeDefinitions, TemplateMode templateMode, AttributeName oldName, AttributeDefinition newAttributeDefinition, String newCompleteName, String value2, AttributeValueQuotes valueQuotes) {
        int existingIdx;
        Validate.isTrue(value2 != null || templateMode != TemplateMode.XML, "Cannot set null-value attributes in XML template mode");
        Validate.isTrue(valueQuotes != AttributeValueQuotes.NONE || templateMode != TemplateMode.XML, "Cannot set unquoted attributes in XML template mode");
        if (this.attributes == null) {
            return this.setAttribute(attributeDefinitions, templateMode, newAttributeDefinition, newCompleteName, value2, valueQuotes);
        }
        int oldIdx = this.searchAttribute(oldName);
        if (oldIdx < 0) {
            return this.setAttribute(attributeDefinitions, templateMode, newAttributeDefinition, newCompleteName, value2, valueQuotes);
        }
        int n = existingIdx = newAttributeDefinition != null ? this.searchAttribute(newAttributeDefinition.attributeName) : this.searchAttribute(templateMode, newCompleteName);
        if (existingIdx >= 0) {
            if (oldIdx == existingIdx) {
                return this.setAttribute(attributeDefinitions, templateMode, newAttributeDefinition, newCompleteName, value2, valueQuotes);
            }
            Attribute[] newAttributes2 = new Attribute[this.attributes.length - 1];
            System.arraycopy(this.attributes, 0, newAttributes2, 0, oldIdx);
            System.arraycopy(this.attributes, oldIdx + 1, newAttributes2, oldIdx, newAttributes2.length - oldIdx);
            int iwIdx = oldIdx + 1;
            if (oldIdx + 1 == this.attributes.length) {
                iwIdx = oldIdx;
            }
            String[] newInnerWhiteSpaces = new String[this.innerWhiteSpaces.length - 1];
            System.arraycopy(this.innerWhiteSpaces, 0, newInnerWhiteSpaces, 0, iwIdx);
            System.arraycopy(this.innerWhiteSpaces, iwIdx + 1, newInnerWhiteSpaces, iwIdx, newInnerWhiteSpaces.length - iwIdx);
            if (existingIdx > oldIdx) {
                --existingIdx;
            }
            newAttributes2[existingIdx] = newAttributes2[existingIdx].modify(null, newCompleteName, value2, valueQuotes);
            return new Attributes(newAttributes2, newInnerWhiteSpaces);
        }
        AttributeDefinition computedNewAttributeDefinition = newAttributeDefinition != null ? newAttributeDefinition : attributeDefinitions.forName(templateMode, newCompleteName);
        Attribute[] newAttributes3 = (Attribute[])this.attributes.clone();
        newAttributes3[oldIdx] = newAttributes3[oldIdx].modify(computedNewAttributeDefinition, newCompleteName, value2, valueQuotes);
        return new Attributes(newAttributes3, this.innerWhiteSpaces);
    }

    Attributes removeAttribute(TemplateMode templateMode, String prefix2, String name) {
        if (this.attributes == null) {
            return this;
        }
        int attrIdx = this.searchAttribute(templateMode, prefix2, name);
        if (attrIdx < 0) {
            return this;
        }
        return this.removeAttribute(attrIdx);
    }

    Attributes removeAttribute(TemplateMode templateMode, String completeName) {
        if (this.attributes == null) {
            return this;
        }
        int attrIdx = this.searchAttribute(templateMode, completeName);
        if (attrIdx < 0) {
            return this;
        }
        return this.removeAttribute(attrIdx);
    }

    Attributes removeAttribute(AttributeName attributeName) {
        if (this.attributes == null) {
            return this;
        }
        int attrIdx = this.searchAttribute(attributeName);
        if (attrIdx < 0) {
            return this;
        }
        return this.removeAttribute(attrIdx);
    }

    private Attributes removeAttribute(int attrIdx) {
        Attribute[] newAttributes2;
        if (this.attributes.length == 1 && this.innerWhiteSpaces.length == 1) {
            return EMPTY_ATTRIBUTES;
        }
        if (this.attributes.length == 1) {
            newAttributes2 = null;
        } else {
            newAttributes2 = new Attribute[this.attributes.length - 1];
            System.arraycopy(this.attributes, 0, newAttributes2, 0, attrIdx);
            System.arraycopy(this.attributes, attrIdx + 1, newAttributes2, attrIdx, newAttributes2.length - attrIdx);
        }
        int iwIdx = attrIdx + 1;
        if (attrIdx + 1 == this.attributes.length) {
            iwIdx = attrIdx;
        }
        String[] newInnerWhiteSpaces = new String[this.innerWhiteSpaces.length - 1];
        System.arraycopy(this.innerWhiteSpaces, 0, newInnerWhiteSpaces, 0, iwIdx);
        System.arraycopy(this.innerWhiteSpaces, iwIdx + 1, newInnerWhiteSpaces, iwIdx, newInnerWhiteSpaces.length - iwIdx);
        return new Attributes(newAttributes2, newInnerWhiteSpaces);
    }

    void write(Writer writer) throws IOException {
        int i2;
        if (this.attributes == null) {
            if (this.innerWhiteSpaces != null) {
                writer.write(this.innerWhiteSpaces[0]);
            }
            return;
        }
        for (i2 = 0; i2 < this.attributes.length; ++i2) {
            writer.write(this.innerWhiteSpaces[i2]);
            this.attributes[i2].write(writer);
        }
        if (i2 < this.innerWhiteSpaces.length) {
            writer.write(this.innerWhiteSpaces[i2]);
        }
    }

    public String toString() {
        FastStringWriter stringWriter = new FastStringWriter();
        try {
            this.write(stringWriter);
        }
        catch (IOException e2) {
            throw new TemplateProcessingException("Exception processing String form of ElementAttributes", e2);
        }
        return ((Object)stringWriter).toString();
    }
}

