/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.io.IOException;
import java.io.Writer;
import org.thymeleaf.engine.AbstractTextualTemplateEvent;
import org.thymeleaf.engine.ITemplateHandler;
import org.thymeleaf.model.ICDATASection;
import org.thymeleaf.model.IModelVisitor;

final class CDATASection
extends AbstractTextualTemplateEvent
implements ICDATASection {
    static final String CDATA_PREFIX = "<![CDATA[";
    static final String CDATA_SUFFIX = "]]>";
    final String prefix;
    final String suffix;
    private volatile String computedCDATASectionStr = null;

    CDATASection(CharSequence content2) {
        this(CDATA_PREFIX, content2, CDATA_SUFFIX);
    }

    CDATASection(String prefix2, CharSequence content2, String suffix) {
        super(content2);
        this.prefix = prefix2;
        this.suffix = suffix;
    }

    CDATASection(CharSequence content2, String templateName, int line, int col) {
        this(CDATA_PREFIX, content2, CDATA_SUFFIX, templateName, line, col);
    }

    CDATASection(String prefix2, CharSequence content2, String suffix, String templateName, int line, int col) {
        super(content2, templateName, line, col);
        this.prefix = prefix2;
        this.suffix = suffix;
    }

    @Override
    public String getCDATASection() {
        String c2 = this.computedCDATASectionStr;
        if (c2 == null) {
            this.computedCDATASectionStr = c2 = this.prefix + this.getContentText() + this.suffix;
        }
        return c2;
    }

    @Override
    public String getContent() {
        return this.getContentText();
    }

    @Override
    public int length() {
        return this.prefix.length() + this.getContentLength() + this.suffix.length();
    }

    @Override
    public char charAt(int index) {
        if (index < this.prefix.length()) {
            return this.prefix.charAt(index);
        }
        int prefixedContentLen = this.prefix.length() + this.getContentLength();
        if (index >= prefixedContentLen) {
            return this.suffix.charAt(index - prefixedContentLen);
        }
        return this.charAtContent(index - this.prefix.length());
    }

    @Override
    public CharSequence subSequence(int start2, int end2) {
        if (start2 >= this.prefix.length() && end2 < this.prefix.length() + this.getContentLength()) {
            return this.contentSubSequence(start2 - this.prefix.length(), end2 - this.prefix.length());
        }
        return this.getCDATASection().subSequence(start2, end2);
    }

    @Override
    public void accept(IModelVisitor visitor2) {
        visitor2.visit(this);
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write(this.prefix);
        this.writeContent(writer);
        writer.write(this.suffix);
    }

    static CDATASection asEngineCDATASection(ICDATASection cdataSection) {
        if (cdataSection instanceof CDATASection) {
            return (CDATASection)cdataSection;
        }
        return new CDATASection(cdataSection.getContent(), cdataSection.getTemplateName(), cdataSection.getLine(), cdataSection.getCol());
    }

    @Override
    public void beHandled(ITemplateHandler handler2) {
        handler2.handleCDATASection(this);
    }

    @Override
    public String toString() {
        return this.getCDATASection();
    }
}

