/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.io.IOException;
import java.io.Writer;
import org.thymeleaf.engine.AbstractTextualTemplateEvent;
import org.thymeleaf.engine.ITemplateHandler;
import org.thymeleaf.model.IComment;
import org.thymeleaf.model.IModelVisitor;

final class Comment
extends AbstractTextualTemplateEvent
implements IComment {
    private static final String COMMENT_PREFIX = "<!--";
    private static final String COMMENT_SUFFIX = "-->";
    final String prefix;
    final String suffix;
    private volatile String computedCommentStr = null;

    Comment(CharSequence content2) {
        this(COMMENT_PREFIX, content2, COMMENT_SUFFIX);
    }

    Comment(String prefix2, CharSequence content2, String suffix) {
        super(content2);
        this.prefix = prefix2;
        this.suffix = suffix;
    }

    Comment(CharSequence content2, String templateName, int line, int col) {
        this(COMMENT_PREFIX, content2, COMMENT_SUFFIX, templateName, line, col);
    }

    Comment(String prefix2, CharSequence content2, String suffix, String templateName, int line, int col) {
        super(content2, templateName, line, col);
        this.prefix = prefix2;
        this.suffix = suffix;
    }

    @Override
    public String getComment() {
        String c2 = this.computedCommentStr;
        if (c2 == null) {
            this.computedCommentStr = c2 = this.prefix + this.getContentText() + this.suffix;
        }
        return c2;
    }

    @Override
    public String getContent() {
        return this.getContentText();
    }

    @Override
    public int length() {
        return this.prefix.length() + this.getContentLength() + this.suffix.length();
    }

    @Override
    public char charAt(int index) {
        if (index < this.prefix.length()) {
            return this.prefix.charAt(index);
        }
        int prefixedContentLen = this.prefix.length() + this.getContentLength();
        if (index >= prefixedContentLen) {
            return this.suffix.charAt(index - prefixedContentLen);
        }
        return this.charAtContent(index - this.prefix.length());
    }

    @Override
    public CharSequence subSequence(int start2, int end2) {
        if (start2 >= this.prefix.length() && end2 < this.prefix.length() + this.getContentLength()) {
            return this.contentSubSequence(start2 - this.prefix.length(), end2 - this.prefix.length());
        }
        return this.getComment().subSequence(start2, end2);
    }

    @Override
    public void accept(IModelVisitor visitor2) {
        visitor2.visit(this);
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write(this.prefix);
        this.writeContent(writer);
        writer.write(this.suffix);
    }

    static Comment asEngineComment(IComment comment) {
        if (comment instanceof Comment) {
            return (Comment)comment;
        }
        return new Comment(comment.getContent(), comment.getTemplateName(), comment.getLine(), comment.getCol());
    }

    @Override
    public void beHandled(ITemplateHandler handler2) {
        handler2.handleComment(this);
    }

    @Override
    public String toString() {
        return this.getComment();
    }
}

