/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.thymeleaf.engine.ISSEThrottledTemplateWriterControl;
import org.thymeleaf.engine.IThrottledTemplateWriterControl;
import org.thymeleaf.exceptions.TemplateProcessingException;

public final class DataDrivenTemplateIterator
implements Iterator<Object> {
    private static final char[] SSE_HEAD_EVENT_NAME = "head".toCharArray();
    private static final char[] SSE_MESSAGE_EVENT_NAME = "message".toCharArray();
    private static final char[] SSE_TAIL_EVENT_NAME = "tail".toCharArray();
    private final List<Object> values = new ArrayList<Object>(10);
    private IThrottledTemplateWriterControl writerControl = null;
    private ISSEThrottledTemplateWriterControl sseControl = null;
    private char[] sseEventsPrefix = null;
    private char[] sseEventsComposedMessageEventName = null;
    private long sseEventsID = 0L;
    private boolean inStep = false;
    private boolean feedingComplete = false;
    private boolean queried = false;

    public void setWriterControl(IThrottledTemplateWriterControl writerControl) {
        this.writerControl = writerControl;
        this.sseControl = writerControl instanceof ISSEThrottledTemplateWriterControl ? (ISSEThrottledTemplateWriterControl)this.writerControl : null;
    }

    public void setSseEventsPrefix(String sseEventsPrefix) {
        this.sseEventsPrefix = sseEventsPrefix == null || sseEventsPrefix.length() == 0 ? null : sseEventsPrefix.toCharArray();
        this.sseEventsComposedMessageEventName = this.composeToken(SSE_MESSAGE_EVENT_NAME);
    }

    public void setSseEventsFirstID(long sseEventsFirstID) {
        this.sseEventsID = sseEventsFirstID;
    }

    public void takeBackLastEventID() {
        if (this.sseEventsID > 0L) {
            --this.sseEventsID;
        }
    }

    @Override
    public boolean hasNext() {
        this.queried = true;
        return !this.values.isEmpty();
    }

    @Override
    public Object next() {
        this.queried = true;
        if (this.values.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object value2 = this.values.get(0);
        this.values.remove(0);
        return value2;
    }

    public void startIteration() {
        this.inStep = true;
        if (this.sseControl != null) {
            char[] id = this.composeToken(Long.toString(this.sseEventsID).toCharArray());
            char[] event = this.sseEventsComposedMessageEventName;
            this.sseControl.startEvent(id, event);
            ++this.sseEventsID;
        }
    }

    public void finishIteration() {
        this.finishStep();
    }

    public boolean hasBeenQueried() {
        return this.queried;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported in Throttled Iterator");
    }

    boolean isPaused() {
        this.queried = true;
        return this.values.isEmpty() && !this.feedingComplete;
    }

    public boolean continueBufferExecution() {
        return !this.values.isEmpty();
    }

    public void feedBuffer(List<Object> newElements) {
        this.values.addAll(newElements);
    }

    public void startHead() {
        this.inStep = true;
        if (this.sseControl != null) {
            char[] id = this.composeToken(Long.toString(this.sseEventsID).toCharArray());
            char[] event = this.composeToken(SSE_HEAD_EVENT_NAME);
            this.sseControl.startEvent(id, event);
            ++this.sseEventsID;
        }
    }

    public void feedingComplete() {
        this.feedingComplete = true;
    }

    public void startTail() {
        this.inStep = true;
        if (this.sseControl != null) {
            char[] id = this.composeToken(Long.toString(this.sseEventsID).toCharArray());
            char[] event = this.composeToken(SSE_TAIL_EVENT_NAME);
            this.sseControl.startEvent(id, event);
            ++this.sseEventsID;
        }
    }

    public void finishStep() {
        if (!this.inStep) {
            return;
        }
        this.inStep = false;
        if (this.sseControl != null) {
            try {
                this.sseControl.endEvent();
            }
            catch (IOException e2) {
                throw new TemplateProcessingException("Cannot signal end of SSE event", e2);
            }
        }
    }

    public boolean isStepOutputFinished() {
        if (this.inStep) {
            return false;
        }
        if (this.writerControl != null) {
            try {
                return !this.writerControl.isOverflown();
            }
            catch (IOException e2) {
                throw new TemplateProcessingException("Cannot signal end of SSE event", e2);
            }
        }
        return true;
    }

    private char[] composeToken(char[] token2) {
        if (this.sseEventsPrefix == null) {
            return token2;
        }
        char[] result2 = new char[this.sseEventsPrefix.length + 1 + token2.length];
        System.arraycopy(this.sseEventsPrefix, 0, result2, 0, this.sseEventsPrefix.length);
        result2[this.sseEventsPrefix.length] = 95;
        System.arraycopy(token2, 0, result2, this.sseEventsPrefix.length + 1, token2.length);
        return result2;
    }
}

