/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.io.Writer;
import org.thymeleaf.engine.AbstractTemplateHandler;
import org.thymeleaf.exceptions.TemplateOutputException;
import org.thymeleaf.model.ICDATASection;
import org.thymeleaf.model.ICloseElementTag;
import org.thymeleaf.model.IComment;
import org.thymeleaf.model.IDocType;
import org.thymeleaf.model.IOpenElementTag;
import org.thymeleaf.model.IProcessingInstruction;
import org.thymeleaf.model.IStandaloneElementTag;
import org.thymeleaf.model.IText;
import org.thymeleaf.model.IXMLDeclaration;

public final class OutputTemplateHandler
extends AbstractTemplateHandler {
    private final Writer writer;

    public OutputTemplateHandler(Writer writer) {
        if (writer == null) {
            throw new IllegalArgumentException("Writer cannot be null");
        }
        this.writer = writer;
    }

    @Override
    public void handleText(IText text) {
        try {
            text.write(this.writer);
        }
        catch (Exception e2) {
            throw new TemplateOutputException("An error happened during template rendering", text.getTemplateName(), text.getLine(), text.getCol(), e2);
        }
        super.handleText(text);
    }

    @Override
    public void handleComment(IComment comment) {
        try {
            comment.write(this.writer);
        }
        catch (Exception e2) {
            throw new TemplateOutputException("An error happened during template rendering", comment.getTemplateName(), comment.getLine(), comment.getCol(), e2);
        }
        super.handleComment(comment);
    }

    @Override
    public void handleCDATASection(ICDATASection cdataSection) {
        try {
            cdataSection.write(this.writer);
        }
        catch (Exception e2) {
            throw new TemplateOutputException("An error happened during template rendering", cdataSection.getTemplateName(), cdataSection.getLine(), cdataSection.getCol(), e2);
        }
        super.handleCDATASection(cdataSection);
    }

    @Override
    public void handleStandaloneElement(IStandaloneElementTag standaloneElementTag) {
        try {
            standaloneElementTag.write(this.writer);
        }
        catch (Exception e2) {
            throw new TemplateOutputException("An error happened during template rendering", standaloneElementTag.getTemplateName(), standaloneElementTag.getLine(), standaloneElementTag.getCol(), e2);
        }
        super.handleStandaloneElement(standaloneElementTag);
    }

    @Override
    public void handleOpenElement(IOpenElementTag openElementTag) {
        try {
            openElementTag.write(this.writer);
        }
        catch (Exception e2) {
            throw new TemplateOutputException("An error happened during template rendering", openElementTag.getTemplateName(), openElementTag.getLine(), openElementTag.getCol(), e2);
        }
        super.handleOpenElement(openElementTag);
    }

    @Override
    public void handleCloseElement(ICloseElementTag closeElementTag) {
        try {
            closeElementTag.write(this.writer);
        }
        catch (Exception e2) {
            throw new TemplateOutputException("An error happened during template rendering", closeElementTag.getTemplateName(), closeElementTag.getLine(), closeElementTag.getCol(), e2);
        }
        super.handleCloseElement(closeElementTag);
    }

    @Override
    public void handleDocType(IDocType docType) {
        try {
            docType.write(this.writer);
        }
        catch (Exception e2) {
            throw new TemplateOutputException("An error happened during template rendering", docType.getTemplateName(), docType.getLine(), docType.getCol(), e2);
        }
        super.handleDocType(docType);
    }

    @Override
    public void handleXMLDeclaration(IXMLDeclaration xmlDeclaration) {
        try {
            xmlDeclaration.write(this.writer);
        }
        catch (Exception e2) {
            throw new TemplateOutputException("An error happened during template rendering", xmlDeclaration.getTemplateName(), xmlDeclaration.getLine(), xmlDeclaration.getCol(), e2);
        }
        super.handleXMLDeclaration(xmlDeclaration);
    }

    @Override
    public void handleProcessingInstruction(IProcessingInstruction processingInstruction) {
        try {
            processingInstruction.write(this.writer);
        }
        catch (Exception e2) {
            throw new TemplateOutputException("An error happened during template rendering", processingInstruction.getTemplateName(), processingInstruction.getLine(), processingInstruction.getCol(), e2);
        }
        super.handleProcessingInstruction(processingInstruction);
    }
}

