/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.thymeleaf.engine.AbstractProcessableElementTag;
import org.thymeleaf.engine.Attribute;
import org.thymeleaf.engine.AttributeDefinition;
import org.thymeleaf.engine.AttributeDefinitions;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.Attributes;
import org.thymeleaf.engine.ElementDefinition;
import org.thymeleaf.engine.IEngineTemplateEvent;
import org.thymeleaf.engine.ITemplateHandler;
import org.thymeleaf.model.AttributeValueQuotes;
import org.thymeleaf.model.IAttribute;
import org.thymeleaf.model.IModelVisitor;
import org.thymeleaf.model.IStandaloneElementTag;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.Validate;

final class StandaloneElementTag
extends AbstractProcessableElementTag
implements IStandaloneElementTag,
IEngineTemplateEvent {
    final boolean minimized;

    StandaloneElementTag(TemplateMode templateMode, ElementDefinition elementDefinition, String elementCompleteName, Attributes attributes2, boolean synthetic, boolean minimized) {
        super(templateMode, elementDefinition, elementCompleteName, attributes2, synthetic);
        Validate.isTrue(minimized || templateMode == TemplateMode.HTML, "Not-minimized standalone elements are only allowed in HTML template mode (is " + (Object)((Object)templateMode) + ")");
        this.minimized = minimized;
    }

    StandaloneElementTag(TemplateMode templateMode, ElementDefinition elementDefinition, String elementCompleteName, Attributes attributes2, boolean synthetic, boolean minimized, String templateName, int line, int col) {
        super(templateMode, elementDefinition, elementCompleteName, attributes2, synthetic, templateName, line, col);
        Validate.isTrue(minimized || templateMode == TemplateMode.HTML, "Not-minimized standalone elements are only allowed in HTML template mode (is " + (Object)((Object)templateMode) + ")");
        this.minimized = minimized;
    }

    @Override
    public boolean isMinimized() {
        return this.minimized;
    }

    @Override
    StandaloneElementTag setAttribute(AttributeDefinitions attributeDefinitions, AttributeDefinition attributeDefinition, String completeName, String value2, AttributeValueQuotes valueQuotes) {
        Attributes oldAttributes = this.attributes != null ? this.attributes : Attributes.EMPTY_ATTRIBUTES;
        Attributes newAttributes2 = oldAttributes.setAttribute(attributeDefinitions, this.templateMode, attributeDefinition, completeName, value2, valueQuotes);
        return new StandaloneElementTag(this.templateMode, this.elementDefinition, this.elementCompleteName, newAttributes2, this.synthetic, this.minimized, this.templateName, this.line, this.col);
    }

    @Override
    StandaloneElementTag replaceAttribute(AttributeDefinitions attributeDefinitions, AttributeName oldName, AttributeDefinition newAttributeDefinition, String completeNewName, String value2, AttributeValueQuotes valueQuotes) {
        Attributes oldAttributes = this.attributes != null ? this.attributes : Attributes.EMPTY_ATTRIBUTES;
        Attributes newAttributes2 = oldAttributes.replaceAttribute(attributeDefinitions, this.templateMode, oldName, newAttributeDefinition, completeNewName, value2, valueQuotes);
        return new StandaloneElementTag(this.templateMode, this.elementDefinition, this.elementCompleteName, newAttributes2, this.synthetic, this.minimized, this.templateName, this.line, this.col);
    }

    @Override
    StandaloneElementTag removeAttribute(String prefix2, String name) {
        Attributes newAttributes2;
        Attributes oldAttributes = this.attributes != null ? this.attributes : Attributes.EMPTY_ATTRIBUTES;
        if (oldAttributes == (newAttributes2 = oldAttributes.removeAttribute(this.templateMode, prefix2, name))) {
            return this;
        }
        return new StandaloneElementTag(this.templateMode, this.elementDefinition, this.elementCompleteName, newAttributes2, this.synthetic, this.minimized, this.templateName, this.line, this.col);
    }

    @Override
    StandaloneElementTag removeAttribute(String completeName) {
        Attributes newAttributes2;
        Attributes oldAttributes = this.attributes != null ? this.attributes : Attributes.EMPTY_ATTRIBUTES;
        if (oldAttributes == (newAttributes2 = oldAttributes.removeAttribute(this.templateMode, completeName))) {
            return this;
        }
        return new StandaloneElementTag(this.templateMode, this.elementDefinition, this.elementCompleteName, newAttributes2, this.synthetic, this.minimized, this.templateName, this.line, this.col);
    }

    @Override
    StandaloneElementTag removeAttribute(AttributeName attributeName) {
        Attributes newAttributes2;
        Attributes oldAttributes = this.attributes != null ? this.attributes : Attributes.EMPTY_ATTRIBUTES;
        if (oldAttributes == (newAttributes2 = oldAttributes.removeAttribute(attributeName))) {
            return this;
        }
        return new StandaloneElementTag(this.templateMode, this.elementDefinition, this.elementCompleteName, newAttributes2, this.synthetic, this.minimized, this.templateName, this.line, this.col);
    }

    @Override
    public void accept(IModelVisitor visitor2) {
        visitor2.visit(this);
    }

    @Override
    public void write(Writer writer) throws IOException {
        if (this.synthetic) {
            return;
        }
        if (this.templateMode.isText()) {
            writer.write("[#");
            writer.write(this.elementCompleteName);
            if (this.attributes != null) {
                this.attributes.write(writer);
            }
            if (this.minimized) {
                writer.write("/]");
            } else {
                writer.write("]");
            }
            return;
        }
        writer.write(60);
        writer.write(this.elementCompleteName);
        if (this.attributes != null) {
            this.attributes.write(writer);
        }
        if (this.minimized) {
            writer.write("/>");
        } else {
            writer.write(62);
        }
    }

    static StandaloneElementTag asEngineStandaloneElementTag(IStandaloneElementTag standaloneElementTag) {
        Attributes attributes2;
        if (standaloneElementTag instanceof StandaloneElementTag) {
            return (StandaloneElementTag)standaloneElementTag;
        }
        IAttribute[] originalAttributeArray = standaloneElementTag.getAllAttributes();
        if (originalAttributeArray == null || originalAttributeArray.length == 0) {
            attributes2 = null;
        } else {
            Object[] newInnerWhiteSpaces;
            Attribute[] newAttributeArray = new Attribute[originalAttributeArray.length];
            for (int i2 = 0; i2 < originalAttributeArray.length; ++i2) {
                IAttribute originalAttribute = originalAttributeArray[i2];
                newAttributeArray[i2] = new Attribute(originalAttribute.getAttributeDefinition(), originalAttribute.getAttributeCompleteName(), originalAttribute.getOperator(), originalAttribute.getValue(), originalAttribute.getValueQuotes(), originalAttribute.getTemplateName(), originalAttribute.getLine(), originalAttribute.getCol());
            }
            if (newAttributeArray.length == 1) {
                newInnerWhiteSpaces = Attributes.DEFAULT_WHITE_SPACE_ARRAY;
            } else {
                newInnerWhiteSpaces = new String[newAttributeArray.length];
                Arrays.fill(newInnerWhiteSpaces, " ");
            }
            attributes2 = new Attributes(newAttributeArray, (String[])newInnerWhiteSpaces);
        }
        return new StandaloneElementTag(standaloneElementTag.getTemplateMode(), standaloneElementTag.getElementDefinition(), standaloneElementTag.getElementCompleteName(), attributes2, standaloneElementTag.isSynthetic(), standaloneElementTag.isMinimized(), standaloneElementTag.getTemplateName(), standaloneElementTag.getLine(), standaloneElementTag.getCol());
    }

    @Override
    public void beHandled(ITemplateHandler handler2) {
        handler2.handleStandaloneElement(this);
    }
}

