/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.inline.IInliner;
import org.thymeleaf.model.IModel;
import org.thymeleaf.processor.templateboundaries.ITemplateBoundariesStructureHandler;
import org.thymeleaf.util.Validate;

public final class TemplateBoundariesStructureHandler
implements ITemplateBoundariesStructureHandler {
    boolean insertText;
    String insertTextValue;
    boolean insertTextProcessable;
    boolean insertModel;
    IModel insertModelValue;
    boolean insertModelProcessable;
    boolean setLocalVariable;
    Map<String, Object> addedLocalVariables;
    boolean removeLocalVariable;
    Set<String> removedLocalVariableNames;
    boolean setSelectionTarget;
    Object selectionTargetObject;
    boolean setInliner;
    IInliner setInlinerValue;

    TemplateBoundariesStructureHandler() {
        this.reset();
    }

    @Override
    public void insert(String text, boolean processable) {
        this.resetAllButLocalVariables();
        Validate.notNull(text, "Text cannot be null");
        this.insertText = true;
        this.insertTextValue = text;
        this.insertTextProcessable = processable;
    }

    @Override
    public void insert(IModel model, boolean processable) {
        this.resetAllButLocalVariables();
        Validate.notNull(model, "Model cannot be null");
        this.insertModel = true;
        this.insertModelValue = model;
        this.insertModelProcessable = processable;
    }

    @Override
    public void removeLocalVariable(String name) {
        this.removeLocalVariable = true;
        if (this.removedLocalVariableNames == null) {
            this.removedLocalVariableNames = new HashSet<String>(3);
        }
        this.removedLocalVariableNames.add(name);
    }

    @Override
    public void setLocalVariable(String name, Object value2) {
        this.setLocalVariable = true;
        if (this.addedLocalVariables == null) {
            this.addedLocalVariables = new HashMap<String, Object>(3);
        }
        this.addedLocalVariables.put(name, value2);
    }

    @Override
    public void setSelectionTarget(Object selectionTarget) {
        this.setSelectionTarget = true;
        this.selectionTargetObject = selectionTarget;
    }

    @Override
    public void setInliner(IInliner inliner) {
        this.setInliner = true;
        this.setInlinerValue = inliner;
    }

    @Override
    public void reset() {
        this.resetAllButLocalVariables();
        this.setLocalVariable = false;
        if (this.addedLocalVariables != null) {
            this.addedLocalVariables.clear();
        }
        this.removeLocalVariable = false;
        if (this.removedLocalVariableNames != null) {
            this.removedLocalVariableNames.clear();
        }
        this.setSelectionTarget = false;
        this.selectionTargetObject = null;
        this.setInliner = false;
        this.setInlinerValue = null;
    }

    private void resetAllButLocalVariables() {
        this.insertText = false;
        this.insertTextValue = null;
        this.insertTextProcessable = false;
        this.insertModel = false;
        this.insertModelValue = null;
        this.insertModelProcessable = false;
    }

    void applyContextModifications(IEngineContext engineContext) {
        if (this.setLocalVariable) {
            engineContext.setVariables(this.addedLocalVariables);
        }
        if (this.removeLocalVariable) {
            for (String variableName : this.removedLocalVariableNames) {
                engineContext.removeVariable(variableName);
            }
        }
        if (this.setSelectionTarget) {
            engineContext.setSelectionTarget(this.selectionTargetObject);
        }
        if (this.setInliner) {
            engineContext.setInliner(this.setInlinerValue);
        }
    }
}

