/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.io.IOException;
import java.io.Writer;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.engine.IEngineTemplateEvent;
import org.thymeleaf.engine.ITemplateHandler;
import org.thymeleaf.engine.Model;
import org.thymeleaf.engine.TemplateData;
import org.thymeleaf.engine.TemplateEnd;
import org.thymeleaf.engine.TemplateFlowController;
import org.thymeleaf.engine.TemplateStart;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelVisitor;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.FastStringWriter;
import org.thymeleaf.util.Validate;

public final class TemplateModel
implements IModel {
    final IEngineConfiguration configuration;
    final TemplateData templateData;
    final IEngineTemplateEvent[] queue;

    TemplateModel(IEngineConfiguration configuration, TemplateData templateData, IEngineTemplateEvent[] queue) {
        Validate.notNull(configuration, "Engine Configuration cannot be null");
        Validate.notNull(templateData, "Template Resolution cannot be null");
        Validate.notNull(queue, "Event queue cannot be null");
        Validate.isTrue(queue.length >= 2, "At least TemplateStart/TemplateEnd events must be added to a TemplateModel");
        Validate.isTrue(queue[0] == TemplateStart.TEMPLATE_START_INSTANCE, "First event in queue is not TemplateStart");
        Validate.isTrue(queue[queue.length - 1] == TemplateEnd.TEMPLATE_END_INSTANCE, "Last event in queue is not TemplateEnd");
        this.configuration = configuration;
        this.templateData = templateData;
        this.queue = queue;
    }

    public final TemplateData getTemplateData() {
        return this.templateData;
    }

    @Override
    public final IEngineConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public final TemplateMode getTemplateMode() {
        return this.templateData.getTemplateMode();
    }

    @Override
    public final int size() {
        return this.queue.length;
    }

    @Override
    public final ITemplateEvent get(int pos) {
        return this.queue[pos];
    }

    @Override
    public final void add(ITemplateEvent event) {
        TemplateModel.immutableModelException();
    }

    @Override
    public final void insert(int pos, ITemplateEvent event) {
        TemplateModel.immutableModelException();
    }

    @Override
    public final void replace(int pos, ITemplateEvent event) {
        TemplateModel.immutableModelException();
    }

    @Override
    public final void addModel(IModel model) {
        TemplateModel.immutableModelException();
    }

    @Override
    public final void insertModel(int pos, IModel model) {
        TemplateModel.immutableModelException();
    }

    @Override
    public final void remove(int pos) {
        TemplateModel.immutableModelException();
    }

    @Override
    public final void reset() {
        TemplateModel.immutableModelException();
    }

    void process(ITemplateHandler handler2) {
        for (int i2 = 0; i2 < this.queue.length; ++i2) {
            this.queue[i2].beHandled(handler2);
        }
    }

    int process(ITemplateHandler handler2, int offset, TemplateFlowController controller) {
        if (controller == null) {
            this.process(handler2);
            return this.queue.length;
        }
        if (this.queue.length == 0 || offset >= this.queue.length) {
            return 0;
        }
        int processed = 0;
        for (int i2 = offset; i2 < this.queue.length && !controller.stopProcessing; ++i2) {
            this.queue[i2].beHandled(handler2);
            ++processed;
        }
        return processed;
    }

    @Override
    public final IModel cloneModel() {
        return new Model(this);
    }

    @Override
    public final void write(Writer writer) throws IOException {
        for (int i2 = 0; i2 < this.queue.length; ++i2) {
            this.queue[i2].write(writer);
        }
    }

    @Override
    public void accept(IModelVisitor visitor2) {
        for (int i2 = 0; i2 < this.queue.length; ++i2) {
            this.queue[i2].accept(visitor2);
        }
    }

    public final String toString() {
        try {
            FastStringWriter writer = new FastStringWriter();
            this.write(writer);
            return ((Object)writer).toString();
        }
        catch (IOException e2) {
            throw new TemplateProcessingException("Error while creating String representation of model");
        }
    }

    private static void immutableModelException() {
        throw new UnsupportedOperationException("Modifications are not allowed on immutable model objects. This model object is an immutable implementation of the " + IModel.class.getName() + " interface, and no modifications are allowed in order to keep cache consistency and improve performance. To modify model events, convert first your immutable model object to a mutable one by means of the " + IModel.class.getName() + "#cloneModel() method");
    }
}

