/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.IThrottledTemplateProcessor;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.TemplateSpec;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.engine.EngineContextManager;
import org.thymeleaf.engine.ITemplateHandler;
import org.thymeleaf.engine.IThrottledTemplateWriterControl;
import org.thymeleaf.engine.ProcessorTemplateHandler;
import org.thymeleaf.engine.TemplateFlowController;
import org.thymeleaf.engine.TemplateModel;
import org.thymeleaf.engine.ThrottledTemplateWriter;
import org.thymeleaf.exceptions.TemplateEngineException;
import org.thymeleaf.exceptions.TemplateOutputException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.util.LoggingUtils;

public final class ThrottledTemplateProcessor
implements IThrottledTemplateProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TemplateEngine.class);
    private static final Logger timerLogger = LoggerFactory.getLogger(TemplateEngine.TIMER_LOGGER_NAME);
    private static final int NANOS_IN_SECOND = 1000000;
    private static final String OUTPUT_TYPE_CHARS = "chars";
    private static final String OUTPUT_TYPE_BYTES = "bytes";
    private static final AtomicLong identifierGenerator = new AtomicLong(0L);
    private final String identifier = Long.toString(identifierGenerator.getAndIncrement());
    private final TemplateSpec templateSpec;
    private final IEngineContext context;
    private final TemplateModel templateModel;
    private final ITemplateHandler templateHandler;
    private final ProcessorTemplateHandler processorTemplateHandler;
    private final TemplateFlowController flowController;
    private final ThrottledTemplateWriter writer;
    private int offset;
    private boolean eventProcessingFinished;
    private volatile boolean allProcessingFinished;

    ThrottledTemplateProcessor(TemplateSpec templateSpec, IEngineContext context, TemplateModel templateModel, ITemplateHandler templateHandler, ProcessorTemplateHandler processorTemplateHandler, TemplateFlowController flowController, ThrottledTemplateWriter writer) {
        this.templateSpec = templateSpec;
        this.context = context;
        this.templateModel = templateModel;
        this.templateHandler = templateHandler;
        this.processorTemplateHandler = processorTemplateHandler;
        this.flowController = flowController;
        this.writer = writer;
        this.offset = 0;
        this.eventProcessingFinished = false;
        this.allProcessingFinished = false;
    }

    public IThrottledTemplateWriterControl getThrottledTemplateWriterControl() {
        return this.writer;
    }

    @Override
    public boolean isFinished() {
        return this.allProcessingFinished;
    }

    private boolean computeFinish() throws IOException {
        boolean finished;
        if (this.allProcessingFinished) {
            return true;
        }
        boolean bl = finished = this.eventProcessingFinished && !this.flowController.processorTemplateHandlerPending && !this.writer.isOverflown();
        if (finished) {
            this.allProcessingFinished = finished;
        }
        return finished;
    }

    private void reportFinish(String outputType) {
        if (this.allProcessingFinished && logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Finished throttled processing of template \"{}\" with locale {}. Maximum overflow was {} {} (overflow buffer grown {} times).", TemplateEngine.threadIndex(), this.templateSpec, this.context.getLocale(), this.writer.getMaxOverflowSize(), outputType, this.writer.getOverflowGrowCount());
        }
    }

    @Override
    public String getProcessorIdentifier() {
        return this.identifier;
    }

    @Override
    public TemplateSpec getTemplateSpec() {
        return this.templateSpec;
    }

    @Override
    public int processAll(Writer writer) {
        this.writer.setOutput(writer);
        return this.process(Integer.MAX_VALUE, OUTPUT_TYPE_CHARS);
    }

    @Override
    public int processAll(OutputStream outputStream2, Charset charset) {
        this.writer.setOutput(outputStream2, charset, Integer.MAX_VALUE);
        return this.process(Integer.MAX_VALUE, OUTPUT_TYPE_BYTES);
    }

    @Override
    public int process(int maxOutputInChars, Writer writer) {
        this.writer.setOutput(writer);
        return this.process(maxOutputInChars, OUTPUT_TYPE_CHARS);
    }

    @Override
    public int process(int maxOutputInBytes, OutputStream outputStream2, Charset charset) {
        this.writer.setOutput(outputStream2, charset, maxOutputInBytes);
        return this.process(maxOutputInBytes, OUTPUT_TYPE_BYTES);
    }

    private int process(int maxOutput, String outputType) {
        int writtenCount = 0;
        try {
            if (this.allProcessingFinished || maxOutput == 0) {
                return 0;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] Starting throttled process (limit:{} {}) of template \"{}\" with locale {}", TemplateEngine.threadIndex(), maxOutput, outputType, this.templateSpec, this.context.getLocale());
            }
            long startNanos = System.nanoTime();
            int initialWrittenCount = this.writer.getWrittenCount();
            this.writer.allow(maxOutput);
            if (!this.computeFinish() && !this.writer.isStopped()) {
                if (this.flowController.processorTemplateHandlerPending) {
                    this.processorTemplateHandler.handlePending();
                }
                if (!this.computeFinish() && !this.writer.isStopped()) {
                    this.offset += this.templateModel.process(this.templateHandler, this.offset, this.flowController);
                    if (this.offset == this.templateModel.size()) {
                        EngineContextManager.disposeEngineContext(this.context);
                        this.eventProcessingFinished = true;
                        this.computeFinish();
                    }
                }
            }
            long endNanos = System.nanoTime();
            try {
                this.writer.flush();
            }
            catch (IOException e2) {
                throw new TemplateOutputException("An error happened while flushing output writer", this.templateSpec.getTemplate(), -1, -1, e2);
            }
            writtenCount = this.writer.getWrittenCount() - initialWrittenCount;
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] Finished throttled process (limit:{} {}, output: {} {}) of template \"{}\" with locale {}", TemplateEngine.threadIndex(), maxOutput, outputType, writtenCount, outputType, this.templateSpec, this.context.getLocale());
            }
            if (timerLogger.isTraceEnabled()) {
                BigDecimal elapsed = BigDecimal.valueOf(endNanos - startNanos);
                BigDecimal elapsedMs = elapsed.divide(BigDecimal.valueOf(1000000L), RoundingMode.HALF_UP);
                timerLogger.trace("[THYMELEAF][{}][{}][{}][{}][{}] TEMPLATE \"{}\" WITH LOCALE {} PROCESSED (THROTTLED, LIMIT:{} {}, OUTPUT: {} {}) IN {} nanoseconds (approx. {}ms)", TemplateEngine.threadIndex(), LoggingUtils.loggifyTemplateName(this.templateSpec.getTemplate()), this.context.getLocale(), elapsed, elapsedMs, this.templateSpec, this.context.getLocale(), maxOutput, outputType, writtenCount, outputType, elapsed, elapsedMs);
            }
        }
        catch (TemplateOutputException e3) {
            this.eventProcessingFinished = true;
            this.allProcessingFinished = true;
            logger.error(String.format("[THYMELEAF][%s] Exception processing throttled template \"%s\": %s", TemplateEngine.threadIndex(), this.templateSpec, e3.getMessage()), e3);
            throw e3;
        }
        catch (TemplateEngineException e4) {
            this.eventProcessingFinished = true;
            this.allProcessingFinished = true;
            logger.error(String.format("[THYMELEAF][%s] Exception processing throttled template \"%s\": %s", TemplateEngine.threadIndex(), this.templateSpec, e4.getMessage()), e4);
            throw e4;
        }
        catch (Exception e5) {
            this.eventProcessingFinished = true;
            this.allProcessingFinished = true;
            logger.error(String.format("[THYMELEAF][%s] Exception processing throttled template \"%s\": %s", TemplateEngine.threadIndex(), this.templateSpec, e5.getMessage()), e5);
            throw new TemplateProcessingException("Exception processing throttled template", this.templateSpec.toString(), e5);
        }
        this.reportFinish(outputType);
        return writtenCount;
    }
}

