/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.thymeleaf.engine.TemplateFlowController;
import org.thymeleaf.engine.ThrottledTemplateWriter;
import org.thymeleaf.exceptions.TemplateOutputException;

final class ThrottledTemplateWriterOutputStreamAdapter
extends OutputStream
implements ThrottledTemplateWriter.IThrottledTemplateWriterAdapter {
    private final String templateName;
    private final TemplateFlowController flowController;
    private final int overflowIncrementInBytes;
    private OutputStream os;
    private byte[] overflow;
    private int overflowSize;
    private int maxOverflowSize;
    private int overflowGrowCount;
    private boolean unlimited;
    private int limit;
    private int writtenCount;

    ThrottledTemplateWriterOutputStreamAdapter(String templateName, TemplateFlowController flowController, int overflowIncrementInBytes) {
        this.templateName = templateName;
        this.flowController = flowController;
        this.overflowIncrementInBytes = overflowIncrementInBytes;
        this.overflow = null;
        this.overflowSize = 0;
        this.maxOverflowSize = 0;
        this.overflowGrowCount = 0;
        this.unlimited = false;
        this.limit = 0;
        this.writtenCount = 0;
        this.flowController.stopProcessing = true;
    }

    void setOutputStream(OutputStream os) {
        this.os = os;
        this.writtenCount = 0;
    }

    @Override
    public boolean isOverflown() {
        return this.overflowSize > 0;
    }

    @Override
    public boolean isStopped() {
        return this.limit == 0;
    }

    @Override
    public int getWrittenCount() {
        return this.writtenCount;
    }

    @Override
    public int getMaxOverflowSize() {
        return this.maxOverflowSize;
    }

    @Override
    public int getOverflowGrowCount() {
        return this.overflowGrowCount;
    }

    @Override
    public void allow(int limit) {
        if (limit == Integer.MAX_VALUE || limit < 0) {
            this.unlimited = true;
            this.limit = -1;
        } else {
            this.unlimited = false;
            this.limit = limit;
        }
        boolean bl = this.flowController.stopProcessing = this.limit == 0;
        if (this.overflowSize == 0 || this.limit == 0) {
            return;
        }
        try {
            if (this.unlimited || this.limit > this.overflowSize) {
                this.os.write(this.overflow, 0, this.overflowSize);
                if (!this.unlimited) {
                    this.limit -= this.overflowSize;
                }
                this.writtenCount += this.overflowSize;
                this.overflowSize = 0;
                return;
            }
            this.os.write(this.overflow, 0, this.limit);
            if (this.limit < this.overflowSize) {
                System.arraycopy(this.overflow, this.limit, this.overflow, 0, this.overflowSize - this.limit);
            }
            this.overflowSize -= this.limit;
            this.writtenCount += this.limit;
            this.limit = 0;
            this.flowController.stopProcessing = true;
        }
        catch (IOException e2) {
            throw new TemplateOutputException("Exception while trying to write overflowed buffer in throttled template", this.templateName, -1, -1, e2);
        }
    }

    @Override
    public void write(int b2) throws IOException {
        if (this.limit == 0) {
            this.overflow(b2);
            return;
        }
        this.os.write(b2);
        if (!this.unlimited) {
            --this.limit;
        }
        ++this.writtenCount;
        if (this.limit == 0) {
            this.flowController.stopProcessing = true;
        }
    }

    @Override
    public void write(byte[] bytes, int off, int len2) throws IOException {
        if (this.limit == 0) {
            this.overflow(bytes, off, len2);
            return;
        }
        if (this.unlimited || this.limit > len2) {
            this.os.write(bytes, off, len2);
            if (!this.unlimited) {
                this.limit -= len2;
            }
            this.writtenCount += len2;
            return;
        }
        this.os.write(bytes, off, this.limit);
        if (this.limit < len2) {
            this.overflow(bytes, off + this.limit, len2 - this.limit);
        }
        this.writtenCount += this.limit;
        this.limit = 0;
        this.flowController.stopProcessing = true;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        int len2 = bytes.length;
        if (this.limit == 0) {
            this.overflow(bytes, 0, len2);
            return;
        }
        if (this.unlimited || this.limit > len2) {
            this.os.write(bytes, 0, len2);
            if (!this.unlimited) {
                this.limit -= len2;
            }
            this.writtenCount += len2;
            return;
        }
        this.os.write(bytes, 0, this.limit);
        if (this.limit < len2) {
            this.overflow(bytes, this.limit, len2 - this.limit);
        }
        this.writtenCount += this.limit;
        this.limit = 0;
        this.flowController.stopProcessing = true;
    }

    private void overflow(int c2) {
        this.ensureOverflowCapacity(1);
        this.overflow[this.overflowSize] = (byte)c2;
        ++this.overflowSize;
        if (this.overflowSize > this.maxOverflowSize) {
            this.maxOverflowSize = this.overflowSize;
        }
    }

    private void overflow(byte[] bytes, int off, int len2) {
        this.ensureOverflowCapacity(len2);
        System.arraycopy(bytes, off, this.overflow, this.overflowSize, len2);
        this.overflowSize += len2;
        if (this.overflowSize > this.maxOverflowSize) {
            this.maxOverflowSize = this.overflowSize;
        }
    }

    private void ensureOverflowCapacity(int len2) {
        if (this.overflow == null) {
            int bufferInitialSize;
            for (bufferInitialSize = this.overflowIncrementInBytes * 3; bufferInitialSize < len2; bufferInitialSize += this.overflowIncrementInBytes) {
            }
            this.overflow = new byte[bufferInitialSize];
            return;
        }
        int targetLen = this.overflowSize + len2;
        if (this.overflow.length < targetLen) {
            int newLen = this.overflow.length;
            while ((newLen += this.overflowIncrementInBytes) < targetLen) {
            }
            this.overflow = Arrays.copyOf(this.overflow, newLen);
            ++this.overflowGrowCount;
        }
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }
}

