/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.io.IOException;
import java.io.Writer;
import org.thymeleaf.engine.AbstractTemplateEvent;
import org.thymeleaf.engine.IEngineTemplateEvent;
import org.thymeleaf.engine.ITemplateHandler;
import org.thymeleaf.model.IModelVisitor;
import org.thymeleaf.model.IXMLDeclaration;

final class XMLDeclaration
extends AbstractTemplateEvent
implements IXMLDeclaration,
IEngineTemplateEvent {
    public static final String DEFAULT_KEYWORD = "xml";
    public static final String DEFAULT_VERSION = "1.0";
    public static final String ATTRIBUTE_NAME_VERSION = "version";
    public static final String ATTRIBUTE_NAME_ENCODING = "encoding";
    public static final String ATTRIBUTE_NAME_STANDALONE = "standalone";
    private final String keyword;
    private final String version;
    private final String encoding;
    private final String standalone;
    private final String xmlDeclaration;

    XMLDeclaration(String encoding) {
        this(DEFAULT_KEYWORD, DEFAULT_VERSION, encoding, null);
    }

    XMLDeclaration(String keyword, String version2, String encoding, String standalone) {
        this.keyword = keyword;
        this.version = version2;
        this.encoding = encoding;
        this.standalone = standalone;
        this.xmlDeclaration = this.computeXmlDeclaration();
    }

    XMLDeclaration(String xmlDeclaration, String keyword, String version2, String encoding, String standalone, String templateName, int line, int col) {
        super(templateName, line, col);
        this.keyword = keyword;
        this.version = version2;
        this.encoding = encoding;
        this.standalone = standalone;
        this.xmlDeclaration = xmlDeclaration != null ? xmlDeclaration : this.computeXmlDeclaration();
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getStandalone() {
        return this.standalone;
    }

    @Override
    public String getXmlDeclaration() {
        return this.xmlDeclaration;
    }

    private String computeXmlDeclaration() {
        StringBuilder strBuilder = new StringBuilder(40);
        strBuilder.append("<?");
        strBuilder.append(this.keyword);
        if (this.version != null) {
            strBuilder.append(' ');
            strBuilder.append(ATTRIBUTE_NAME_VERSION);
            strBuilder.append("=\"");
            strBuilder.append(this.version);
            strBuilder.append('\"');
        }
        if (this.encoding != null) {
            strBuilder.append(' ');
            strBuilder.append(ATTRIBUTE_NAME_ENCODING);
            strBuilder.append("=\"");
            strBuilder.append(this.encoding);
            strBuilder.append('\"');
        }
        if (this.standalone != null) {
            strBuilder.append(' ');
            strBuilder.append(ATTRIBUTE_NAME_STANDALONE);
            strBuilder.append("=\"");
            strBuilder.append(this.standalone);
            strBuilder.append('\"');
        }
        strBuilder.append("?>");
        return strBuilder.toString();
    }

    @Override
    public void accept(IModelVisitor visitor2) {
        visitor2.visit(this);
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write(this.xmlDeclaration);
    }

    static XMLDeclaration asEngineXMLDeclaration(IXMLDeclaration xmlDeclaration) {
        if (xmlDeclaration instanceof XMLDeclaration) {
            return (XMLDeclaration)xmlDeclaration;
        }
        return new XMLDeclaration(null, xmlDeclaration.getKeyword(), xmlDeclaration.getVersion(), xmlDeclaration.getEncoding(), xmlDeclaration.getStandalone(), xmlDeclaration.getTemplateName(), xmlDeclaration.getLine(), xmlDeclaration.getCol());
    }

    @Override
    public void beHandled(ITemplateHandler handler2) {
        handler2.handleXMLDeclaration(this);
    }

    public String toString() {
        return this.getXmlDeclaration();
    }
}

