/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.expression;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.thymeleaf.util.EvaluationUtils;
import org.thymeleaf.util.Validate;

public final class Bools {
    public Boolean isTrue(Object target) {
        return EvaluationUtils.evaluateAsBoolean(target);
    }

    public Boolean[] arrayIsTrue(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Boolean[] result2 = new Boolean[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.isTrue(target[i2]);
        }
        return result2;
    }

    public List<Boolean> listIsTrue(List<?> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Boolean> result2 = new ArrayList<Boolean>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.isTrue(element));
        }
        return result2;
    }

    public Set<Boolean> setIsTrue(Set<?> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Boolean> result2 = new LinkedHashSet<Boolean>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.isTrue(element));
        }
        return result2;
    }

    public Boolean isFalse(Object target) {
        return !EvaluationUtils.evaluateAsBoolean(target);
    }

    public Boolean[] arrayIsFalse(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Boolean[] result2 = new Boolean[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.isFalse(target[i2]);
        }
        return result2;
    }

    public List<Boolean> listIsFalse(List<?> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Boolean> result2 = new ArrayList<Boolean>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.isFalse(element));
        }
        return result2;
    }

    public Set<Boolean> setIsFalse(Set<?> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Boolean> result2 = new LinkedHashSet<Boolean>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.isFalse(element));
        }
        return result2;
    }

    public Boolean arrayAnd(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        for (Object aTarget : target) {
            if (this.isTrue(aTarget).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean listAnd(List<?> target) {
        Validate.notNull(target, "Target cannot be null");
        for (Object element : target) {
            if (this.isTrue(element).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean setAnd(Set<?> target) {
        Validate.notNull(target, "Target cannot be null");
        for (Object element : target) {
            if (this.isTrue(element).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean arrayOr(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        for (Object aTarget : target) {
            if (!this.isTrue(aTarget).booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean listOr(List<?> target) {
        Validate.notNull(target, "Target cannot be null");
        for (Object element : target) {
            if (!this.isTrue(element).booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean setOr(Set<?> target) {
        Validate.notNull(target, "Target cannot be null");
        for (Object element : target) {
            if (!this.isTrue(element).booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

