/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.expression;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.util.DateUtils;
import org.thymeleaf.util.Validate;

public final class Calendars {
    private final Locale locale;

    public Calendars(Locale locale) {
        Validate.notNull(locale, "Locale cannot be null");
        this.locale = locale;
    }

    public Calendar create(Object year2, Object month, Object day2) {
        return DateUtils.create(year2, month, day2, null, null, null, null, null, this.locale);
    }

    public Calendar create(Object year2, Object month, Object day2, Object hour2, Object minute2) {
        return DateUtils.create(year2, month, day2, hour2, minute2, null, null, null, this.locale);
    }

    public Calendar create(Object year2, Object month, Object day2, Object hour2, Object minute2, Object second2) {
        return DateUtils.create(year2, month, day2, hour2, minute2, second2, null, null, this.locale);
    }

    public Calendar create(Object year2, Object month, Object day2, Object hour2, Object minute2, Object second2, Object millisecond) {
        return DateUtils.create(year2, month, day2, hour2, minute2, second2, millisecond, null, this.locale);
    }

    public Calendar createForTimeZone(Object year2, Object month, Object day2, Object timeZone) {
        return DateUtils.create(year2, month, day2, null, null, null, null, timeZone, this.locale);
    }

    public Calendar createForTimeZone(Object year2, Object month, Object day2, Object hour2, Object minute2, Object timeZone) {
        return DateUtils.create(year2, month, day2, hour2, minute2, null, null, timeZone, this.locale);
    }

    public Calendar createForTimeZone(Object year2, Object month, Object day2, Object hour2, Object minute2, Object second2, Object timeZone) {
        return DateUtils.create(year2, month, day2, hour2, minute2, second2, null, timeZone, this.locale);
    }

    public Calendar createForTimeZone(Object year2, Object month, Object day2, Object hour2, Object minute2, Object second2, Object millisecond, Object timeZone) {
        return DateUtils.create(year2, month, day2, hour2, minute2, second2, millisecond, timeZone, this.locale);
    }

    public Calendar createNow() {
        return DateUtils.createNow(null, this.locale);
    }

    public Calendar createNowForTimeZone(Object timeZone) {
        return DateUtils.createNow(timeZone, this.locale);
    }

    public Calendar createToday() {
        return DateUtils.createToday(null, this.locale);
    }

    public Calendar createTodayForTimeZone(Object timeZone) {
        return DateUtils.createToday(timeZone, this.locale);
    }

    public String format(Calendar target) {
        if (target == null) {
            return null;
        }
        try {
            return DateUtils.format(target, this.locale);
        }
        catch (Exception e2) {
            throw new TemplateProcessingException("Error formatting calendar with standard format for locale " + this.locale, e2);
        }
    }

    public String[] arrayFormat(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.format((Calendar)target[i2]);
        }
        return result2;
    }

    public List<String> listFormat(List<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.format(calendar));
        }
        return result2;
    }

    public Set<String> setFormat(Set<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.format(calendar));
        }
        return result2;
    }

    public String format(Calendar target, String pattern2) {
        if (target == null) {
            return null;
        }
        try {
            return DateUtils.format(target, pattern2, this.locale);
        }
        catch (Exception e2) {
            throw new TemplateProcessingException("Error formatting calendar with format pattern \"" + pattern2 + "\"", e2);
        }
    }

    public String[] arrayFormat(Object[] target, String pattern2) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.format((Calendar)target[i2], pattern2);
        }
        return result2;
    }

    public List<String> listFormat(List<? extends Calendar> target, String pattern2) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.format(calendar, pattern2));
        }
        return result2;
    }

    public Set<String> setFormat(Set<? extends Calendar> target, String pattern2) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.format(calendar, pattern2));
        }
        return result2;
    }

    public Integer day(Calendar target) {
        if (target == null) {
            return null;
        }
        return DateUtils.day(target);
    }

    public Integer[] arrayDay(Object[] target) {
        if (target == null) {
            return null;
        }
        Integer[] result2 = new Integer[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.day((Calendar)target[i2]);
        }
        return result2;
    }

    public List<Integer> listDay(List<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        ArrayList<Integer> result2 = new ArrayList<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.day(calendar));
        }
        return result2;
    }

    public Set<Integer> setDay(Set<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.day(calendar));
        }
        return result2;
    }

    public Integer month(Calendar target) {
        if (target == null) {
            return null;
        }
        return DateUtils.month(target);
    }

    public Integer[] arrayMonth(Object[] target) {
        if (target == null) {
            return null;
        }
        Integer[] result2 = new Integer[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.month((Calendar)target[i2]);
        }
        return result2;
    }

    public List<Integer> listMonth(List<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        ArrayList<Integer> result2 = new ArrayList<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.month(calendar));
        }
        return result2;
    }

    public Set<Integer> setMonth(Set<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.month(calendar));
        }
        return result2;
    }

    public String monthName(Calendar target) {
        if (target == null) {
            return null;
        }
        return DateUtils.monthName(target, this.locale);
    }

    public String[] arrayMonthName(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.monthName((Calendar)target[i2]);
        }
        return result2;
    }

    public List<String> listMonthName(List<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.monthName(calendar));
        }
        return result2;
    }

    public Set<String> setMonthName(Set<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.monthName(calendar));
        }
        return result2;
    }

    public String monthNameShort(Calendar target) {
        if (target == null) {
            return null;
        }
        return DateUtils.monthNameShort(target, this.locale);
    }

    public String[] arrayMonthNameShort(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.monthNameShort((Calendar)target[i2]);
        }
        return result2;
    }

    public List<String> listMonthNameShort(List<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.monthNameShort(calendar));
        }
        return result2;
    }

    public Set<String> setMonthNameShort(Set<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.monthNameShort(calendar));
        }
        return result2;
    }

    public Integer year(Calendar target) {
        if (target == null) {
            return null;
        }
        return DateUtils.year(target);
    }

    public Integer[] arrayYear(Object[] target) {
        if (target == null) {
            return null;
        }
        Integer[] result2 = new Integer[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.year((Calendar)target[i2]);
        }
        return result2;
    }

    public List<Integer> listYear(List<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        ArrayList<Integer> result2 = new ArrayList<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.year(calendar));
        }
        return result2;
    }

    public Set<Integer> setYear(Set<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.year(calendar));
        }
        return result2;
    }

    public Integer dayOfWeek(Calendar target) {
        if (target == null) {
            return null;
        }
        return DateUtils.dayOfWeek(target);
    }

    public Integer[] arrayDayOfWeek(Object[] target) {
        if (target == null) {
            return null;
        }
        Integer[] result2 = new Integer[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.dayOfWeek((Calendar)target[i2]);
        }
        return result2;
    }

    public List<Integer> listDayOfWeek(List<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        ArrayList<Integer> result2 = new ArrayList<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.dayOfWeek(calendar));
        }
        return result2;
    }

    public Set<Integer> setDayOfWeek(Set<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.dayOfWeek(calendar));
        }
        return result2;
    }

    public String dayOfWeekName(Calendar target) {
        if (target == null) {
            return null;
        }
        return DateUtils.dayOfWeekName(target, this.locale);
    }

    public String[] arrayDayOfWeekName(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.dayOfWeekName((Calendar)target[i2]);
        }
        return result2;
    }

    public List<String> listDayOfWeekName(List<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.dayOfWeekName(calendar));
        }
        return result2;
    }

    public Set<String> setDayOfWeekName(Set<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.dayOfWeekName(calendar));
        }
        return result2;
    }

    public String dayOfWeekNameShort(Calendar target) {
        if (target == null) {
            return null;
        }
        return DateUtils.dayOfWeekNameShort(target, this.locale);
    }

    public String[] arrayDayOfWeekNameShort(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.dayOfWeekNameShort((Calendar)target[i2]);
        }
        return result2;
    }

    public List<String> listDayOfWeekNameShort(List<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.dayOfWeekNameShort(calendar));
        }
        return result2;
    }

    public Set<String> setDayOfWeekNameShort(Set<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.dayOfWeekNameShort(calendar));
        }
        return result2;
    }

    public Integer hour(Calendar target) {
        if (target == null) {
            return null;
        }
        return DateUtils.hour(target);
    }

    public Integer[] arrayHour(Object[] target) {
        if (target == null) {
            return null;
        }
        Integer[] result2 = new Integer[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.hour((Calendar)target[i2]);
        }
        return result2;
    }

    public List<Integer> listHour(List<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        ArrayList<Integer> result2 = new ArrayList<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.hour(calendar));
        }
        return result2;
    }

    public Set<Integer> setHour(Set<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.hour(calendar));
        }
        return result2;
    }

    public Integer minute(Calendar target) {
        if (target == null) {
            return null;
        }
        return DateUtils.minute(target);
    }

    public Integer[] arrayMinute(Object[] target) {
        if (target == null) {
            return null;
        }
        Integer[] result2 = new Integer[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.minute((Calendar)target[i2]);
        }
        return result2;
    }

    public List<Integer> listMinute(List<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        ArrayList<Integer> result2 = new ArrayList<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.minute(calendar));
        }
        return result2;
    }

    public Set<Integer> setMinute(Set<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.minute(calendar));
        }
        return result2;
    }

    public Integer second(Calendar target) {
        if (target == null) {
            return null;
        }
        return DateUtils.second(target);
    }

    public Integer[] arraySecond(Object[] target) {
        if (target == null) {
            return null;
        }
        Integer[] result2 = new Integer[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.second((Calendar)target[i2]);
        }
        return result2;
    }

    public List<Integer> listSecond(List<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        ArrayList<Integer> result2 = new ArrayList<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.second(calendar));
        }
        return result2;
    }

    public Set<Integer> setSecond(Set<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.second(calendar));
        }
        return result2;
    }

    public Integer millisecond(Calendar target) {
        if (target == null) {
            return null;
        }
        return DateUtils.millisecond(target);
    }

    public Integer[] arrayMillisecond(Object[] target) {
        if (target == null) {
            return null;
        }
        Integer[] result2 = new Integer[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.millisecond((Calendar)target[i2]);
        }
        return result2;
    }

    public List<Integer> listMillisecond(List<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        ArrayList<Integer> result2 = new ArrayList<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.millisecond(calendar));
        }
        return result2;
    }

    public Set<Integer> setMillisecond(Set<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.millisecond(calendar));
        }
        return result2;
    }

    public String formatISO(Calendar target) {
        if (target == null) {
            return null;
        }
        try {
            return DateUtils.formatISO(target);
        }
        catch (Exception e2) {
            throw new TemplateProcessingException("Error formatting calendar as ISO8601", e2);
        }
    }

    public String[] arrayFormatISO(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.formatISO((Calendar)target[i2]);
        }
        return result2;
    }

    public List<String> listFormatISO(List<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.formatISO(calendar));
        }
        return result2;
    }

    public Set<String> setFormatISO(Set<? extends Calendar> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result2.add(this.formatISO(calendar));
        }
        return result2;
    }
}

