/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.expression;

import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.standard.expression.IStandardConversionService;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.util.ClassLoaderUtils;
import org.thymeleaf.util.Validate;

public final class Conversions {
    private final IExpressionContext context;

    public Conversions(IExpressionContext context) {
        Validate.notNull(context, "Context cannot be null");
        this.context = context;
    }

    public Object convert(Object target, String className) {
        try {
            Class<?> clazz = ClassLoaderUtils.loadClass(className);
            return this.convert(target, clazz);
        }
        catch (ClassNotFoundException e2) {
            try {
                Class<?> clazz = ClassLoaderUtils.loadClass("java.lang." + className);
                return this.convert(target, clazz);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Cannot convert to class '" + className + "'", e2);
            }
        }
    }

    public Object convert(Object target, Class<?> clazz) {
        IStandardConversionService conversionService = StandardExpressions.getConversionService(this.context.getConfiguration());
        return conversionService.convert(this.context, target, clazz);
    }
}

