/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.expression;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.util.DateUtils;
import org.thymeleaf.util.Validate;

public final class Dates {
    private final Locale locale;

    public Dates(Locale locale) {
        Validate.notNull(locale, "Locale cannot be null");
        this.locale = locale;
    }

    public Date create(Object year2, Object month, Object day2) {
        return DateUtils.create(year2, month, day2, null, null, null, null, null, this.locale).getTime();
    }

    public Date create(Object year2, Object month, Object day2, Object hour2, Object minute2) {
        return DateUtils.create(year2, month, day2, hour2, minute2, null, null, null, this.locale).getTime();
    }

    public Date create(Object year2, Object month, Object day2, Object hour2, Object minute2, Object second2) {
        return DateUtils.create(year2, month, day2, hour2, minute2, second2, null, null, this.locale).getTime();
    }

    public Date create(Object year2, Object month, Object day2, Object hour2, Object minute2, Object second2, Object millisecond) {
        return DateUtils.create(year2, month, day2, hour2, minute2, second2, millisecond, null, this.locale).getTime();
    }

    public Date createNow() {
        return DateUtils.createNow(null, this.locale).getTime();
    }

    public Date createNowForTimeZone(Object timeZone) {
        return DateUtils.createNow(timeZone, this.locale).getTime();
    }

    public Date createToday() {
        return DateUtils.createToday(null, this.locale).getTime();
    }

    public Date createTodayForTimeZone(Object timeZone) {
        return DateUtils.createToday(timeZone, this.locale).getTime();
    }

    public String format(Date target) {
        if (target == null) {
            return null;
        }
        try {
            return DateUtils.format(target, this.locale);
        }
        catch (Exception e2) {
            throw new TemplateProcessingException("Error formatting date with standard format for locale " + this.locale, e2);
        }
    }

    public String[] arrayFormat(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.format((Date)target[i2]);
        }
        return result2;
    }

    public List<String> listFormat(List<? extends Date> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.format(date));
        }
        return result2;
    }

    public Set<String> setFormat(Set<? extends Date> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.format(date));
        }
        return result2;
    }

    public String format(Date target, String pattern2) {
        if (target == null) {
            return null;
        }
        try {
            return DateUtils.format(target, pattern2, this.locale);
        }
        catch (Exception e2) {
            throw new TemplateProcessingException("Error formatting date with format pattern \"" + pattern2 + "\"", e2);
        }
    }

    public String[] arrayFormat(Object[] target, String pattern2) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.format((Date)target[i2], pattern2);
        }
        return result2;
    }

    public List<String> listFormat(List<? extends Date> target, String pattern2) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.format(date, pattern2));
        }
        return result2;
    }

    public Set<String> setFormat(Set<? extends Date> target, String pattern2) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.format(date, pattern2));
        }
        return result2;
    }

    public Integer day(Date target) {
        if (target == null) {
            return null;
        }
        return DateUtils.day(target);
    }

    public Integer[] arrayDay(Object[] target) {
        if (target == null) {
            return null;
        }
        Integer[] result2 = new Integer[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.day((Date)target[i2]);
        }
        return result2;
    }

    public List<Integer> listDay(List<? extends Date> target) {
        if (target == null) {
            return null;
        }
        ArrayList<Integer> result2 = new ArrayList<Integer>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.day(date));
        }
        return result2;
    }

    public Set<Integer> setDay(Set<? extends Date> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.day(date));
        }
        return result2;
    }

    public Integer month(Date target) {
        if (target == null) {
            return null;
        }
        return DateUtils.month(target);
    }

    public Integer[] arrayMonth(Object[] target) {
        if (target == null) {
            return null;
        }
        Integer[] result2 = new Integer[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.month((Date)target[i2]);
        }
        return result2;
    }

    public List<Integer> listMonth(List<? extends Date> target) {
        if (target == null) {
            return null;
        }
        ArrayList<Integer> result2 = new ArrayList<Integer>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.month(date));
        }
        return result2;
    }

    public Set<Integer> setMonth(Set<? extends Date> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.month(date));
        }
        return result2;
    }

    public String monthName(Date target) {
        if (target == null) {
            return null;
        }
        return DateUtils.monthName(target, this.locale);
    }

    public String[] arrayMonthName(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.monthName((Date)target[i2]);
        }
        return result2;
    }

    public List<String> listMonthName(List<? extends Date> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.monthName(date));
        }
        return result2;
    }

    public Set<String> setMonthName(Set<? extends Date> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.monthName(date));
        }
        return result2;
    }

    public String monthNameShort(Date target) {
        if (target == null) {
            return null;
        }
        return DateUtils.monthNameShort(target, this.locale);
    }

    public String[] arrayMonthNameShort(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.monthNameShort((Date)target[i2]);
        }
        return result2;
    }

    public List<String> listMonthNameShort(List<? extends Date> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.monthNameShort(date));
        }
        return result2;
    }

    public Set<String> setMonthNameShort(Set<? extends Date> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.monthNameShort(date));
        }
        return result2;
    }

    public Integer year(Date target) {
        if (target == null) {
            return null;
        }
        return DateUtils.year(target);
    }

    public Integer[] arrayYear(Object[] target) {
        if (target == null) {
            return null;
        }
        Integer[] result2 = new Integer[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.year((Date)target[i2]);
        }
        return result2;
    }

    public List<Integer> listYear(List<? extends Date> target) {
        if (target == null) {
            return null;
        }
        ArrayList<Integer> result2 = new ArrayList<Integer>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.year(date));
        }
        return result2;
    }

    public Set<Integer> setYear(Set<? extends Date> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.year(date));
        }
        return result2;
    }

    public Integer dayOfWeek(Date target) {
        if (target == null) {
            return null;
        }
        return DateUtils.dayOfWeek(target);
    }

    public Integer[] arrayDayOfWeek(Object[] target) {
        if (target == null) {
            return null;
        }
        Integer[] result2 = new Integer[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.dayOfWeek((Date)target[i2]);
        }
        return result2;
    }

    public List<Integer> listDayOfWeek(List<? extends Date> target) {
        if (target == null) {
            return null;
        }
        ArrayList<Integer> result2 = new ArrayList<Integer>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.dayOfWeek(date));
        }
        return result2;
    }

    public Set<Integer> setDayOfWeek(Set<? extends Date> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.dayOfWeek(date));
        }
        return result2;
    }

    public String dayOfWeekName(Date target) {
        if (target == null) {
            return null;
        }
        return DateUtils.dayOfWeekName(target, this.locale);
    }

    public String[] arrayDayOfWeekName(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.dayOfWeekName((Date)target[i2]);
        }
        return result2;
    }

    public List<String> listDayOfWeekName(List<? extends Date> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.dayOfWeekName(date));
        }
        return result2;
    }

    public Set<String> setDayOfWeekName(Set<? extends Date> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.dayOfWeekName(date));
        }
        return result2;
    }

    public String dayOfWeekNameShort(Date target) {
        if (target == null) {
            return null;
        }
        return DateUtils.dayOfWeekNameShort(target, this.locale);
    }

    public String[] arrayDayOfWeekNameShort(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.dayOfWeekNameShort((Date)target[i2]);
        }
        return result2;
    }

    public List<String> listDayOfWeekNameShort(List<? extends Date> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.dayOfWeekNameShort(date));
        }
        return result2;
    }

    public Set<String> setDayOfWeekNameShort(Set<? extends Date> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.dayOfWeekNameShort(date));
        }
        return result2;
    }

    public Integer hour(Date target) {
        if (target == null) {
            return null;
        }
        return DateUtils.hour(target);
    }

    public Integer[] arrayHour(Object[] target) {
        if (target == null) {
            return null;
        }
        Integer[] result2 = new Integer[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.hour((Date)target[i2]);
        }
        return result2;
    }

    public List<Integer> listHour(List<? extends Date> target) {
        if (target == null) {
            return null;
        }
        ArrayList<Integer> result2 = new ArrayList<Integer>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.hour(date));
        }
        return result2;
    }

    public Set<Integer> setHour(Set<? extends Date> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.hour(date));
        }
        return result2;
    }

    public Integer minute(Date target) {
        if (target == null) {
            return null;
        }
        return DateUtils.minute(target);
    }

    public Integer[] arrayMinute(Object[] target) {
        if (target == null) {
            return null;
        }
        Integer[] result2 = new Integer[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.minute((Date)target[i2]);
        }
        return result2;
    }

    public List<Integer> listMinute(List<? extends Date> target) {
        if (target == null) {
            return null;
        }
        ArrayList<Integer> result2 = new ArrayList<Integer>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.minute(date));
        }
        return result2;
    }

    public Set<Integer> setMinute(Set<? extends Date> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.minute(date));
        }
        return result2;
    }

    public Integer second(Date target) {
        if (target == null) {
            return null;
        }
        return DateUtils.second(target);
    }

    public Integer[] arraySecond(Object[] target) {
        if (target == null) {
            return null;
        }
        Integer[] result2 = new Integer[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.second((Date)target[i2]);
        }
        return result2;
    }

    public List<Integer> listSecond(List<? extends Date> target) {
        if (target == null) {
            return null;
        }
        ArrayList<Integer> result2 = new ArrayList<Integer>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.second(date));
        }
        return result2;
    }

    public Set<Integer> setSecond(Set<? extends Date> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.second(date));
        }
        return result2;
    }

    public Integer millisecond(Date target) {
        if (target == null) {
            return null;
        }
        return DateUtils.millisecond(target);
    }

    public Integer[] arrayMillisecond(Object[] target) {
        if (target == null) {
            return null;
        }
        Integer[] result2 = new Integer[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.millisecond((Date)target[i2]);
        }
        return result2;
    }

    public List<Integer> listMillisecond(List<? extends Date> target) {
        if (target == null) {
            return null;
        }
        ArrayList<Integer> result2 = new ArrayList<Integer>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.millisecond(date));
        }
        return result2;
    }

    public Set<Integer> setMillisecond(Set<? extends Date> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.millisecond(date));
        }
        return result2;
    }

    public String formatISO(Date target) {
        if (target == null) {
            return null;
        }
        try {
            return DateUtils.formatISO(target);
        }
        catch (Exception e2) {
            throw new TemplateProcessingException("Error formatting date as ISO8601", e2);
        }
    }

    public String[] arrayFormatISO(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.formatISO((Date)target[i2]);
        }
        return result2;
    }

    public List<String> listFormatISO(List<? extends Date> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.formatISO(date));
        }
        return result2;
    }

    public Set<String> setFormatISO(Set<? extends Date> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Date date : target) {
            result2.add(this.formatISO(date));
        }
        return result2;
    }
}

