/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.expression;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.thymeleaf.util.ObjectUtils;
import org.thymeleaf.util.Validate;

public final class Objects {
    public <T> T nullSafe(T target, T defaultValue) {
        return ObjectUtils.nullSafe(target, defaultValue);
    }

    public <T> T[] arrayNullSafe(T[] target, T defaultValue) {
        Validate.notNull(target, "Target cannot be null");
        Object[] result2 = (Object[])target.clone();
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.nullSafe(target[i2], defaultValue);
        }
        return result2;
    }

    public <T> List<T> listNullSafe(List<T> target, T defaultValue) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<T> result2 = new ArrayList<T>(target.size() + 2);
        for (T element : target) {
            result2.add(this.nullSafe(element, defaultValue));
        }
        return result2;
    }

    public <T> Set<T> setNullSafe(Set<T> target, T defaultValue) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<T> result2 = new LinkedHashSet<T>(target.size() + 2);
        for (T element : target) {
            result2.add(this.nullSafe(element, defaultValue));
        }
        return result2;
    }
}

