/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.expression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public final class Strings {
    private final Locale locale;

    public Strings(Locale locale) {
        this.locale = locale;
    }

    public String toString(Object target) {
        if (target == null) {
            return null;
        }
        return StringUtils.toString(target);
    }

    public String[] arrayToString(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.toString(target[i2]);
        }
        return result2;
    }

    public List<String> listToString(List<?> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.toString(element));
        }
        return result2;
    }

    public Set<String> setToString(Set<?> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.toString(element));
        }
        return result2;
    }

    public String abbreviate(Object target, int maxSize2) {
        if (target == null) {
            return null;
        }
        return StringUtils.abbreviate(target, maxSize2);
    }

    public String[] arrayAbbreviate(Object[] target, int maxSize2) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.abbreviate(target[i2], maxSize2);
        }
        return result2;
    }

    public List<String> listAbbreviate(List<?> target, int maxSize2) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.abbreviate(element, maxSize2));
        }
        return result2;
    }

    public Set<String> setAbbreviate(Set<?> target, int maxSize2) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.abbreviate(element, maxSize2));
        }
        return result2;
    }

    public Boolean equals(Object first2, Object second2) {
        return StringUtils.equals(first2, second2);
    }

    public Boolean equalsIgnoreCase(Object first2, Object second2) {
        return StringUtils.equalsIgnoreCase(first2, second2);
    }

    public Boolean contains(Object target, String fragment) {
        return StringUtils.contains(target, fragment);
    }

    public Boolean[] arrayContains(Object[] target, String fragment) {
        if (target == null) {
            return null;
        }
        Boolean[] result2 = new Boolean[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.contains(target[i2], fragment);
        }
        return result2;
    }

    public List<Boolean> listContains(List<?> target, String fragment) {
        if (target == null) {
            return null;
        }
        ArrayList<Boolean> result2 = new ArrayList<Boolean>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.contains(element, fragment));
        }
        return result2;
    }

    public Set<Boolean> setContains(Set<?> target, String fragment) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Boolean> result2 = new LinkedHashSet<Boolean>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.contains(element, fragment));
        }
        return result2;
    }

    public Boolean containsIgnoreCase(Object target, String fragment) {
        return StringUtils.containsIgnoreCase(target, fragment, this.locale);
    }

    public Boolean[] arrayContainsIgnoreCase(Object[] target, String fragment) {
        if (target == null) {
            return null;
        }
        Boolean[] result2 = new Boolean[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.containsIgnoreCase(target[i2], fragment);
        }
        return result2;
    }

    public List<Boolean> listContainsIgnoreCase(List<?> target, String fragment) {
        if (target == null) {
            return null;
        }
        ArrayList<Boolean> result2 = new ArrayList<Boolean>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.containsIgnoreCase(element, fragment));
        }
        return result2;
    }

    public Set<Boolean> setContainsIgnoreCase(Set<?> target, String fragment) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Boolean> result2 = new LinkedHashSet<Boolean>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.containsIgnoreCase(element, fragment));
        }
        return result2;
    }

    public Boolean startsWith(Object target, String prefix2) {
        return StringUtils.startsWith(target, prefix2);
    }

    public Boolean[] arrayStartsWith(Object[] target, String prefix2) {
        if (target == null) {
            return null;
        }
        Boolean[] result2 = new Boolean[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.startsWith(target[i2], prefix2);
        }
        return result2;
    }

    public List<Boolean> listStartsWith(List<?> target, String prefix2) {
        if (target == null) {
            return null;
        }
        ArrayList<Boolean> result2 = new ArrayList<Boolean>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.startsWith(element, prefix2));
        }
        return result2;
    }

    public Set<Boolean> setStartsWith(Set<?> target, String prefix2) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Boolean> result2 = new LinkedHashSet<Boolean>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.startsWith(element, prefix2));
        }
        return result2;
    }

    public Boolean endsWith(Object target, String suffix) {
        return StringUtils.endsWith(target, suffix);
    }

    public Boolean[] arrayEndsWith(Object[] target, String suffix) {
        if (target == null) {
            return null;
        }
        Boolean[] result2 = new Boolean[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.endsWith(target[i2], suffix);
        }
        return result2;
    }

    public List<Boolean> listEndsWith(List<?> target, String suffix) {
        if (target == null) {
            return null;
        }
        ArrayList<Boolean> result2 = new ArrayList<Boolean>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.endsWith(element, suffix));
        }
        return result2;
    }

    public Set<Boolean> setEndsWith(Set<?> target, String suffix) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Boolean> result2 = new LinkedHashSet<Boolean>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.endsWith(element, suffix));
        }
        return result2;
    }

    public String substring(Object target, int start2, int end2) {
        if (target == null) {
            return null;
        }
        return StringUtils.substring(target, start2, end2);
    }

    public String[] arraySubstring(Object[] target, int start2, int end2) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.substring(target[i2], start2, end2);
        }
        return result2;
    }

    public List<String> listSubstring(List<?> target, int start2, int end2) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.substring(element, start2, end2));
        }
        return result2;
    }

    public Set<String> setSubstring(Set<?> target, int start2, int end2) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.substring(element, start2, end2));
        }
        return result2;
    }

    public String substring(Object target, int start2) {
        if (target == null) {
            return null;
        }
        return StringUtils.substring(target, start2);
    }

    public String[] arraySubstring(Object[] target, int start2) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.substring(target[i2], start2);
        }
        return result2;
    }

    public List<String> listSubstring(List<?> target, int start2) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.substring(element, start2));
        }
        return result2;
    }

    public Set<String> setSubstring(Set<?> target, int start2) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.substring(element, start2));
        }
        return result2;
    }

    public String substringAfter(Object target, String substr) {
        if (target == null) {
            return null;
        }
        return StringUtils.substringAfter(target, substr);
    }

    public String[] arraySubstringAfter(Object[] target, String substr) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.substringAfter(target[i2], substr);
        }
        return result2;
    }

    public List<String> listSubstringAfter(List<?> target, String substr) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.substringAfter(element, substr));
        }
        return result2;
    }

    public Set<String> setSubstringAfter(Set<?> target, String substr) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.substringAfter(element, substr));
        }
        return result2;
    }

    public String substringBefore(Object target, String substr) {
        if (target == null) {
            return null;
        }
        return StringUtils.substringBefore(target, substr);
    }

    public String[] arraySubstringBefore(Object[] target, String substr) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.substringBefore(target[i2], substr);
        }
        return result2;
    }

    public List<String> listSubstringBefore(List<?> target, String substr) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.substringBefore(element, substr));
        }
        return result2;
    }

    public Set<String> setSubstringBefore(Set<?> target, String substr) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.substringBefore(element, substr));
        }
        return result2;
    }

    public String prepend(Object target, String prefix2) {
        if (target == null) {
            return null;
        }
        return StringUtils.prepend(target, prefix2);
    }

    public String[] arrayPrepend(Object[] target, String prefix2) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.prepend(target[i2], prefix2);
        }
        return result2;
    }

    public List<String> listPrepend(List<?> target, String prefix2) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.prepend(element, prefix2));
        }
        return result2;
    }

    public Set<String> setPrepend(Set<?> target, String prefix2) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.prepend(element, prefix2));
        }
        return result2;
    }

    public String repeat(Object target, int times) {
        if (target == null) {
            return null;
        }
        return StringUtils.repeat(target, times);
    }

    public String append(Object target, String suffix) {
        if (target == null) {
            return null;
        }
        return StringUtils.append(target, suffix);
    }

    public String concat(Object ... values2) {
        return StringUtils.concat(values2);
    }

    public String concatReplaceNulls(String nullValue, Object ... values2) {
        return StringUtils.concatReplaceNulls(nullValue, values2);
    }

    public String[] arrayAppend(Object[] target, String suffix) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.append(target[i2], suffix);
        }
        return result2;
    }

    public List<String> listAppend(List<?> target, String suffix) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.append(element, suffix));
        }
        return result2;
    }

    public Set<String> setAppend(Set<?> target, String suffix) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.append(element, suffix));
        }
        return result2;
    }

    public Integer indexOf(Object target, String fragment) {
        return StringUtils.indexOf(target, fragment);
    }

    public Integer[] arrayIndexOf(Object[] target, String fragment) {
        if (target == null) {
            return null;
        }
        Integer[] result2 = new Integer[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.indexOf(target[i2], fragment);
        }
        return result2;
    }

    public List<Integer> listIndexOf(List<?> target, String fragment) {
        if (target == null) {
            return null;
        }
        ArrayList<Integer> result2 = new ArrayList<Integer>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.indexOf(element, fragment));
        }
        return result2;
    }

    public Set<Integer> setIndexOf(Set<?> target, String fragment) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.indexOf(element, fragment));
        }
        return result2;
    }

    public Boolean isEmpty(Object target) {
        return target == null || StringUtils.isEmptyOrWhitespace(target.toString());
    }

    public Boolean[] arrayIsEmpty(Object[] target) {
        if (target == null) {
            return null;
        }
        Boolean[] result2 = new Boolean[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.isEmpty(target[i2]);
        }
        return result2;
    }

    public List<Boolean> listIsEmpty(List<?> target) {
        if (target == null) {
            return null;
        }
        ArrayList<Boolean> result2 = new ArrayList<Boolean>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.isEmpty(element));
        }
        return result2;
    }

    public Set<Boolean> setIsEmpty(Set<?> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Boolean> result2 = new LinkedHashSet<Boolean>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.isEmpty(element));
        }
        return result2;
    }

    public String arrayJoin(Object[] stringArray, String separator) {
        if (stringArray == null) {
            return null;
        }
        return StringUtils.join(stringArray, separator);
    }

    public String listJoin(List<?> stringIter, String separator) {
        if (stringIter == null) {
            return null;
        }
        return StringUtils.join(stringIter, separator);
    }

    public String setJoin(Set<?> stringIter, String separator) {
        if (stringIter == null) {
            return null;
        }
        return StringUtils.join(stringIter, separator);
    }

    public String[] arraySplit(Object target, String separator) {
        if (target == null) {
            return null;
        }
        return StringUtils.split(target, separator);
    }

    public List<String> listSplit(Object target, String separator) {
        if (target == null) {
            return null;
        }
        return new ArrayList<String>(Arrays.asList(StringUtils.split(target, separator)));
    }

    public Set<String> setSplit(Object target, String separator) {
        if (target == null) {
            return null;
        }
        return new LinkedHashSet<String>(Arrays.asList(StringUtils.split(target, separator)));
    }

    public Integer length(Object target) {
        return StringUtils.length(target);
    }

    public Integer[] arrayLength(Object[] target) {
        if (target == null) {
            return null;
        }
        Integer[] result2 = new Integer[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.length(target[i2]);
        }
        return result2;
    }

    public List<Integer> listLength(List<?> target) {
        if (target == null) {
            return null;
        }
        ArrayList<Integer> result2 = new ArrayList<Integer>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.length(element));
        }
        return result2;
    }

    public Set<Integer> setLength(Set<?> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.length(element));
        }
        return result2;
    }

    public String replace(Object target, String before, String after) {
        if (target == null) {
            return null;
        }
        return StringUtils.replace(target, before, after);
    }

    public String[] arrayReplace(Object[] target, String before, String after) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.replace(target[i2], before, after);
        }
        return result2;
    }

    public List<String> listReplace(List<?> target, String before, String after) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.replace(element, before, after));
        }
        return result2;
    }

    public Set<String> setReplace(Set<?> target, String before, String after) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.replace(element, before, after));
        }
        return result2;
    }

    public String multipleReplace(Object target, String[] before, String[] after) {
        Validate.notNull(before, "Array of 'before' values cannot be null");
        Validate.notNull(after, "Array of 'after' values cannot be null");
        Validate.isTrue(before.length == after.length, "Arrays of 'before' and 'after' values must have the same length");
        if (target == null) {
            return null;
        }
        String ret = target.toString();
        for (int i2 = 0; i2 < before.length; ++i2) {
            ret = StringUtils.replace(ret, before[i2], after[i2]);
        }
        return ret;
    }

    public String[] arrayMultipleReplace(Object[] target, String[] before, String[] after) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.multipleReplace(target[i2], before, after);
        }
        return result2;
    }

    public List<String> listMultipleReplace(List<?> target, String[] before, String[] after) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.multipleReplace(element, before, after));
        }
        return result2;
    }

    public Set<String> setMultipleReplace(Set<?> target, String[] before, String[] after) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.multipleReplace(element, before, after));
        }
        return result2;
    }

    public String toUpperCase(Object target) {
        if (target == null) {
            return null;
        }
        return StringUtils.toUpperCase(target, this.locale);
    }

    public String[] arrayToUpperCase(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.toUpperCase(target[i2]);
        }
        return result2;
    }

    public List<String> listToUpperCase(List<?> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.toUpperCase(element));
        }
        return result2;
    }

    public Set<String> setToUpperCase(Set<?> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.toUpperCase(element));
        }
        return result2;
    }

    public String toLowerCase(Object target) {
        if (target == null) {
            return null;
        }
        return StringUtils.toLowerCase(target, this.locale);
    }

    public String[] arrayToLowerCase(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.toLowerCase(target[i2]);
        }
        return result2;
    }

    public List<String> listToLowerCase(List<?> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.toLowerCase(element));
        }
        return result2;
    }

    public Set<String> setToLowerCase(Set<?> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.toLowerCase(element));
        }
        return result2;
    }

    public String trim(Object target) {
        if (target == null) {
            return null;
        }
        return StringUtils.trim(target);
    }

    public String[] arrayTrim(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.trim(target[i2]);
        }
        return result2;
    }

    public List<String> listTrim(List<?> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.trim(element));
        }
        return result2;
    }

    public Set<String> setTrim(Set<?> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.trim(element));
        }
        return result2;
    }

    public String capitalize(Object target) {
        if (target == null) {
            return null;
        }
        return StringUtils.capitalize(target);
    }

    public String[] arrayCapitalize(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.capitalize(target[i2]);
        }
        return result2;
    }

    public List<String> listCapitalize(List<?> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.capitalize(element));
        }
        return result2;
    }

    public Set<String> setCapitalize(Set<?> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.capitalize(element));
        }
        return result2;
    }

    public String unCapitalize(Object target) {
        if (target == null) {
            return null;
        }
        return StringUtils.unCapitalize(target);
    }

    public String[] arrayUnCapitalize(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.unCapitalize(target[i2]);
        }
        return result2;
    }

    public List<String> listUnCapitalize(List<?> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.unCapitalize(element));
        }
        return result2;
    }

    public Set<String> setUnCapitalize(Set<?> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.unCapitalize(element));
        }
        return result2;
    }

    public String capitalizeWords(Object target) {
        if (target == null) {
            return null;
        }
        return StringUtils.capitalizeWords(target);
    }

    public String[] arrayCapitalizeWords(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.capitalizeWords(target[i2]);
        }
        return result2;
    }

    public List<String> listCapitalizeWords(List<?> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.capitalizeWords(element));
        }
        return result2;
    }

    public Set<String> setCapitalizeWords(Set<?> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.capitalizeWords(element));
        }
        return result2;
    }

    public String capitalizeWords(Object target, Object delimiters) {
        if (target == null) {
            return null;
        }
        return StringUtils.capitalizeWords(target, delimiters);
    }

    public String[] arrayCapitalizeWords(Object[] target, Object delimiters) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.capitalizeWords(target[i2], delimiters);
        }
        return result2;
    }

    public List<String> listCapitalizeWords(List<?> target, Object delimiters) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.capitalizeWords(element, delimiters));
        }
        return result2;
    }

    public Set<String> setCapitalizeWords(Set<?> target, Object delimiters) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.capitalizeWords(element, delimiters));
        }
        return result2;
    }

    public String escapeXml(Object target) {
        if (target == null) {
            return null;
        }
        return StringUtils.escapeXml(target);
    }

    public String[] arrayEscapeXml(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.escapeXml(target[i2]);
        }
        return result2;
    }

    public List<String> listEscapeXml(List<?> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.escapeXml(element));
        }
        return result2;
    }

    public Set<String> setEscapeXml(Set<?> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.escapeXml(element));
        }
        return result2;
    }

    public String escapeJavaScript(Object target) {
        if (target == null) {
            return null;
        }
        return StringUtils.escapeJavaScript(target);
    }

    public String[] arrayEscapeJavaScript(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.escapeJavaScript(target[i2]);
        }
        return result2;
    }

    public List<String> listEscapeJavaScript(List<?> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.escapeJavaScript(element));
        }
        return result2;
    }

    public Set<String> setEscapeJavaScript(Set<?> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.escapeJavaScript(element));
        }
        return result2;
    }

    public String unescapeJavaScript(Object target) {
        if (target == null) {
            return null;
        }
        return StringUtils.unescapeJavaScript(target);
    }

    public String[] arrayUnescapeJavaScript(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.unescapeJavaScript(target[i2]);
        }
        return result2;
    }

    public List<String> listUnescapeJavaScript(List<?> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.unescapeJavaScript(element));
        }
        return result2;
    }

    public Set<String> setUnescapeJavaScript(Set<?> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.unescapeJavaScript(element));
        }
        return result2;
    }

    public String escapeJava(Object target) {
        if (target == null) {
            return null;
        }
        return StringUtils.escapeJava(target);
    }

    public String[] arrayEscapeJava(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.escapeJava(target[i2]);
        }
        return result2;
    }

    public List<String> listEscapeJava(List<?> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.escapeJava(element));
        }
        return result2;
    }

    public Set<String> setEscapeJava(Set<?> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.escapeJava(element));
        }
        return result2;
    }

    public String unescapeJava(Object target) {
        if (target == null) {
            return null;
        }
        return StringUtils.unescapeJava(target);
    }

    public String[] arrayUnescapeJava(Object[] target) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.unescapeJava(target[i2]);
        }
        return result2;
    }

    public List<String> listUnescapeJava(List<?> target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.unescapeJava(element));
        }
        return result2;
    }

    public Set<String> setUnescapeJava(Set<?> target) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.unescapeJava(element));
        }
        return result2;
    }

    public String randomAlphanumeric(int count2) {
        return StringUtils.randomAlphanumeric(count2);
    }

    public String defaultString(Object target, Object defaultValue) {
        if (target == null) {
            if (defaultValue == null) {
                return "null";
            }
            return defaultValue.toString();
        }
        String targetString = target.toString();
        if (StringUtils.isEmptyOrWhitespace(targetString)) {
            if (defaultValue == null) {
                return "null";
            }
            return defaultValue.toString();
        }
        return targetString;
    }

    public String[] arrayDefaultString(Object[] target, Object defaultValue) {
        if (target == null) {
            return null;
        }
        String[] result2 = new String[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            result2[i2] = this.defaultString(target[i2], defaultValue);
        }
        return result2;
    }

    public List<String> listDefaultString(List<?> target, Object defaultValue) {
        if (target == null) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.defaultString(element, defaultValue));
        }
        return result2;
    }

    public Set<String> setDefaultString(Set<?> target, Object defaultValue) {
        if (target == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(target.size() + 2);
        for (Object element : target) {
            result2.add(this.defaultString(element, defaultValue));
        }
        return result2;
    }
}

