/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.messageresolver;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.TemplateData;
import org.thymeleaf.messageresolver.AbstractMessageResolver;
import org.thymeleaf.messageresolver.StandardMessageResolutionUtils;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.util.Validate;

public class StandardMessageResolver
extends AbstractMessageResolver {
    private final ConcurrentHashMap<String, ConcurrentHashMap<Locale, Map<String, String>>> messagesByLocaleByTemplate = new ConcurrentHashMap(20, 0.9f, 2);
    private final ConcurrentHashMap<Class<?>, ConcurrentHashMap<Locale, Map<String, String>>> messagesByLocaleByOrigin = new ConcurrentHashMap(20, 0.9f, 2);
    private final Properties defaultMessages = new Properties();

    public final Properties getDefaultMessages() {
        return this.defaultMessages;
    }

    public final void setDefaultMessages(Properties defaultMessages) {
        if (defaultMessages != null) {
            this.defaultMessages.putAll((Map<?, ?>)defaultMessages);
        }
    }

    public final void addDefaultMessage(String key2, String value2) {
        Validate.notNull(key2, "Key for default message cannot be null");
        Validate.notNull(value2, "Value for default message cannot be null");
        this.defaultMessages.put(key2, value2);
    }

    public final void clearDefaultMessages() {
        this.defaultMessages.clear();
    }

    @Override
    public final String resolveMessage(ITemplateContext context, Class<?> origin2, String key2, Object[] messageParameters) {
        return this.resolveMessage(context, origin2, key2, messageParameters, true, true, true);
    }

    public final String resolveMessage(ITemplateContext context, Class<?> origin2, String key2, Object[] messageParameters, boolean performTemplateBasedResolution, boolean performOriginBasedResolution, boolean performDefaultBasedResolution) {
        String message;
        Validate.notNull(context, "Context cannot be null");
        Validate.notNull(context.getLocale(), "Locale in context cannot be null");
        Validate.notNull(key2, "Message key cannot be null");
        Locale locale = context.getLocale();
        if (performTemplateBasedResolution) {
            for (TemplateData templateData : context.getTemplateStack()) {
                String message2;
                Map<String, String> messagesForLocaleForTemplate;
                String template = templateData.getTemplate();
                ITemplateResource templateResource = templateData.getTemplateResource();
                boolean templateCacheable = templateData.getValidity().isCacheable();
                if (templateCacheable) {
                    ConcurrentHashMap<Locale, Map<String, String>> messagesByLocaleForTemplate = this.messagesByLocaleByTemplate.get(template);
                    if (messagesByLocaleForTemplate == null) {
                        this.messagesByLocaleByTemplate.putIfAbsent(template, new ConcurrentHashMap(4));
                        messagesByLocaleForTemplate = this.messagesByLocaleByTemplate.get(template);
                    }
                    if ((messagesForLocaleForTemplate = messagesByLocaleForTemplate.get(locale)) == null) {
                        messagesForLocaleForTemplate = this.resolveMessagesForTemplate(template, templateResource, locale);
                        if (messagesForLocaleForTemplate == null) {
                            messagesForLocaleForTemplate = Collections.emptyMap();
                        }
                        messagesByLocaleForTemplate.putIfAbsent(locale, messagesForLocaleForTemplate);
                        messagesForLocaleForTemplate = messagesByLocaleForTemplate.get(locale);
                    }
                } else {
                    messagesForLocaleForTemplate = this.resolveMessagesForTemplate(template, templateResource, locale);
                    if (messagesForLocaleForTemplate == null) {
                        messagesForLocaleForTemplate = Collections.emptyMap();
                    }
                }
                if ((message2 = messagesForLocaleForTemplate.get(key2)) == null) continue;
                return this.formatMessage(locale, message2, messageParameters);
            }
        }
        if (performOriginBasedResolution && origin2 != null) {
            String message3;
            Map<String, String> messagesForLocaleForOrigin;
            ConcurrentHashMap<Locale, Map<String, String>> messagesByLocaleForOrigin = this.messagesByLocaleByOrigin.get(origin2);
            if (messagesByLocaleForOrigin == null) {
                this.messagesByLocaleByOrigin.putIfAbsent(origin2, new ConcurrentHashMap(4));
                messagesByLocaleForOrigin = this.messagesByLocaleByOrigin.get(origin2);
            }
            if ((messagesForLocaleForOrigin = messagesByLocaleForOrigin.get(locale)) == null) {
                messagesForLocaleForOrigin = this.resolveMessagesForOrigin(origin2, locale);
                if (messagesForLocaleForOrigin == null) {
                    messagesForLocaleForOrigin = Collections.emptyMap();
                }
                messagesByLocaleForOrigin.putIfAbsent(locale, messagesForLocaleForOrigin);
                messagesForLocaleForOrigin = messagesByLocaleForOrigin.get(locale);
            }
            if ((message3 = messagesForLocaleForOrigin.get(key2)) != null) {
                return this.formatMessage(locale, message3, messageParameters);
            }
        }
        if (performDefaultBasedResolution && this.defaultMessages != null && (message = this.defaultMessages.getProperty(key2)) != null) {
            return this.formatMessage(locale, message, messageParameters);
        }
        return null;
    }

    protected Map<String, String> resolveMessagesForTemplate(String template, ITemplateResource templateResource, Locale locale) {
        return StandardMessageResolutionUtils.resolveMessagesForTemplate(templateResource, locale);
    }

    protected Map<String, String> resolveMessagesForOrigin(Class<?> origin2, Locale locale) {
        return StandardMessageResolutionUtils.resolveMessagesForOrigin(origin2, locale);
    }

    protected String formatMessage(Locale locale, String message, Object[] messageParameters) {
        return StandardMessageResolutionUtils.formatMessage(locale, message, messageParameters);
    }

    @Override
    public String createAbsentMessageRepresentation(ITemplateContext context, Class<?> origin2, String key2, Object[] messageParameters) {
        Validate.notNull(key2, "Message key cannot be null");
        if (context.getLocale() != null) {
            return "??" + key2 + "_" + context.getLocale().toString() + "??";
        }
        return "??" + key2 + "_??";
    }
}

