/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.cdatasection;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.ICDATASection;
import org.thymeleaf.processor.AbstractProcessor;
import org.thymeleaf.processor.cdatasection.ICDATASectionProcessor;
import org.thymeleaf.processor.cdatasection.ICDATASectionStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;

public abstract class AbstractCDATASectionProcessor
extends AbstractProcessor
implements ICDATASectionProcessor {
    public AbstractCDATASectionProcessor(TemplateMode templateMode, int precedence) {
        super(templateMode, precedence);
    }

    @Override
    public final void process(ITemplateContext context, ICDATASection cdataSection, ICDATASectionStructureHandler structureHandler) {
        try {
            this.doProcess(context, cdataSection, structureHandler);
        }
        catch (TemplateProcessingException e2) {
            if (cdataSection.hasLocation()) {
                if (!e2.hasTemplateName()) {
                    e2.setTemplateName(cdataSection.getTemplateName());
                }
                if (!e2.hasLineAndCol()) {
                    e2.setLineAndCol(cdataSection.getLine(), cdataSection.getCol());
                }
            }
            throw e2;
        }
        catch (Exception e3) {
            throw new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", cdataSection.getTemplateName(), cdataSection.getLine(), cdataSection.getCol(), e3);
        }
    }

    protected abstract void doProcess(ITemplateContext var1, ICDATASection var2, ICDATASectionStructureHandler var3);
}

