/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.doctype;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IDocType;
import org.thymeleaf.processor.AbstractProcessor;
import org.thymeleaf.processor.doctype.IDocTypeProcessor;
import org.thymeleaf.processor.doctype.IDocTypeStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;

public abstract class AbstractDocTypeProcessor
extends AbstractProcessor
implements IDocTypeProcessor {
    public AbstractDocTypeProcessor(TemplateMode templateMode, int precedence) {
        super(templateMode, precedence);
    }

    @Override
    public final void process(ITemplateContext context, IDocType docType, IDocTypeStructureHandler structureHandler) {
        try {
            this.doProcess(context, docType, structureHandler);
        }
        catch (TemplateProcessingException e2) {
            if (docType.hasLocation()) {
                if (!e2.hasTemplateName()) {
                    e2.setTemplateName(docType.getTemplateName());
                }
                if (!e2.hasLineAndCol()) {
                    e2.setLineAndCol(docType.getLine(), docType.getCol());
                }
            }
            throw e2;
        }
        catch (Exception e3) {
            throw new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", docType.getTemplateName(), docType.getLine(), docType.getCol(), e3);
        }
    }

    protected abstract void doProcess(ITemplateContext var1, IDocType var2, IDocTypeStructureHandler var3);
}

