/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.element;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IAttribute;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractElementTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.EscapedAttributeUtils;
import org.thymeleaf.util.Validate;

public abstract class AbstractAttributeTagProcessor
extends AbstractElementTagProcessor {
    private final boolean removeAttribute;

    protected AbstractAttributeTagProcessor(TemplateMode templateMode, String dialectPrefix, String elementName, boolean prefixElementName, String attributeName, boolean prefixAttributeName, int precedence, boolean removeAttribute) {
        super(templateMode, dialectPrefix, elementName, prefixElementName, attributeName, prefixAttributeName, precedence);
        Validate.notEmpty(attributeName, "Attribute name cannot be null or empty in Attribute Tag Processor");
        this.removeAttribute = removeAttribute;
    }

    @Override
    protected final void doProcess(ITemplateContext context, IProcessableElementTag tag, IElementTagStructureHandler structureHandler) {
        AttributeName attributeName = null;
        try {
            attributeName = this.getMatchingAttributeName().getMatchingAttributeName();
            String attributeValue = EscapedAttributeUtils.unescapeAttribute(context.getTemplateMode(), tag.getAttributeValue(attributeName));
            this.doProcess(context, tag, attributeName, attributeValue, structureHandler);
            if (this.removeAttribute) {
                structureHandler.removeAttribute(attributeName);
            }
        }
        catch (TemplateProcessingException e2) {
            if (tag.hasLocation()) {
                if (!e2.hasTemplateName()) {
                    e2.setTemplateName(tag.getTemplateName());
                }
                if (!e2.hasLineAndCol()) {
                    if (attributeName == null) {
                        e2.setLineAndCol(tag.getLine(), tag.getCol());
                    } else {
                        IAttribute attribute = tag.getAttribute(attributeName);
                        if (attribute != null) {
                            e2.setLineAndCol(attribute.getLine(), attribute.getCol());
                        }
                    }
                }
            }
            throw e2;
        }
        catch (Exception e3) {
            IAttribute attribute;
            int line = tag.getLine();
            int col = tag.getCol();
            if (attributeName != null && (attribute = tag.getAttribute(attributeName)) != null) {
                line = attribute.getLine();
                col = attribute.getCol();
            }
            throw new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", tag.getTemplateName(), line, col, e3);
        }
    }

    protected abstract void doProcess(ITemplateContext var1, IProcessableElementTag var2, AttributeName var3, String var4, IElementTagStructureHandler var5);
}

