/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.element;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeNames;
import org.thymeleaf.engine.ElementNames;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.processor.AbstractProcessor;
import org.thymeleaf.processor.element.IElementModelProcessor;
import org.thymeleaf.processor.element.IElementModelStructureHandler;
import org.thymeleaf.processor.element.MatchingAttributeName;
import org.thymeleaf.processor.element.MatchingElementName;
import org.thymeleaf.templatemode.TemplateMode;

public abstract class AbstractElementModelProcessor
extends AbstractProcessor
implements IElementModelProcessor {
    private final String dialectPrefix;
    private final MatchingElementName matchingElementName;
    private final MatchingAttributeName matchingAttributeName;

    public AbstractElementModelProcessor(TemplateMode templateMode, String dialectPrefix, String elementName, boolean prefixElementName, String attributeName, boolean prefixAttributeName, int precedence) {
        super(templateMode, precedence);
        this.dialectPrefix = dialectPrefix;
        MatchingElementName matchingElementName = elementName == null ? null : (this.matchingElementName = MatchingElementName.forElementName(templateMode, ElementNames.forName(templateMode, prefixElementName ? this.dialectPrefix : null, elementName)));
        this.matchingAttributeName = attributeName == null ? null : MatchingAttributeName.forAttributeName(templateMode, AttributeNames.forName(templateMode, prefixAttributeName ? this.dialectPrefix : null, attributeName));
    }

    protected final String getDialectPrefix() {
        return this.dialectPrefix;
    }

    @Override
    public final MatchingElementName getMatchingElementName() {
        return this.matchingElementName;
    }

    @Override
    public final MatchingAttributeName getMatchingAttributeName() {
        return this.matchingAttributeName;
    }

    @Override
    public final void process(ITemplateContext context, IModel model, IElementModelStructureHandler structureHandler) {
        ITemplateEvent firstEvent = null;
        try {
            firstEvent = model.get(0);
            this.doProcess(context, model, structureHandler);
        }
        catch (TemplateProcessingException e2) {
            if (firstEvent != null) {
                String modelTemplateName = firstEvent.getTemplateName();
                int modelLine = firstEvent.getLine();
                int modelCol = firstEvent.getCol();
                if (modelTemplateName != null && !e2.hasTemplateName()) {
                    e2.setTemplateName(modelTemplateName);
                }
                if (modelLine != -1 && modelCol != -1 && !e2.hasLineAndCol()) {
                    e2.setLineAndCol(modelLine, modelCol);
                }
            }
            throw e2;
        }
        catch (Exception e3) {
            String modelTemplateName = null;
            int modelLine = -1;
            int modelCol = -1;
            if (firstEvent != null) {
                modelTemplateName = firstEvent.getTemplateName();
                modelLine = firstEvent.getLine();
                modelCol = firstEvent.getCol();
            }
            throw new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", modelTemplateName, modelLine, modelCol, e3);
        }
    }

    protected abstract void doProcess(ITemplateContext var1, IModel var2, IElementModelStructureHandler var3);
}

