/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.element;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeNames;
import org.thymeleaf.engine.ElementNames;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.AbstractProcessor;
import org.thymeleaf.processor.element.IElementTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.processor.element.MatchingAttributeName;
import org.thymeleaf.processor.element.MatchingElementName;
import org.thymeleaf.templatemode.TemplateMode;

public abstract class AbstractElementTagProcessor
extends AbstractProcessor
implements IElementTagProcessor {
    private final String dialectPrefix;
    private final MatchingElementName matchingElementName;
    private final MatchingAttributeName matchingAttributeName;

    public AbstractElementTagProcessor(TemplateMode templateMode, String dialectPrefix, String elementName, boolean prefixElementName, String attributeName, boolean prefixAttributeName, int precedence) {
        super(templateMode, precedence);
        this.dialectPrefix = dialectPrefix;
        MatchingElementName matchingElementName = elementName == null ? null : (this.matchingElementName = MatchingElementName.forElementName(templateMode, ElementNames.forName(templateMode, prefixElementName ? this.dialectPrefix : null, elementName)));
        this.matchingAttributeName = attributeName == null ? null : MatchingAttributeName.forAttributeName(templateMode, AttributeNames.forName(templateMode, prefixAttributeName ? this.dialectPrefix : null, attributeName));
    }

    protected final String getDialectPrefix() {
        return this.dialectPrefix;
    }

    @Override
    public final MatchingElementName getMatchingElementName() {
        return this.matchingElementName;
    }

    @Override
    public final MatchingAttributeName getMatchingAttributeName() {
        return this.matchingAttributeName;
    }

    @Override
    public final void process(ITemplateContext context, IProcessableElementTag tag, IElementTagStructureHandler structureHandler) {
        try {
            this.doProcess(context, tag, structureHandler);
        }
        catch (TemplateProcessingException e2) {
            if (tag.hasLocation()) {
                if (!e2.hasTemplateName()) {
                    e2.setTemplateName(tag.getTemplateName());
                }
                if (!e2.hasLineAndCol()) {
                    e2.setLineAndCol(tag.getLine(), tag.getCol());
                }
            }
            throw e2;
        }
        catch (Exception e3) {
            throw new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", tag.getTemplateName(), tag.getLine(), tag.getCol(), e3);
        }
    }

    protected abstract void doProcess(ITemplateContext var1, IProcessableElementTag var2, IElementTagStructureHandler var3);
}

