/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.templateboundaries;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.ITemplateEnd;
import org.thymeleaf.model.ITemplateStart;
import org.thymeleaf.processor.AbstractProcessor;
import org.thymeleaf.processor.templateboundaries.ITemplateBoundariesProcessor;
import org.thymeleaf.processor.templateboundaries.ITemplateBoundariesStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;

public abstract class AbstractTemplateBoundariesProcessor
extends AbstractProcessor
implements ITemplateBoundariesProcessor {
    public AbstractTemplateBoundariesProcessor(TemplateMode templateMode, int precedence) {
        super(templateMode, precedence);
    }

    @Override
    public final void processTemplateStart(ITemplateContext context, ITemplateStart templateStart, ITemplateBoundariesStructureHandler structureHandler) {
        try {
            this.doProcessTemplateStart(context, templateStart, structureHandler);
        }
        catch (TemplateProcessingException e2) {
            if (templateStart.hasLocation()) {
                if (!e2.hasTemplateName()) {
                    e2.setTemplateName(templateStart.getTemplateName());
                }
                if (!e2.hasLineAndCol()) {
                    e2.setLineAndCol(templateStart.getLine(), templateStart.getCol());
                }
            }
            throw e2;
        }
        catch (Exception e3) {
            throw new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", templateStart.getTemplateName(), templateStart.getLine(), templateStart.getCol(), e3);
        }
    }

    @Override
    public final void processTemplateEnd(ITemplateContext context, ITemplateEnd templateEnd, ITemplateBoundariesStructureHandler structureHandler) {
        try {
            this.doProcessTemplateEnd(context, templateEnd, structureHandler);
        }
        catch (TemplateProcessingException e2) {
            if (templateEnd.hasLocation()) {
                if (!e2.hasTemplateName()) {
                    e2.setTemplateName(templateEnd.getTemplateName());
                }
                if (!e2.hasLineAndCol()) {
                    e2.setLineAndCol(templateEnd.getLine(), templateEnd.getCol());
                }
            }
            throw e2;
        }
        catch (Exception e3) {
            throw new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", templateEnd.getTemplateName(), templateEnd.getLine(), templateEnd.getCol(), e3);
        }
    }

    public abstract void doProcessTemplateStart(ITemplateContext var1, ITemplateStart var2, ITemplateBoundariesStructureHandler var3);

    public abstract void doProcessTemplateEnd(ITemplateContext var1, ITemplateEnd var2, ITemplateBoundariesStructureHandler var3);
}

